import * as cdk from '@aws-cdk/core';
import { PolicyStatement } from './policy-statement';
/**
 * Properties for a new PolicyDocument
 */
export interface PolicyDocumentProps {
    /**
     * Automatically assign Statement Ids to all statements
     *
     * @default false
     */
    readonly assignSids?: boolean;
    /**
     * Initial statements to add to the policy document
     *
     * @default - No statements
     */
    readonly statements?: PolicyStatement[];
}
/**
 * A PolicyDocument is a collection of statements
 */
export declare class PolicyDocument implements cdk.IResolvable {
    /**
     * Creates a new PolicyDocument based on the object provided.
     * This will accept an object created from the `.toJSON()` call
     * @param obj the PolicyDocument in object form.
     */
    static fromJson(obj: any): PolicyDocument;
    readonly creationStack: string[];
    private readonly statements;
    private readonly autoAssignSids;
    constructor(props?: PolicyDocumentProps);
    resolve(context: cdk.IResolveContext): any;
    get isEmpty(): boolean;
    /**
     * The number of statements already added to this policy.
     * Can be used, for example, to generate uniuqe "sid"s within the policy.
     */
    get statementCount(): number;
    /**
     * Adds a statement to the policy document.
     *
     * @param statement the statement to add.
     */
    addStatements(...statement: PolicyStatement[]): void;
    /**
     * Encode the policy document as a string
     */
    toString(): string;
    /**
     * JSON-ify the document
     *
     * Used when JSON.stringify() is called
     */
    toJSON(): any;
    private render;
}
