"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
/**
 * An immutable wrapper around an IRole
 *
 * This wrapper ignores all mutating operations, like attaching policies or
 * adding policy statements.
 *
 * Useful in cases where you want to turn off CDK's automatic permissions
 * management, and instead have full control over all permissions.
 *
 * Note: if you want to ignore all mutations for an externally defined role
 * which was imported into the CDK with {@link Role.fromRoleArn}, you don't have to use this class -
 * simply pass the property mutable = false when calling {@link Role.fromRoleArn}.
 */
class ImmutableRole extends core_1.Construct {
    constructor(scope, id, role) {
        super(scope, id);
        this.role = role;
        this.assumeRoleAction = this.role.assumeRoleAction;
        this.policyFragment = this.role.policyFragment;
        this.grantPrincipal = this;
        this.roleArn = this.role.roleArn;
        this.roleName = this.role.roleName;
        this.stack = this.role.stack;
        // implement IDependable privately
        core_1.DependableTrait.implement(this, {
            dependencyRoots: [role]
        });
    }
    attachInlinePolicy(_policy) {
        // do nothing
    }
    addManagedPolicy(_policy) {
        // do nothing
    }
    addToPolicy(_statement) {
        // Not really added, but for the purposes of consumer code pretend that it was.
        return true;
    }
    grant(grantee, ...actions) {
        return this.role.grant(grantee, ...actions);
    }
    grantPassRole(grantee) {
        return this.role.grantPassRole(grantee);
    }
}
exports.ImmutableRole = ImmutableRole;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW1tdXRhYmxlLXJvbGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbW11dGFibGUtcm9sZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLHdDQUEyRDtBQVEzRDs7Ozs7Ozs7Ozs7O0dBWUc7QUFDSCxNQUFhLGFBQWMsU0FBUSxnQkFBUztJQVExQyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFtQixJQUFXO1FBQ3BFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFEd0MsU0FBSSxHQUFKLElBQUksQ0FBTztRQVB0RCxxQkFBZ0IsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDO1FBQzlDLG1CQUFjLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUM7UUFDMUMsbUJBQWMsR0FBRyxJQUFJLENBQUM7UUFDdEIsWUFBTyxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDO1FBQzVCLGFBQVEsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQztRQUM5QixVQUFLLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUM7UUFLdEMsa0NBQWtDO1FBQ2xDLHNCQUFlLENBQUMsU0FBUyxDQUFDLElBQUksRUFBRTtZQUM5QixlQUFlLEVBQUUsQ0FBRSxJQUFJLENBQUU7U0FDMUIsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVNLGtCQUFrQixDQUFDLE9BQWU7UUFDdkMsYUFBYTtJQUNmLENBQUM7SUFFTSxnQkFBZ0IsQ0FBQyxPQUF1QjtRQUM3QyxhQUFhO0lBQ2YsQ0FBQztJQUVNLFdBQVcsQ0FBQyxVQUEyQjtRQUM1QywrRUFBK0U7UUFDL0UsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRU0sS0FBSyxDQUFDLE9BQW1CLEVBQUUsR0FBRyxPQUFpQjtRQUNwRCxPQUFPLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sRUFBRSxHQUFHLE9BQU8sQ0FBQyxDQUFDO0lBQzlDLENBQUM7SUFFTSxhQUFhLENBQUMsT0FBbUI7UUFDdEMsT0FBTyxJQUFJLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUMxQyxDQUFDO0NBQ0Y7QUFyQ0Qsc0NBcUNDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29uc3RydWN0LCBEZXBlbmRhYmxlVHJhaXQgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IEdyYW50IH0gZnJvbSAnLi4vZ3JhbnQnO1xuaW1wb3J0IHsgSU1hbmFnZWRQb2xpY3kgfSBmcm9tICcuLi9tYW5hZ2VkLXBvbGljeSc7XG5pbXBvcnQgeyBQb2xpY3kgfSBmcm9tICcuLi9wb2xpY3knO1xuaW1wb3J0IHsgUG9saWN5U3RhdGVtZW50IH0gZnJvbSAnLi4vcG9saWN5LXN0YXRlbWVudCc7XG5pbXBvcnQgeyBJUHJpbmNpcGFsIH0gZnJvbSAnLi4vcHJpbmNpcGFscyc7XG5pbXBvcnQgeyBJUm9sZSB9IGZyb20gJy4uL3JvbGUnO1xuXG4vKipcbiAqIEFuIGltbXV0YWJsZSB3cmFwcGVyIGFyb3VuZCBhbiBJUm9sZVxuICpcbiAqIFRoaXMgd3JhcHBlciBpZ25vcmVzIGFsbCBtdXRhdGluZyBvcGVyYXRpb25zLCBsaWtlIGF0dGFjaGluZyBwb2xpY2llcyBvclxuICogYWRkaW5nIHBvbGljeSBzdGF0ZW1lbnRzLlxuICpcbiAqIFVzZWZ1bCBpbiBjYXNlcyB3aGVyZSB5b3Ugd2FudCB0byB0dXJuIG9mZiBDREsncyBhdXRvbWF0aWMgcGVybWlzc2lvbnNcbiAqIG1hbmFnZW1lbnQsIGFuZCBpbnN0ZWFkIGhhdmUgZnVsbCBjb250cm9sIG92ZXIgYWxsIHBlcm1pc3Npb25zLlxuICpcbiAqIE5vdGU6IGlmIHlvdSB3YW50IHRvIGlnbm9yZSBhbGwgbXV0YXRpb25zIGZvciBhbiBleHRlcm5hbGx5IGRlZmluZWQgcm9sZVxuICogd2hpY2ggd2FzIGltcG9ydGVkIGludG8gdGhlIENESyB3aXRoIHtAbGluayBSb2xlLmZyb21Sb2xlQXJufSwgeW91IGRvbid0IGhhdmUgdG8gdXNlIHRoaXMgY2xhc3MgLVxuICogc2ltcGx5IHBhc3MgdGhlIHByb3BlcnR5IG11dGFibGUgPSBmYWxzZSB3aGVuIGNhbGxpbmcge0BsaW5rIFJvbGUuZnJvbVJvbGVBcm59LlxuICovXG5leHBvcnQgY2xhc3MgSW1tdXRhYmxlUm9sZSBleHRlbmRzIENvbnN0cnVjdCBpbXBsZW1lbnRzIElSb2xlIHtcbiAgcHVibGljIHJlYWRvbmx5IGFzc3VtZVJvbGVBY3Rpb24gPSB0aGlzLnJvbGUuYXNzdW1lUm9sZUFjdGlvbjtcbiAgcHVibGljIHJlYWRvbmx5IHBvbGljeUZyYWdtZW50ID0gdGhpcy5yb2xlLnBvbGljeUZyYWdtZW50O1xuICBwdWJsaWMgcmVhZG9ubHkgZ3JhbnRQcmluY2lwYWwgPSB0aGlzO1xuICBwdWJsaWMgcmVhZG9ubHkgcm9sZUFybiA9IHRoaXMucm9sZS5yb2xlQXJuO1xuICBwdWJsaWMgcmVhZG9ubHkgcm9sZU5hbWUgPSB0aGlzLnJvbGUucm9sZU5hbWU7XG4gIHB1YmxpYyByZWFkb25seSBzdGFjayA9IHRoaXMucm9sZS5zdGFjaztcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcml2YXRlIHJlYWRvbmx5IHJvbGU6IElSb2xlKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIC8vIGltcGxlbWVudCBJRGVwZW5kYWJsZSBwcml2YXRlbHlcbiAgICBEZXBlbmRhYmxlVHJhaXQuaW1wbGVtZW50KHRoaXMsIHtcbiAgICAgIGRlcGVuZGVuY3lSb290czogWyByb2xlIF1cbiAgICB9KTtcbiAgfVxuXG4gIHB1YmxpYyBhdHRhY2hJbmxpbmVQb2xpY3koX3BvbGljeTogUG9saWN5KTogdm9pZCB7XG4gICAgLy8gZG8gbm90aGluZ1xuICB9XG5cbiAgcHVibGljIGFkZE1hbmFnZWRQb2xpY3koX3BvbGljeTogSU1hbmFnZWRQb2xpY3kpOiB2b2lkIHtcbiAgICAvLyBkbyBub3RoaW5nXG4gIH1cblxuICBwdWJsaWMgYWRkVG9Qb2xpY3koX3N0YXRlbWVudDogUG9saWN5U3RhdGVtZW50KTogYm9vbGVhbiB7XG4gICAgLy8gTm90IHJlYWxseSBhZGRlZCwgYnV0IGZvciB0aGUgcHVycG9zZXMgb2YgY29uc3VtZXIgY29kZSBwcmV0ZW5kIHRoYXQgaXQgd2FzLlxuICAgIHJldHVybiB0cnVlO1xuICB9XG5cbiAgcHVibGljIGdyYW50KGdyYW50ZWU6IElQcmluY2lwYWwsIC4uLmFjdGlvbnM6IHN0cmluZ1tdKTogR3JhbnQge1xuICAgIHJldHVybiB0aGlzLnJvbGUuZ3JhbnQoZ3JhbnRlZSwgLi4uYWN0aW9ucyk7XG4gIH1cblxuICBwdWJsaWMgZ3JhbnRQYXNzUm9sZShncmFudGVlOiBJUHJpbmNpcGFsKTogR3JhbnQge1xuICAgIHJldHVybiB0aGlzLnJvbGUuZ3JhbnRQYXNzUm9sZShncmFudGVlKTtcbiAgfVxufSJdfQ==