# coding: utf-8

"""
    ACROSS Server

    Server providing tools and utilities for various NASA missions to aid in coordination of large observation efforts.

    The version of the OpenAPI document: 1.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List
from across.sdk.v1.models.visibility_window import VisibilityWindow
from typing import Optional, Set
from typing_extensions import Self

class JointVisibilityResult(BaseModel):
    """
    A Pydantic model class representing the joint visibility calculation parameters.  This class is used for joint visibility calculations in the ACROSS SSA system.  Parameters ---------- instrument_ids: list[UUID]     List of instrument IDs to check visibility against visibility_windows: list[VisibilityWindow]     List of joint visibility windows for all the instruments observatory_visibility_windows: dict[UUID, list[VisibilityWindow]]     Dictionary mapping instrument IDs to their respective visibility windows
    """ # noqa: E501
    instrument_ids: List[StrictStr]
    visibility_windows: List[VisibilityWindow]
    observatory_visibility_windows: Dict[str, List[VisibilityWindow]]
    __properties: ClassVar[List[str]] = ["instrument_ids", "visibility_windows", "observatory_visibility_windows"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JointVisibilityResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in visibility_windows (list)
        _items = []
        if self.visibility_windows:
            for _item_visibility_windows in self.visibility_windows:
                if _item_visibility_windows:
                    _items.append(_item_visibility_windows.to_dict())
            _dict['visibility_windows'] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in observatory_visibility_windows (dict of array)
        _field_dict_of_array = {}
        if self.observatory_visibility_windows:
            for _key_observatory_visibility_windows in self.observatory_visibility_windows:
                if self.observatory_visibility_windows[_key_observatory_visibility_windows] is not None:
                    _field_dict_of_array[_key_observatory_visibility_windows] = [
                        _item.to_dict() for _item in self.observatory_visibility_windows[_key_observatory_visibility_windows]
                    ]
            _dict['observatory_visibility_windows'] = _field_dict_of_array
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JointVisibilityResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "instrument_ids": obj.get("instrument_ids"),
            "visibility_windows": [VisibilityWindow.from_dict(_item) for _item in obj["visibility_windows"]] if obj.get("visibility_windows") is not None else None,
            "observatory_visibility_windows": dict(
                (_k,
                        [VisibilityWindow.from_dict(_item) for _item in _v]
                        if _v is not None
                        else None
                )
                for _k, _v in obj.get("observatory_visibility_windows", {}).items()
            )
        })
        return _obj


