# coding: utf-8

"""
Earnix Elevate Data API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""


from typing import Dict, List

from pydantic.v1 import Field, StrictInt, StrictStr, validate_arguments
from typing_extensions import Annotated

from earnix_elevate.clients.data.api_client import ApiClient
from earnix_elevate.clients.data.api_response import ApiResponse
from earnix_elevate.clients.data.exceptions import ApiTypeError
from earnix_elevate.clients.data.models.create_data_table_request import (
    CreateDataTableRequest,
)
from earnix_elevate.clients.data.models.data_table_response import DataTableResponse
from earnix_elevate.clients.data.models.data_version_response import DataVersionResponse
from earnix_elevate.clients.data.models.export_s3_job_status_response import (
    ExportS3JobStatusResponse,
)
from earnix_elevate.clients.data.models.export_s3_part_job_status_response import (
    ExportS3PartJobStatusResponse,
)
from earnix_elevate.clients.data.models.export_s3_part_request import (
    ExportS3PartRequest,
)
from earnix_elevate.clients.data.models.export_s3_part_response import (
    ExportS3PartResponse,
)
from earnix_elevate.clients.data.models.export_s3_request import ExportS3Request
from earnix_elevate.clients.data.models.export_s3_response import ExportS3Response
from earnix_elevate.clients.data.models.schema_analysis_status_response import (
    SchemaAnalysisStatusResponse,
)
from earnix_elevate.clients.data.models.update_data_table_request import (
    UpdateDataTableRequest,
)


class DataTableServiceApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_data_table(
        self,
        create_data_table_request: Annotated[
            CreateDataTableRequest,
            Field(
                ...,
                description="Request body containing the configuration details needed to create a new DataTable, including name, description, and DataSource reference",
            ),
        ],
        **kwargs,
    ) -> DataTableResponse:
        """Creates a new DataTable that serves as a container for imported data within the system. The DataTable will be associated with a specific DataSource and can later contain multiple versions of data imported from that source.

        :param create_data_table_request: Request body containing the configuration details needed to create a new DataTable, including name, description, and DataSource reference (required)
        :type create_data_table_request: CreateDataTableRequest
        :return: Returns the result object.
        :rtype: DataTableResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the create_data_table_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.create_data_table_with_http_info(
            create_data_table_request, **kwargs
        )

    @validate_arguments
    def create_data_table_with_http_info(
        self,
        create_data_table_request: Annotated[
            CreateDataTableRequest,
            Field(
                ...,
                description="Request body containing the configuration details needed to create a new DataTable, including name, description, and DataSource reference",
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Creates a new DataTable that serves as a container for imported data within the system. The DataTable will be associated with a specific DataSource and can later contain multiple versions of data imported from that source.

        :param create_data_table_request: Request body containing the configuration details needed to create a new DataTable, including name, description, and DataSource reference (required)
        :type create_data_table_request: CreateDataTableRequest
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(DataTableResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["create_data_table_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_data_table" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["create_data_table_request"] is not None:
            _body_params = _params["create_data_table_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "DataTableResponse",
        }

        return self.api_client.call_api(
            "/v1/data-tables",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def create_data_version(
        self,
        data_table_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataTable to operate on"),
        ],
        **kwargs,
    ) -> DataVersionResponse:
        """Creates a new data version for the specified DataTable by importing data from the associated DataSource. This operation triggers the data ingestion process and returns the newly created version with its initial status.

        :param data_table_id: Unique identifier of the DataTable to operate on (required)
        :type data_table_id: int
        :return: Returns the result object.
        :rtype: DataVersionResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the create_data_version_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.create_data_version_with_http_info(data_table_id, **kwargs)

    @validate_arguments
    def create_data_version_with_http_info(
        self,
        data_table_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataTable to operate on"),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Creates a new data version for the specified DataTable by importing data from the associated DataSource. This operation triggers the data ingestion process and returns the newly created version with its initial status.

        :param data_table_id: Unique identifier of the DataTable to operate on (required)
        :type data_table_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(DataVersionResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["data_table_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_data_version" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_table_id"] is not None:
            _path_params["data-table-id"] = _params["data_table_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "DataVersionResponse",
        }

        return self.api_client.call_api(
            "/v1/data-tables/{data-table-id}/data-versions",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def delete_data_table(
        self,
        data_table_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataTable to operate on"),
        ],
        **kwargs,
    ) -> None:
        """Marks a DataTable for deletion (soft delete). The DataTable is not immediately removed but marked for deletion. All data versions associated with the DataTable are also deleted. A background cleaner job will later purge the actual data from storage and remove the entities from the database. Returns NOT_FOUND if the DataTable does not exist.

        :param data_table_id: Unique identifier of the DataTable to operate on (required)
        :type data_table_id: int
        :return: Returns the result object.
        :rtype: None
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the delete_data_table_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.delete_data_table_with_http_info(data_table_id, **kwargs)

    @validate_arguments
    def delete_data_table_with_http_info(
        self,
        data_table_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataTable to operate on"),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Marks a DataTable for deletion (soft delete). The DataTable is not immediately removed but marked for deletion. All data versions associated with the DataTable are also deleted. A background cleaner job will later purge the actual data from storage and remove the entities from the database. Returns NOT_FOUND if the DataTable does not exist.

        :param data_table_id: Unique identifier of the DataTable to operate on (required)
        :type data_table_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: None
        """

        _params = locals()

        _all_params = ["data_table_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_data_table" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_table_id"] is not None:
            _path_params["data-table-id"] = _params["data_table_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {}

        return self.api_client.call_api(
            "/v1/data-tables/{data-table-id}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def delete_data_version(
        self,
        data_table_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataTable to operate on"),
        ],
        data_version_number: Annotated[
            StrictInt,
            Field(..., description="Version number of the data within the DataTable"),
        ],
        **kwargs,
    ) -> None:
        """Permanently deletes a specific data version from a DataTable. This operation removes the data version entity from the database and kills any running import job associated with that version. If the deleted version is the latest version, the DataTable's latest version number is updated to the next available version. Returns NOT_FOUND if the DataTable or data version does not exist.

        :param data_table_id: Unique identifier of the DataTable to operate on (required)
        :type data_table_id: int
        :param data_version_number: Version number of the data within the DataTable (required)
        :type data_version_number: int
        :return: Returns the result object.
        :rtype: None
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the delete_data_version_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.delete_data_version_with_http_info(
            data_table_id, data_version_number, **kwargs
        )

    @validate_arguments
    def delete_data_version_with_http_info(
        self,
        data_table_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataTable to operate on"),
        ],
        data_version_number: Annotated[
            StrictInt,
            Field(..., description="Version number of the data within the DataTable"),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Permanently deletes a specific data version from a DataTable. This operation removes the data version entity from the database and kills any running import job associated with that version. If the deleted version is the latest version, the DataTable's latest version number is updated to the next available version. Returns NOT_FOUND if the DataTable or data version does not exist.

        :param data_table_id: Unique identifier of the DataTable to operate on (required)
        :type data_table_id: int
        :param data_version_number: Version number of the data within the DataTable (required)
        :type data_version_number: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: None
        """

        _params = locals()

        _all_params = ["data_table_id", "data_version_number"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_data_version" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_table_id"] is not None:
            _path_params["data-table-id"] = _params["data_table_id"]

        if _params["data_version_number"] is not None:
            _path_params["data-version-number"] = _params["data_version_number"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {}

        return self.api_client.call_api(
            "/v1/data-tables/{data-table-id}/data-versions/{data-version-number}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def export_data_version_to_s3(
        self,
        data_table_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataTable to operate on"),
        ],
        data_version_number: Annotated[
            StrictInt,
            Field(..., description="Version number of the data within the DataTable"),
        ],
        export_s3_request: Annotated[
            ExportS3Request,
            Field(
                ...,
                description="Request body containing S3 credentials and configuration details for exporting data to Amazon S3",
            ),
        ],
        **kwargs,
    ) -> ExportS3Response:
        """Initiates a single-file export of a specific data version to Amazon S3. This operation exports the entire data version as a single file. Returns a job ID that can be used to track the export progress and retrieve results.

        :param data_table_id: Unique identifier of the DataTable to operate on (required)
        :type data_table_id: int
        :param data_version_number: Version number of the data within the DataTable (required)
        :type data_version_number: int
        :param export_s3_request: Request body containing S3 credentials and configuration details for exporting data to Amazon S3 (required)
        :type export_s3_request: ExportS3Request
        :return: Returns the result object.
        :rtype: ExportS3Response
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the export_data_version_to_s3_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.export_data_version_to_s3_with_http_info(
            data_table_id, data_version_number, export_s3_request, **kwargs
        )

    @validate_arguments
    def export_data_version_to_s3_with_http_info(
        self,
        data_table_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataTable to operate on"),
        ],
        data_version_number: Annotated[
            StrictInt,
            Field(..., description="Version number of the data within the DataTable"),
        ],
        export_s3_request: Annotated[
            ExportS3Request,
            Field(
                ...,
                description="Request body containing S3 credentials and configuration details for exporting data to Amazon S3",
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Initiates a single-file export of a specific data version to Amazon S3. This operation exports the entire data version as a single file. Returns a job ID that can be used to track the export progress and retrieve results.

        :param data_table_id: Unique identifier of the DataTable to operate on (required)
        :type data_table_id: int
        :param data_version_number: Version number of the data within the DataTable (required)
        :type data_version_number: int
        :param export_s3_request: Request body containing S3 credentials and configuration details for exporting data to Amazon S3 (required)
        :type export_s3_request: ExportS3Request
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(ExportS3Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["data_table_id", "data_version_number", "export_s3_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_data_version_to_s3" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_table_id"] is not None:
            _path_params["data-table-id"] = _params["data_table_id"]

        if _params["data_version_number"] is not None:
            _path_params["data-version-number"] = _params["data_version_number"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["export_s3_request"] is not None:
            _body_params = _params["export_s3_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "ExportS3Response",
        }

        return self.api_client.call_api(
            "/v1/data-tables/{data-table-id}/data-versions/{data-version-number}/export-s3",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def export_data_version_to_s3_parts(
        self,
        data_table_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataTable to operate on"),
        ],
        data_version_number: Annotated[
            StrictInt,
            Field(..., description="Version number of the data within the DataTable"),
        ],
        export_s3_part_request: Annotated[
            ExportS3PartRequest,
            Field(
                ...,
                description="Request body containing the list of S3 parts and configuration for multi-part export operations",
            ),
        ],
        **kwargs,
    ) -> ExportS3PartResponse:
        """Initiates a multi-part export of a specific data version to Amazon S3. This operation allows for efficient transfer of large datasets by splitting the export into multiple parts. Returns a job ID that can be used to track the export progress and retrieve results.

        :param data_table_id: Unique identifier of the DataTable to operate on (required)
        :type data_table_id: int
        :param data_version_number: Version number of the data within the DataTable (required)
        :type data_version_number: int
        :param export_s3_part_request: Request body containing the list of S3 parts and configuration for multi-part export operations (required)
        :type export_s3_part_request: ExportS3PartRequest
        :return: Returns the result object.
        :rtype: ExportS3PartResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the export_data_version_to_s3_parts_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.export_data_version_to_s3_parts_with_http_info(
            data_table_id, data_version_number, export_s3_part_request, **kwargs
        )

    @validate_arguments
    def export_data_version_to_s3_parts_with_http_info(
        self,
        data_table_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataTable to operate on"),
        ],
        data_version_number: Annotated[
            StrictInt,
            Field(..., description="Version number of the data within the DataTable"),
        ],
        export_s3_part_request: Annotated[
            ExportS3PartRequest,
            Field(
                ...,
                description="Request body containing the list of S3 parts and configuration for multi-part export operations",
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Initiates a multi-part export of a specific data version to Amazon S3. This operation allows for efficient transfer of large datasets by splitting the export into multiple parts. Returns a job ID that can be used to track the export progress and retrieve results.

        :param data_table_id: Unique identifier of the DataTable to operate on (required)
        :type data_table_id: int
        :param data_version_number: Version number of the data within the DataTable (required)
        :type data_version_number: int
        :param export_s3_part_request: Request body containing the list of S3 parts and configuration for multi-part export operations (required)
        :type export_s3_part_request: ExportS3PartRequest
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(ExportS3PartResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["data_table_id", "data_version_number", "export_s3_part_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_data_version_to_s3_parts" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_table_id"] is not None:
            _path_params["data-table-id"] = _params["data_table_id"]

        if _params["data_version_number"] is not None:
            _path_params["data-version-number"] = _params["data_version_number"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["export_s3_part_request"] is not None:
            _body_params = _params["export_s3_part_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "ExportS3PartResponse",
        }

        return self.api_client.call_api(
            "/v1/data-tables/{data-table-id}/data-versions/{data-version-number}/export-s3-part",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def export_latest_data_version_to_s3_parts(
        self,
        data_table_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataTable to operate on"),
        ],
        export_s3_part_request: Annotated[
            ExportS3PartRequest,
            Field(
                ...,
                description="Request body containing the list of S3 parts and configuration for multi-part export operations",
            ),
        ],
        **kwargs,
    ) -> ExportS3PartResponse:
        """Initiates a multi-part export of the latest data version to Amazon S3. This operation automatically uses the most recent data version available in the DataTable. Returns a job ID that can be used to track the export progress and retrieve results.

        :param data_table_id: Unique identifier of the DataTable to operate on (required)
        :type data_table_id: int
        :param export_s3_part_request: Request body containing the list of S3 parts and configuration for multi-part export operations (required)
        :type export_s3_part_request: ExportS3PartRequest
        :return: Returns the result object.
        :rtype: ExportS3PartResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the export_latest_data_version_to_s3_parts_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.export_latest_data_version_to_s3_parts_with_http_info(
            data_table_id, export_s3_part_request, **kwargs
        )

    @validate_arguments
    def export_latest_data_version_to_s3_parts_with_http_info(
        self,
        data_table_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataTable to operate on"),
        ],
        export_s3_part_request: Annotated[
            ExportS3PartRequest,
            Field(
                ...,
                description="Request body containing the list of S3 parts and configuration for multi-part export operations",
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Initiates a multi-part export of the latest data version to Amazon S3. This operation automatically uses the most recent data version available in the DataTable. Returns a job ID that can be used to track the export progress and retrieve results.

        :param data_table_id: Unique identifier of the DataTable to operate on (required)
        :type data_table_id: int
        :param export_s3_part_request: Request body containing the list of S3 parts and configuration for multi-part export operations (required)
        :type export_s3_part_request: ExportS3PartRequest
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(ExportS3PartResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["data_table_id", "export_s3_part_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_latest_data_version_to_s3_parts" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_table_id"] is not None:
            _path_params["data-table-id"] = _params["data_table_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["export_s3_part_request"] is not None:
            _body_params = _params["export_s3_part_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "ExportS3PartResponse",
        }

        return self.api_client.call_api(
            "/v1/data-tables/{data-table-id}/export-s3-part",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_data_table(
        self,
        data_table_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataTable to operate on"),
        ],
        **kwargs,
    ) -> DataTableResponse:
        """Retrieves detailed information about a specific DataTable including its metadata and latest data version. Connection details are included in the response by default. Returns NOT_FOUND if the DataTable does not exist.

        :param data_table_id: Unique identifier of the DataTable to operate on (required)
        :type data_table_id: int
        :return: Returns the result object.
        :rtype: DataTableResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_data_table_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.get_data_table_with_http_info(data_table_id, **kwargs)

    @validate_arguments
    def get_data_table_with_http_info(
        self,
        data_table_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataTable to operate on"),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Retrieves detailed information about a specific DataTable including its metadata and latest data version. Connection details are included in the response by default. Returns NOT_FOUND if the DataTable does not exist.

        :param data_table_id: Unique identifier of the DataTable to operate on (required)
        :type data_table_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(DataTableResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["data_table_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_table" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_table_id"] is not None:
            _path_params["data-table-id"] = _params["data_table_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "DataTableResponse",
        }

        return self.api_client.call_api(
            "/v1/data-tables/{data-table-id}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_data_table_export_s3_job_status(
        self,
        job_id: Annotated[
            StrictStr,
            Field(..., description="Unique identifier of the background job to query"),
        ],
        **kwargs,
    ) -> ExportS3JobStatusResponse:
        """Retrieves the current status and progress of an S3 export job. Use this endpoint to monitor export operations and determine when they have completed.

        :param job_id: Unique identifier of the background job to query (required)
        :type job_id: str
        :return: Returns the result object.
        :rtype: ExportS3JobStatusResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_data_table_export_s3_job_status_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.get_data_table_export_s3_job_status_with_http_info(job_id, **kwargs)

    @validate_arguments
    def get_data_table_export_s3_job_status_with_http_info(
        self,
        job_id: Annotated[
            StrictStr,
            Field(..., description="Unique identifier of the background job to query"),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Retrieves the current status and progress of an S3 export job. Use this endpoint to monitor export operations and determine when they have completed.

        :param job_id: Unique identifier of the background job to query (required)
        :type job_id: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(ExportS3JobStatusResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["job_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_table_export_s3_job_status" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["job_id"] is not None:
            _path_params["job-id"] = _params["job_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "ExportS3JobStatusResponse",
        }

        return self.api_client.call_api(
            "/v1/data-tables/export-s3/{job-id}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_data_version(
        self,
        data_table_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataTable to operate on"),
        ],
        data_version_number: Annotated[
            StrictInt,
            Field(..., description="Version number of the data within the DataTable"),
        ],
        **kwargs,
    ) -> DataVersionResponse:
        """Retrieves detailed information about a specific data version including its status, metadata, schema information, and processing results. Returns NOT_FOUND if the DataTable or data version does not exist.

        :param data_table_id: Unique identifier of the DataTable to operate on (required)
        :type data_table_id: int
        :param data_version_number: Version number of the data within the DataTable (required)
        :type data_version_number: int
        :return: Returns the result object.
        :rtype: DataVersionResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_data_version_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.get_data_version_with_http_info(
            data_table_id, data_version_number, **kwargs
        )

    @validate_arguments
    def get_data_version_with_http_info(
        self,
        data_table_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataTable to operate on"),
        ],
        data_version_number: Annotated[
            StrictInt,
            Field(..., description="Version number of the data within the DataTable"),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Retrieves detailed information about a specific data version including its status, metadata, schema information, and processing results. Returns NOT_FOUND if the DataTable or data version does not exist.

        :param data_table_id: Unique identifier of the DataTable to operate on (required)
        :type data_table_id: int
        :param data_version_number: Version number of the data within the DataTable (required)
        :type data_version_number: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(DataVersionResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["data_table_id", "data_version_number"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_version" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_table_id"] is not None:
            _path_params["data-table-id"] = _params["data_table_id"]

        if _params["data_version_number"] is not None:
            _path_params["data-version-number"] = _params["data_version_number"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "DataVersionResponse",
        }

        return self.api_client.call_api(
            "/v1/data-tables/{data-table-id}/data-versions/{data-version-number}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_data_version_column_analysis(
        self,
        data_table_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataTable to operate on"),
        ],
        data_version_number: Annotated[
            StrictInt,
            Field(..., description="Version number of the data within the DataTable"),
        ],
        column_name: Annotated[
            StrictStr,
            Field(
                ...,
                description="Name of the column to retrieve analysis for (must exist in the data version schema)",
            ),
        ],
        **kwargs,
    ) -> Dict[str, object]:
        """Retrieves schema analysis results for a single column of a data version. Returns NOT_FOUND if the data table, data version, or schema analysis does not exist.

        :param data_table_id: Unique identifier of the DataTable to operate on (required)
        :type data_table_id: int
        :param data_version_number: Version number of the data within the DataTable (required)
        :type data_version_number: int
        :param column_name: Name of the column to retrieve analysis for (must exist in the data version schema) (required)
        :type column_name: str
        :return: Returns the result object.
        :rtype: Dict[str, object]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_data_version_column_analysis_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.get_data_version_column_analysis_with_http_info(
            data_table_id, data_version_number, column_name, **kwargs
        )

    @validate_arguments
    def get_data_version_column_analysis_with_http_info(
        self,
        data_table_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataTable to operate on"),
        ],
        data_version_number: Annotated[
            StrictInt,
            Field(..., description="Version number of the data within the DataTable"),
        ],
        column_name: Annotated[
            StrictStr,
            Field(
                ...,
                description="Name of the column to retrieve analysis for (must exist in the data version schema)",
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Retrieves schema analysis results for a single column of a data version. Returns NOT_FOUND if the data table, data version, or schema analysis does not exist.

        :param data_table_id: Unique identifier of the DataTable to operate on (required)
        :type data_table_id: int
        :param data_version_number: Version number of the data within the DataTable (required)
        :type data_version_number: int
        :param column_name: Name of the column to retrieve analysis for (must exist in the data version schema) (required)
        :type column_name: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(Dict[str, object], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["data_table_id", "data_version_number", "column_name"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_version_column_analysis" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_table_id"] is not None:
            _path_params["data-table-id"] = _params["data_table_id"]

        if _params["data_version_number"] is not None:
            _path_params["data-version-number"] = _params["data_version_number"]

        if _params["column_name"] is not None:
            _path_params["column-name"] = _params["column_name"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "Dict[str, object]",
        }

        return self.api_client.call_api(
            "/v1/data-tables/{data-table-id}/data-versions/{data-version-number}/schema-analysis/columns/{column-name}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_data_version_preview(
        self,
        data_table_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataTable to operate on"),
        ],
        data_version_number: Annotated[
            StrictInt,
            Field(..., description="Version number of the data within the DataTable"),
        ],
        **kwargs,
    ) -> List[Dict[str, object]]:
        """Retrieves a sample of the actual data content from a specific data version for preview purposes. Returns a limited number of rows to allow users to inspect the data structure and content without downloading the entire dataset.

        :param data_table_id: Unique identifier of the DataTable to operate on (required)
        :type data_table_id: int
        :param data_version_number: Version number of the data within the DataTable (required)
        :type data_version_number: int
        :return: Returns the result object.
        :rtype: List[Dict[str, object]]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_data_version_preview_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.get_data_version_preview_with_http_info(
            data_table_id, data_version_number, **kwargs
        )

    @validate_arguments
    def get_data_version_preview_with_http_info(
        self,
        data_table_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataTable to operate on"),
        ],
        data_version_number: Annotated[
            StrictInt,
            Field(..., description="Version number of the data within the DataTable"),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Retrieves a sample of the actual data content from a specific data version for preview purposes. Returns a limited number of rows to allow users to inspect the data structure and content without downloading the entire dataset.

        :param data_table_id: Unique identifier of the DataTable to operate on (required)
        :type data_table_id: int
        :param data_version_number: Version number of the data within the DataTable (required)
        :type data_version_number: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(List[Dict[str, object]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["data_table_id", "data_version_number"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_version_preview" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_table_id"] is not None:
            _path_params["data-table-id"] = _params["data_table_id"]

        if _params["data_version_number"] is not None:
            _path_params["data-version-number"] = _params["data_version_number"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "List[Dict[str, object]]",
        }

        return self.api_client.call_api(
            "/v1/data-tables/{data-table-id}/data-versions/{data-version-number}/preview",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_data_version_schema_analysis_status(
        self,
        data_table_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataTable to operate on"),
        ],
        data_version_number: Annotated[
            StrictInt,
            Field(..., description="Version number of the data within the DataTable"),
        ],
        **kwargs,
    ) -> SchemaAnalysisStatusResponse:
        """Retrieves schema analysis job status for a specific data version. Returns NOT_FOUND if the data table, data version, or schema analysis does not exist.

        :param data_table_id: Unique identifier of the DataTable to operate on (required)
        :type data_table_id: int
        :param data_version_number: Version number of the data within the DataTable (required)
        :type data_version_number: int
        :return: Returns the result object.
        :rtype: SchemaAnalysisStatusResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_data_version_schema_analysis_status_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.get_data_version_schema_analysis_status_with_http_info(
            data_table_id, data_version_number, **kwargs
        )

    @validate_arguments
    def get_data_version_schema_analysis_status_with_http_info(
        self,
        data_table_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataTable to operate on"),
        ],
        data_version_number: Annotated[
            StrictInt,
            Field(..., description="Version number of the data within the DataTable"),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Retrieves schema analysis job status for a specific data version. Returns NOT_FOUND if the data table, data version, or schema analysis does not exist.

        :param data_table_id: Unique identifier of the DataTable to operate on (required)
        :type data_table_id: int
        :param data_version_number: Version number of the data within the DataTable (required)
        :type data_version_number: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(SchemaAnalysisStatusResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["data_table_id", "data_version_number"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_version_schema_analysis_status" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_table_id"] is not None:
            _path_params["data-table-id"] = _params["data_table_id"]

        if _params["data_version_number"] is not None:
            _path_params["data-version-number"] = _params["data_version_number"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "SchemaAnalysisStatusResponse",
        }

        return self.api_client.call_api(
            "/v1/data-tables/{data-table-id}/data-versions/{data-version-number}/schema-analysis-status",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_export_job_status(
        self,
        job_id: Annotated[
            StrictStr,
            Field(..., description="Unique identifier of the background job to query"),
        ],
        **kwargs,
    ) -> ExportS3PartJobStatusResponse:
        """Retrieves the current status and progress of a multi-part S3 export job. Use this endpoint to monitor export operations and retrieve part upload results.

        :param job_id: Unique identifier of the background job to query (required)
        :type job_id: str
        :return: Returns the result object.
        :rtype: ExportS3PartJobStatusResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_export_job_status_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.get_export_job_status_with_http_info(job_id, **kwargs)

    @validate_arguments
    def get_export_job_status_with_http_info(
        self,
        job_id: Annotated[
            StrictStr,
            Field(..., description="Unique identifier of the background job to query"),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Retrieves the current status and progress of a multi-part S3 export job. Use this endpoint to monitor export operations and retrieve part upload results.

        :param job_id: Unique identifier of the background job to query (required)
        :type job_id: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(ExportS3PartJobStatusResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["job_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_export_job_status" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["job_id"] is not None:
            _path_params["job-id"] = _params["job_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "ExportS3PartJobStatusResponse",
        }

        return self.api_client.call_api(
            "/v1/data-tables/export-s3-part/{job-id}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def is_data_table_name_available(
        self,
        name: Annotated[
            StrictStr,
            Field(
                ...,
                description="The proposed name for the DataTable to check for availability",
            ),
        ],
        **kwargs,
    ) -> bool:
        """Validates whether a DataTable name is available for use within the current workspace. Returns true if the name can be used for creating a new DataTable, false if it already exists.

        :param name: The proposed name for the DataTable to check for availability (required)
        :type name: str
        :return: Returns the result object.
        :rtype: bool
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the is_data_table_name_available_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.is_data_table_name_available_with_http_info(name, **kwargs)

    @validate_arguments
    def is_data_table_name_available_with_http_info(
        self,
        name: Annotated[
            StrictStr,
            Field(
                ...,
                description="The proposed name for the DataTable to check for availability",
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Validates whether a DataTable name is available for use within the current workspace. Returns true if the name can be used for creating a new DataTable, false if it already exists.

        :param name: The proposed name for the DataTable to check for availability (required)
        :type name: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(bool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["name"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method is_data_table_name_available" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["name"] is not None:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "bool",
        }

        return self.api_client.call_api(
            "/v1/data-table-utils/is-name-available/{name}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_data_tables(self, **kwargs) -> List[DataTableResponse]:
        """Retrieves a list of all DataTables. DataTables are containers for imported data from external sources and serve as building blocks for data transformation workflows.
        :return: Returns the result object.
        :rtype: List[DataTableResponse]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the list_data_tables_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.list_data_tables_with_http_info(**kwargs)

    @validate_arguments
    def list_data_tables_with_http_info(self, **kwargs) -> ApiResponse:
        """Retrieves a list of all DataTables. DataTables are containers for imported data from external sources and serve as building blocks for data transformation workflows.
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(List[DataTableResponse], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = []
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_data_tables" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "List[DataTableResponse]",
        }

        return self.api_client.call_api(
            "/v1/data-tables",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_data_versions(
        self,
        data_table_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataTable to operate on"),
        ],
        **kwargs,
    ) -> List[DataVersionResponse]:
        """Retrieves all data versions associated with a specific DataTable. Data versions represent different snapshots or iterations of data imported into the DataTable, each with its own metadata, status, and content.

        :param data_table_id: Unique identifier of the DataTable to operate on (required)
        :type data_table_id: int
        :return: Returns the result object.
        :rtype: List[DataVersionResponse]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the list_data_versions_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.list_data_versions_with_http_info(data_table_id, **kwargs)

    @validate_arguments
    def list_data_versions_with_http_info(
        self,
        data_table_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataTable to operate on"),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Retrieves all data versions associated with a specific DataTable. Data versions represent different snapshots or iterations of data imported into the DataTable, each with its own metadata, status, and content.

        :param data_table_id: Unique identifier of the DataTable to operate on (required)
        :type data_table_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(List[DataVersionResponse], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["data_table_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_data_versions" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_table_id"] is not None:
            _path_params["data-table-id"] = _params["data_table_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "List[DataVersionResponse]",
        }

        return self.api_client.call_api(
            "/v1/data-tables/{data-table-id}/data-versions",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def update_data_table(
        self,
        data_table_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataTable to operate on"),
        ],
        update_data_table_request: Annotated[
            UpdateDataTableRequest,
            Field(
                ...,
                description="Request body containing the updated configuration for an existing DataTable, including metadata changes such as name, description, and tags. The DataSource cannot be modified after creation",
            ),
        ],
        **kwargs,
    ) -> DataTableResponse:
        """Updates the metadata and configuration of an existing DataTable. This includes modifying the name, description, and tags. The associated DataSource cannot be changed after creation. The operation requires the current lock version to prevent concurrent modifications.

        :param data_table_id: Unique identifier of the DataTable to operate on (required)
        :type data_table_id: int
        :param update_data_table_request: Request body containing the updated configuration for an existing DataTable, including metadata changes such as name, description, and tags. The DataSource cannot be modified after creation (required)
        :type update_data_table_request: UpdateDataTableRequest
        :return: Returns the result object.
        :rtype: DataTableResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the update_data_table_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.update_data_table_with_http_info(
            data_table_id, update_data_table_request, **kwargs
        )

    @validate_arguments
    def update_data_table_with_http_info(
        self,
        data_table_id: Annotated[
            StrictInt,
            Field(..., description="Unique identifier of the DataTable to operate on"),
        ],
        update_data_table_request: Annotated[
            UpdateDataTableRequest,
            Field(
                ...,
                description="Request body containing the updated configuration for an existing DataTable, including metadata changes such as name, description, and tags. The DataSource cannot be modified after creation",
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Updates the metadata and configuration of an existing DataTable. This includes modifying the name, description, and tags. The associated DataSource cannot be changed after creation. The operation requires the current lock version to prevent concurrent modifications.

        :param data_table_id: Unique identifier of the DataTable to operate on (required)
        :type data_table_id: int
        :param update_data_table_request: Request body containing the updated configuration for an existing DataTable, including metadata changes such as name, description, and tags. The DataSource cannot be modified after creation (required)
        :type update_data_table_request: UpdateDataTableRequest
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(DataTableResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["data_table_id", "update_data_table_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_data_table" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["data_table_id"] is not None:
            _path_params["data-table-id"] = _params["data_table_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["update_data_table_request"] is not None:
            _body_params = _params["update_data_table_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "DataTableResponse",
        }

        return self.api_client.call_api(
            "/v1/data-tables/{data-table-id}",
            "PUT",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
