# coding: utf-8

"""
Earnix Elevate Data API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from datetime import datetime
from typing import Optional

from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr, conlist

from earnix_elevate.clients.data.models.export_s3_status_response import (
    ExportS3StatusResponse,
)


class ExportS3JobStatusResponse(BaseModel):
    """
    `ExportS3JobStatusResponse`

    Export S3 job status response
    """

    bucket: Optional[StrictStr] = Field(
        default=None,
        description="Name of the S3 bucket where the data will be exported",
    )
    key: Optional[StrictStr] = Field(
        default=None,
        description="S3 object key (path) where the exported data will be stored",
    )
    total_files: Optional[StrictInt] = Field(
        default=None,
        alias="totalFiles",
        description="Total number of files that will be created during the export process",
    )
    uploaded_files: Optional[conlist(StrictStr)] = Field(
        default=None,
        alias="uploadedFiles",
        description="List of file names that have been successfully uploaded to S3",
    )
    status: Optional[ExportS3StatusResponse] = None
    created_date: Optional[datetime] = Field(
        default=None,
        alias="createdDate",
        description="Date and time when the export job was created",
    )
    __properties = [
        "bucket",
        "key",
        "totalFiles",
        "uploadedFiles",
        "status",
        "createdDate",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ExportS3JobStatusResponse:
        """Create an instance of ExportS3JobStatusResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict["status"] = self.status.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ExportS3JobStatusResponse:
        """Create an instance of ExportS3JobStatusResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ExportS3JobStatusResponse.parse_obj(obj)

        _obj = ExportS3JobStatusResponse.parse_obj(
            {
                "bucket": obj.get("bucket"),
                "key": obj.get("key"),
                "total_files": obj.get("totalFiles"),
                "uploaded_files": obj.get("uploadedFiles"),
                "status": ExportS3StatusResponse.from_dict(obj.get("status"))
                if obj.get("status") is not None
                else None,
                "created_date": obj.get("createdDate"),
            }
        )
        return _obj
