# coding: utf-8

"""
Earnix Elevate Data API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from typing import Optional

from pydantic.v1 import BaseModel, Field, StrictBool, StrictStr, conlist


class ExportS3PartRequest(BaseModel):
    """
    `ExportS3PartRequest`
    """

    parts_urls: Optional[conlist(StrictStr)] = Field(
        default=None,
        alias="partsUrls",
        description="List of pre-signed S3 URLs for multi-part upload operations. Each URL corresponds to a part of the data that will be uploaded separately",
    )
    columns: Optional[conlist(StrictStr)] = Field(
        default=None,
        description="List of specific column names to include in the export. If not specified, all columns will be exported",
    )
    cast_boolean_to_integer: Optional[StrictBool] = Field(
        default=False,
        alias="castBooleanToInteger",
        description="Whether to convert boolean values to integers (true=1, false=0) in the exported data for compatibility with systems that don't support boolean types",
    )
    use_sample: Optional[StrictBool] = Field(
        default=False,
        alias="useSample",
        description="Whether to export only a sample of the data instead of the complete dataset. Useful for testing and preview purposes",
    )
    __properties = ["partsUrls", "columns", "castBooleanToInteger", "useSample"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ExportS3PartRequest:
        """Create an instance of ExportS3PartRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ExportS3PartRequest:
        """Create an instance of ExportS3PartRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ExportS3PartRequest.parse_obj(obj)

        _obj = ExportS3PartRequest.parse_obj(
            {
                "parts_urls": obj.get("partsUrls"),
                "columns": obj.get("columns"),
                "cast_boolean_to_integer": obj.get("castBooleanToInteger")
                if obj.get("castBooleanToInteger") is not None
                else False,
                "use_sample": obj.get("useSample")
                if obj.get("useSample") is not None
                else False,
            }
        )
        return _obj
