# coding: utf-8

"""
Earnix Elevate Data API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from typing import Optional

from pydantic.v1 import (
    BaseModel,
    Field,
    StrictInt,
    StrictStr,
    conlist,
    constr,
    validator,
)


class RecipeResponse(BaseModel):
    """
    `RecipeResponse`

    Represents a recipe which contains SQL transformation logic that can be applied to data within transformation graphs
    """

    recipe_type: Optional[StrictStr] = Field(
        default=None,
        alias="recipeType",
        description="Recipe type (TRANSFORMATION for data processing, STRUCTURE for schema modifications)",
    )
    name: Optional[constr(strict=True, max_length=100, min_length=3)] = Field(
        default=None,
        description="Name of the entity for identification and display purposes",
    )
    description: Optional[constr(strict=True, max_length=500)] = Field(
        default=None,
        description="Optional detailed description providing additional context about the entity",
    )
    tags: Optional[conlist(StrictStr, unique_items=True)] = Field(
        default=None,
        description="List of unique tags for categorizing and organizing the entity",
    )
    id: Optional[StrictInt] = Field(
        default=None, description="Unique identifier of the entity"
    )
    lock_version: Optional[StrictInt] = Field(
        default=None,
        alias="lockVersion",
        description="Version number used for optimistic locking to prevent concurrent modifications",
    )
    code: Optional[constr(strict=True, max_length=10000, min_length=3)] = Field(
        default=None, description="SQL code that defines the data transformation logic"
    )
    language: Optional[StrictStr] = Field(
        default=None,
        description="Programming language of the recipe (currently only SQL is supported)",
    )
    __properties = [
        "recipeType",
        "name",
        "description",
        "tags",
        "id",
        "lockVersion",
        "code",
        "language",
    ]

    @validator("recipe_type")
    def recipe_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in (
            "TRANSFORMATION",
            "STRUCTURE",
        ):
            raise ValueError(
                "must be one of enum values ('TRANSFORMATION', 'STRUCTURE')"
            )
        return value

    @validator("language")
    def language_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("SQL",):
            raise ValueError("must be one of enum values ('SQL')")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RecipeResponse:
        """Create an instance of RecipeResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict["description"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RecipeResponse:
        """Create an instance of RecipeResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RecipeResponse.parse_obj(obj)

        _obj = RecipeResponse.parse_obj(
            {
                "recipe_type": obj.get("recipeType"),
                "name": obj.get("name"),
                "description": obj.get("description"),
                "tags": obj.get("tags"),
                "id": obj.get("id"),
                "lock_version": obj.get("lockVersion"),
                "code": obj.get("code"),
                "language": obj.get("language"),
            }
        )
        return _obj
