# coding: utf-8

"""
Earnix Elevate Data API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from typing import Optional

from pydantic.v1 import Field, StrictInt

from earnix_elevate.clients.data.models.update_data_set_node_request import (
    UpdateDataSetNodeRequest,
)


class UpdateDataSetDataTableNodeRequest(UpdateDataSetNodeRequest):
    """
    `UpdateDataSetDataTableNodeRequest`

    Updates the configuration of an existing DataTable node within the transformation graph. This allows modification of node properties.
    """

    data_table_id: Optional[StrictInt] = Field(
        default=None,
        alias="dataTableId",
        description="Unique identifier of the referenced DataTable",
    )
    data_table_version_number: Optional[StrictInt] = Field(
        default=None,
        alias="dataTableVersionNumber",
        description="Specific version number of the DataTable to use in the transformation",
    )
    id: Optional[StrictInt] = Field(
        default=None, description="Unique identifier of the entity"
    )
    lock_version: Optional[StrictInt] = Field(
        default=None,
        alias="lockVersion",
        description="Version number used for optimistic locking to prevent concurrent modifications",
    )
    __properties = [
        "nodeType",
        "dataSetId",
        "dataTableId",
        "dataTableVersionNumber",
        "id",
        "lockVersion",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpdateDataSetDataTableNodeRequest:
        """Create an instance of UpdateDataSetDataTableNodeRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpdateDataSetDataTableNodeRequest:
        """Create an instance of UpdateDataSetDataTableNodeRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UpdateDataSetDataTableNodeRequest.parse_obj(obj)

        _obj = UpdateDataSetDataTableNodeRequest.parse_obj(
            {
                "node_type": obj.get("nodeType"),
                "data_set_id": obj.get("dataSetId"),
                "data_table_id": obj.get("dataTableId"),
                "data_table_version_number": obj.get("dataTableVersionNumber"),
                "id": obj.get("id"),
                "lock_version": obj.get("lockVersion"),
            }
        )
        return _obj
