# coding: utf-8

"""
Earnix Elevate Import Export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from typing import Optional

from pydantic.v1 import BaseModel, Field, StrictStr, constr


class BucketFolderDetailsResponse(BaseModel):
    """
    `BucketFolderDetailsResponse`

    Details about a folder found in a bucket DataSource, including its location information.
    """

    bucket: Optional[constr(strict=True, max_length=1000, min_length=1)] = Field(
        default=None, description="The name of the bucket containing the folder"
    )
    relative_path: Optional[StrictStr] = Field(
        default=None,
        alias="relativePath",
        description="The relative path to the folder within the bucket",
    )
    __properties = ["bucket", "relativePath"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BucketFolderDetailsResponse:
        """Create an instance of BucketFolderDetailsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BucketFolderDetailsResponse:
        """Create an instance of BucketFolderDetailsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return BucketFolderDetailsResponse.parse_obj(obj)

        _obj = BucketFolderDetailsResponse.parse_obj(
            {"bucket": obj.get("bucket"), "relative_path": obj.get("relativePath")}
        )
        return _obj
