# coding: utf-8

"""
Earnix Elevate Import Export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from typing import Optional

from pydantic.v1 import Field, constr

from earnix_elevate.clients.imx.models.create_data_source_request import (
    CreateDataSourceRequest,
)


class CreateRDBMSDataSourceRequest(CreateDataSourceRequest):
    """
    `CreateRDBMSDataSourceRequest`

    Request to create a DataSource that imports data from relational databases (Snowflake, etc.). Specifies the SQL query to execute for data retrieval.
    """

    query: constr(strict=True, max_length=10000, min_length=7) = Field(
        default=..., description="The SQL query to execute for data retrieval"
    )
    warehouse: Optional[constr(strict=True, max_length=500)] = Field(
        default=None, description="The warehouse to use for query execution"
    )
    __properties = [
        "type",
        "name",
        "description",
        "tags",
        "connectionId",
        "query",
        "warehouse",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateRDBMSDataSourceRequest:
        """Create an instance of CreateRDBMSDataSourceRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict["description"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateRDBMSDataSourceRequest:
        """Create an instance of CreateRDBMSDataSourceRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreateRDBMSDataSourceRequest.parse_obj(obj)

        _obj = CreateRDBMSDataSourceRequest.parse_obj(
            {
                "type": obj.get("type"),
                "name": obj.get("name"),
                "description": obj.get("description"),
                "tags": obj.get("tags"),
                "connection_id": obj.get("connectionId"),
                "query": obj.get("query"),
                "warehouse": obj.get("warehouse"),
            }
        )
        return _obj
