# coding: utf-8

"""
Earnix Elevate Import Export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from typing import Optional

from pydantic.v1 import Field, constr

from earnix_elevate.clients.imx.models.create_connection_request import (
    CreateConnectionRequest,
)
from earnix_elevate.clients.imx.models.s3_auth_request import S3AuthRequest


class CreateS3ConnectionRequest(CreateConnectionRequest):
    """
    `CreateS3ConnectionRequest`

    Request to create an S3 Connection for accessing cloud storage services. Requires authentication credentials and endpoint configuration, with optional path restrictions for security.
    """

    auth: S3AuthRequest = Field(...)
    path_restriction: Optional[constr(strict=True, max_length=1000)] = Field(
        default=None,
        alias="pathRestriction",
        description="Optional path restriction to limit access to specific paths within the S3 bucket",
    )
    __properties = ["name", "description", "tags", "type", "pathRestriction"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateS3ConnectionRequest:
        """Create an instance of CreateS3ConnectionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict["description"] = None

        # set to None if path_restriction (nullable) is None
        # and __fields_set__ contains the field
        if self.path_restriction is None and "path_restriction" in self.__fields_set__:
            _dict["pathRestriction"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateS3ConnectionRequest:
        """Create an instance of CreateS3ConnectionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreateS3ConnectionRequest.parse_obj(obj)

        _obj = CreateS3ConnectionRequest.parse_obj(
            {
                "name": obj.get("name"),
                "description": obj.get("description"),
                "tags": obj.get("tags"),
                "type": obj.get("type"),
                "path_restriction": obj.get("pathRestriction"),
            }
        )
        return _obj
