# coding: utf-8

"""
Earnix Elevate Import Export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from typing import Optional

from pydantic.v1 import BaseModel, Field, constr


class TestRDBMSDataSourceRequest(BaseModel):
    """
    `TestRDBMSDataSourceRequest`

    Request to test an RDBMS DataSource configuration by executing the specified query to verify connectivity and data accessibility.
    """

    query: constr(strict=True, max_length=10000, min_length=7) = Field(
        default=..., description="The SQL query to execute for data retrieval"
    )
    warehouse: Optional[constr(strict=True, max_length=500)] = Field(
        default=None, description="The warehouse to use for query execution"
    )
    __properties = ["query", "warehouse"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TestRDBMSDataSourceRequest:
        """Create an instance of TestRDBMSDataSourceRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TestRDBMSDataSourceRequest:
        """Create an instance of TestRDBMSDataSourceRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TestRDBMSDataSourceRequest.parse_obj(obj)

        _obj = TestRDBMSDataSourceRequest.parse_obj(
            {"query": obj.get("query"), "warehouse": obj.get("warehouse")}
        )
        return _obj
