# coding: utf-8

"""
Earnix Elevate Import Export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from importlib import import_module
from typing import TYPE_CHECKING, Optional, Union

from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr, conlist, constr

if TYPE_CHECKING:
    from earnix_elevate.clients.imx.models.update_delta_sharing_connection_request import (
        UpdateDeltaSharingConnectionRequest,
    )
    from earnix_elevate.clients.imx.models.update_s3_connection_request import (
        UpdateS3ConnectionRequest,
    )
    from earnix_elevate.clients.imx.models.update_snowflake_connection_request import (
        UpdateSnowflakeConnectionRequest,
    )


class UpdateConnectionRequest(BaseModel):
    """
    `UpdateConnectionRequest`

    Request to update an existing Connection configuration including authentication details and connection parameters. Requires the current lock version to prevent concurrent modifications.
    """

    type: StrictStr = Field(
        default=...,
        description="The type of Connection being updated (s3 or snowflake)",
    )
    id: StrictInt = Field(
        default=..., description="The unique identifier of the entity"
    )
    lock_version: StrictInt = Field(
        default=...,
        alias="lockVersion",
        description="The current version of the entity used for optimistic locking to prevent concurrent modifications",
    )
    name: constr(strict=True, max_length=100, min_length=3) = Field(
        default=...,
        description="The name of the entity for identification and display purposes",
    )
    description: Optional[constr(strict=True, max_length=500)] = Field(
        default=None,
        description="Optional detailed description providing additional context about the entity",
    )
    tags: Optional[conlist(StrictStr, unique_items=True)] = Field(
        default=None,
        description="A list of unique tags for categorizing and organizing the entity",
    )
    __properties = ["id", "lockVersion", "name", "description", "tags"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    # JSON field name that stores the object type
    __discriminator_property_name = "type"

    # discriminator mappings
    __discriminator_value_class_map = {
        "delta_sharing": "UpdateDeltaSharingConnectionRequest",
        "s3": "UpdateS3ConnectionRequest",
        "snowflake": "UpdateSnowflakeConnectionRequest",
    }

    @classmethod
    def get_discriminator_value(cls, obj: dict) -> str:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(
        cls, json_str: str
    ) -> Union[
        UpdateDeltaSharingConnectionRequest,
        UpdateS3ConnectionRequest,
        UpdateSnowflakeConnectionRequest,
    ]:
        """Create an instance of UpdateConnectionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict["description"] = None

        return _dict

    @classmethod
    def from_dict(
        cls, obj: dict
    ) -> Union[
        UpdateDeltaSharingConnectionRequest,
        UpdateS3ConnectionRequest,
        UpdateSnowflakeConnectionRequest,
    ]:
        """Create an instance of UpdateConnectionRequest from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type == "UpdateDeltaSharingConnectionRequest":
            return import_module(
                "earnix_elevate.clients.imx.models.update_delta_sharing_connection_request"
            ).UpdateDeltaSharingConnectionRequest.from_dict(obj)
        if object_type == "UpdateS3ConnectionRequest":
            return import_module(
                "earnix_elevate.clients.imx.models.update_s3_connection_request"
            ).UpdateS3ConnectionRequest.from_dict(obj)
        if object_type == "UpdateSnowflakeConnectionRequest":
            return import_module(
                "earnix_elevate.clients.imx.models.update_snowflake_connection_request"
            ).UpdateSnowflakeConnectionRequest.from_dict(obj)
        raise ValueError(
            "UpdateConnectionRequest failed to lookup discriminator value from "
            + json.dumps(obj)
            + ". Discriminator property name: "
            + cls.__discriminator_property_name
            + ", mapping: "
            + json.dumps(cls.__discriminator_value_class_map)
        )
