# coding: utf-8

"""
Earnix Elevate Import Export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from typing import Optional

from pydantic.v1 import Field, constr

from earnix_elevate.clients.imx.models.update_data_source_request import (
    UpdateDataSourceRequest,
)


class UpdateDeltaSharingDataSourceRequest(UpdateDataSourceRequest):
    """
    `UpdateDeltaSharingDataSourceRequest`

    Request to update a Delta Sharing DataSource, allowing modification of the share, schema, and table configuration.
    """

    share: Optional[constr(strict=True, max_length=500)] = Field(
        default=None, description="The share to use for accessing shared data"
    )
    var_schema: Optional[constr(strict=True, max_length=500)] = Field(
        default=None,
        alias="schema",
        description="The schema within the Delta Share to use for accessing shared data",
    )
    table: Optional[constr(strict=True, max_length=500)] = Field(
        default=None,
        description="The table within the Delta Share to use for accessing shared data",
    )
    __properties = [
        "type",
        "id",
        "lockVersion",
        "name",
        "description",
        "tags",
        "connectionId",
        "share",
        "schema",
        "table",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpdateDeltaSharingDataSourceRequest:
        """Create an instance of UpdateDeltaSharingDataSourceRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict["description"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpdateDeltaSharingDataSourceRequest:
        """Create an instance of UpdateDeltaSharingDataSourceRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UpdateDeltaSharingDataSourceRequest.parse_obj(obj)

        _obj = UpdateDeltaSharingDataSourceRequest.parse_obj(
            {
                "type": obj.get("type"),
                "id": obj.get("id"),
                "lock_version": obj.get("lockVersion"),
                "name": obj.get("name"),
                "description": obj.get("description"),
                "tags": obj.get("tags"),
                "connection_id": obj.get("connectionId"),
                "share": obj.get("share"),
                "var_schema": obj.get("schema"),
                "table": obj.get("table"),
            }
        )
        return _obj
