import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermAppServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service#name DataAzurermAppService#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service#resource_group_name DataAzurermAppService#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service#timeouts DataAzurermAppService#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermAppServiceTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermAppServiceConnectionString extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    get value(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermAppServiceSiteConfigCors extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get allowedOrigins(): string[];
    /**
     * @stability stable
     */
    get supportCredentials(): cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class DataAzurermAppServiceSiteConfigIpRestrictionHeaders extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get xAzureFdid(): string[];
    /**
     * @stability stable
     */
    get xFdHealthProbe(): string[];
    /**
     * @stability stable
     */
    get xForwardedFor(): string[];
    /**
     * @stability stable
     */
    get xForwardedHost(): string[];
}
/**
 * @stability stable
 */
export declare class DataAzurermAppServiceSiteConfigIpRestriction extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get action(): string;
    /**
     * @stability stable
     */
    get headers(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get ipAddress(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get priority(): number;
    /**
     * @stability stable
     */
    get serviceTag(): string;
    /**
     * @stability stable
     */
    get virtualNetworkSubnetId(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermAppServiceSiteConfigScmIpRestrictionHeaders extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get xAzureFdid(): string[];
    /**
     * @stability stable
     */
    get xFdHealthProbe(): string[];
    /**
     * @stability stable
     */
    get xForwardedFor(): string[];
    /**
     * @stability stable
     */
    get xForwardedHost(): string[];
}
/**
 * @stability stable
 */
export declare class DataAzurermAppServiceSiteConfigScmIpRestriction extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get action(): string;
    /**
     * @stability stable
     */
    get headers(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get ipAddress(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get priority(): number;
    /**
     * @stability stable
     */
    get serviceTag(): string;
    /**
     * @stability stable
     */
    get virtualNetworkSubnetId(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermAppServiceSiteConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get acrUseManagedIdentityCredentials(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get acrUserManagedIdentityClientId(): string;
    /**
     * @stability stable
     */
    get alwaysOn(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get appCommandLine(): string;
    /**
     * @stability stable
     */
    get cors(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get defaultDocuments(): string[];
    /**
     * @stability stable
     */
    get dotnetFrameworkVersion(): string;
    /**
     * @stability stable
     */
    get ftpsState(): string;
    /**
     * @stability stable
     */
    get healthCheckPath(): string;
    /**
     * @stability stable
     */
    get http2Enabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get ipRestriction(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get javaContainer(): string;
    /**
     * @stability stable
     */
    get javaContainerVersion(): string;
    /**
     * @stability stable
     */
    get javaVersion(): string;
    /**
     * @stability stable
     */
    get linuxFxVersion(): string;
    /**
     * @stability stable
     */
    get localMysqlEnabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get managedPipelineMode(): string;
    /**
     * @stability stable
     */
    get minTlsVersion(): string;
    /**
     * @stability stable
     */
    get numberOfWorkers(): number;
    /**
     * @stability stable
     */
    get phpVersion(): string;
    /**
     * @stability stable
     */
    get pythonVersion(): string;
    /**
     * @stability stable
     */
    get remoteDebuggingEnabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get remoteDebuggingVersion(): string;
    /**
     * @stability stable
     */
    get scmIpRestriction(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get scmType(): string;
    /**
     * @stability stable
     */
    get scmUseMainIpRestriction(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get use32BitWorkerProcess(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get vnetRouteAllEnabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get websocketsEnabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get windowsFxVersion(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermAppServiceSiteCredential extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    get username(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermAppServiceSourceControl extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get branch(): string;
    /**
     * @stability stable
     */
    get manualIntegration(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get repoUrl(): string;
    /**
     * @stability stable
     */
    get rollbackEnabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get useMercurial(): cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface DataAzurermAppServiceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service#read DataAzurermAppService#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermAppServiceTimeoutsToTerraform(struct?: DataAzurermAppServiceTimeoutsOutputReference | DataAzurermAppServiceTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermAppServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermAppServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermAppServiceTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/app_service azurerm_app_service}.
 *
 * @stability stable
 */
export declare class DataAzurermAppService extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/app_service azurerm_app_service} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermAppServiceConfig);
    /**
     * @stability stable
     */
    get appServicePlanId(): string;
    /**
     * @stability stable
     */
    appSettings(key: string): string | cdktf.IResolvable;
    /**
     * @stability stable
     */
    get clientAffinityEnabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get clientCertEnabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    connectionString(index: string): DataAzurermAppServiceConnectionString;
    /**
     * @stability stable
     */
    get customDomainVerificationId(): string;
    /**
     * @stability stable
     */
    get defaultSiteHostname(): string;
    /**
     * @stability stable
     */
    get enabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get httpsOnly(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get outboundIpAddressList(): string[];
    /**
     * @stability stable
     */
    get outboundIpAddresses(): string;
    /**
     * @stability stable
     */
    get possibleOutboundIpAddressList(): string[];
    /**
     * @stability stable
     */
    get possibleOutboundIpAddresses(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    siteConfig(index: string): DataAzurermAppServiceSiteConfig;
    /**
     * @stability stable
     */
    siteCredential(index: string): DataAzurermAppServiceSiteCredential;
    /**
     * @stability stable
     */
    sourceControl(index: string): DataAzurermAppServiceSourceControl;
    /**
     * @stability stable
     */
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermAppServiceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermAppServiceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermAppServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
