import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermDataShareDatasetKustoClusterConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_kusto_cluster#name DataAzurermDataShareDatasetKustoCluster#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_kusto_cluster#share_id DataAzurermDataShareDatasetKustoCluster#share_id}.
     *
     * @stability stable
     */
    readonly shareId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_kusto_cluster#timeouts DataAzurermDataShareDatasetKustoCluster#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermDataShareDatasetKustoClusterTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermDataShareDatasetKustoClusterTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_kusto_cluster#read DataAzurermDataShareDatasetKustoCluster#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermDataShareDatasetKustoClusterTimeoutsToTerraform(struct?: DataAzurermDataShareDatasetKustoClusterTimeoutsOutputReference | DataAzurermDataShareDatasetKustoClusterTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermDataShareDatasetKustoClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermDataShareDatasetKustoClusterTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermDataShareDatasetKustoClusterTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_kusto_cluster azurerm_data_share_dataset_kusto_cluster}.
 *
 * @stability stable
 */
export declare class DataAzurermDataShareDatasetKustoCluster extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_kusto_cluster azurerm_data_share_dataset_kusto_cluster} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermDataShareDatasetKustoClusterConfig);
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get kustoClusterId(): string;
    /**
     * @stability stable
     */
    get kustoClusterLocation(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _shareId?;
    /**
     * @stability stable
     */
    get shareId(): string;
    /**
     * @stability stable
     */
    set shareId(value: string);
    /**
     * @stability stable
     */
    get shareIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermDataShareDatasetKustoClusterTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermDataShareDatasetKustoClusterTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermDataShareDatasetKustoClusterTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
