import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermDatabricksWorkspacePrivateEndpointConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/databricks_workspace_private_endpoint_connection#private_endpoint_id DataAzurermDatabricksWorkspacePrivateEndpointConnection#private_endpoint_id}.
     *
     * @stability stable
     */
    readonly privateEndpointId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/databricks_workspace_private_endpoint_connection#workspace_id DataAzurermDatabricksWorkspacePrivateEndpointConnection#workspace_id}.
     *
     * @stability stable
     */
    readonly workspaceId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/databricks_workspace_private_endpoint_connection#timeouts DataAzurermDatabricksWorkspacePrivateEndpointConnection#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermDatabricksWorkspacePrivateEndpointConnectionTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermDatabricksWorkspacePrivateEndpointConnectionConnections extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get actionRequired(): string;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    get workspacePrivateEndpointId(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermDatabricksWorkspacePrivateEndpointConnectionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/databricks_workspace_private_endpoint_connection#read DataAzurermDatabricksWorkspacePrivateEndpointConnection#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermDatabricksWorkspacePrivateEndpointConnectionTimeoutsToTerraform(struct?: DataAzurermDatabricksWorkspacePrivateEndpointConnectionTimeoutsOutputReference | DataAzurermDatabricksWorkspacePrivateEndpointConnectionTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermDatabricksWorkspacePrivateEndpointConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermDatabricksWorkspacePrivateEndpointConnectionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermDatabricksWorkspacePrivateEndpointConnectionTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/databricks_workspace_private_endpoint_connection azurerm_databricks_workspace_private_endpoint_connection}.
 *
 * @stability stable
 */
export declare class DataAzurermDatabricksWorkspacePrivateEndpointConnection extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/databricks_workspace_private_endpoint_connection azurerm_databricks_workspace_private_endpoint_connection} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermDatabricksWorkspacePrivateEndpointConnectionConfig);
    /**
     * @stability stable
     */
    connections(index: string): DataAzurermDatabricksWorkspacePrivateEndpointConnectionConnections;
    /**
     * @stability stable
     */
    get id(): string;
    private _privateEndpointId?;
    /**
     * @stability stable
     */
    get privateEndpointId(): string;
    /**
     * @stability stable
     */
    set privateEndpointId(value: string);
    /**
     * @stability stable
     */
    get privateEndpointIdInput(): string | undefined;
    private _workspaceId?;
    /**
     * @stability stable
     */
    get workspaceId(): string;
    /**
     * @stability stable
     */
    set workspaceId(value: string);
    /**
     * @stability stable
     */
    get workspaceIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermDatabricksWorkspacePrivateEndpointConnectionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermDatabricksWorkspacePrivateEndpointConnectionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermDatabricksWorkspacePrivateEndpointConnectionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
