import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermKubernetesClusterNodePoolConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_cluster_node_pool#kubernetes_cluster_name DataAzurermKubernetesClusterNodePool#kubernetes_cluster_name}.
     *
     * @stability stable
     */
    readonly kubernetesClusterName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_cluster_node_pool#name DataAzurermKubernetesClusterNodePool#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_cluster_node_pool#resource_group_name DataAzurermKubernetesClusterNodePool#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_cluster_node_pool#timeouts DataAzurermKubernetesClusterNodePool#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermKubernetesClusterNodePoolTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermKubernetesClusterNodePoolUpgradeSettings extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get maxSurge(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermKubernetesClusterNodePoolTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_cluster_node_pool#read DataAzurermKubernetesClusterNodePool#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermKubernetesClusterNodePoolTimeoutsToTerraform(struct?: DataAzurermKubernetesClusterNodePoolTimeoutsOutputReference | DataAzurermKubernetesClusterNodePoolTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermKubernetesClusterNodePoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermKubernetesClusterNodePoolTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermKubernetesClusterNodePoolTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_cluster_node_pool azurerm_kubernetes_cluster_node_pool}.
 *
 * @stability stable
 */
export declare class DataAzurermKubernetesClusterNodePool extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_cluster_node_pool azurerm_kubernetes_cluster_node_pool} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermKubernetesClusterNodePoolConfig);
    /**
     * @stability stable
     */
    get availabilityZones(): string[];
    /**
     * @stability stable
     */
    get enableAutoScaling(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get enableNodePublicIp(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get evictionPolicy(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _kubernetesClusterName?;
    /**
     * @stability stable
     */
    get kubernetesClusterName(): string;
    /**
     * @stability stable
     */
    set kubernetesClusterName(value: string);
    /**
     * @stability stable
     */
    get kubernetesClusterNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get maxCount(): number;
    /**
     * @stability stable
     */
    get maxPods(): number;
    /**
     * @stability stable
     */
    get minCount(): number;
    /**
     * @stability stable
     */
    get mode(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get nodeCount(): number;
    /**
     * @stability stable
     */
    nodeLabels(key: string): string | cdktf.IResolvable;
    /**
     * @stability stable
     */
    get nodePublicIpPrefixId(): string;
    /**
     * @stability stable
     */
    get nodeTaints(): string[];
    /**
     * @stability stable
     */
    get orchestratorVersion(): string;
    /**
     * @stability stable
     */
    get osDiskSizeGb(): number;
    /**
     * @stability stable
     */
    get osDiskType(): string;
    /**
     * @stability stable
     */
    get osType(): string;
    /**
     * @stability stable
     */
    get priority(): string;
    /**
     * @stability stable
     */
    get proximityPlacementGroupId(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get spotMaxPrice(): number;
    /**
     * @stability stable
     */
    tags(key: string): string | cdktf.IResolvable;
    /**
     * @stability stable
     */
    upgradeSettings(index: string): DataAzurermKubernetesClusterNodePoolUpgradeSettings;
    /**
     * @stability stable
     */
    get vmSize(): string;
    /**
     * @stability stable
     */
    get vnetSubnetId(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermKubernetesClusterNodePoolTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermKubernetesClusterNodePoolTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermKubernetesClusterNodePoolTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
