import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermLocalNetworkGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/local_network_gateway#name DataAzurermLocalNetworkGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/local_network_gateway#resource_group_name DataAzurermLocalNetworkGateway#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/local_network_gateway#timeouts DataAzurermLocalNetworkGateway#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermLocalNetworkGatewayTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermLocalNetworkGatewayBgpSettings extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get asn(): number;
    /**
     * @stability stable
     */
    get bgpPeeringAddress(): string;
    /**
     * @stability stable
     */
    get peerWeight(): number;
}
/**
 * @stability stable
 */
export interface DataAzurermLocalNetworkGatewayTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/local_network_gateway#read DataAzurermLocalNetworkGateway#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermLocalNetworkGatewayTimeoutsToTerraform(struct?: DataAzurermLocalNetworkGatewayTimeoutsOutputReference | DataAzurermLocalNetworkGatewayTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermLocalNetworkGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermLocalNetworkGatewayTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermLocalNetworkGatewayTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/local_network_gateway azurerm_local_network_gateway}.
 *
 * @stability stable
 */
export declare class DataAzurermLocalNetworkGateway extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/local_network_gateway azurerm_local_network_gateway} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermLocalNetworkGatewayConfig);
    /**
     * @stability stable
     */
    get addressSpace(): string[];
    /**
     * @stability stable
     */
    bgpSettings(index: string): DataAzurermLocalNetworkGatewayBgpSettings;
    /**
     * @stability stable
     */
    get gatewayAddress(): string;
    /**
     * @stability stable
     */
    get gatewayFqdn(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermLocalNetworkGatewayTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermLocalNetworkGatewayTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermLocalNetworkGatewayTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
