import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermNetworkWatcherConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/network_watcher#name DataAzurermNetworkWatcher#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/network_watcher#resource_group_name DataAzurermNetworkWatcher#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/network_watcher#timeouts DataAzurermNetworkWatcher#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermNetworkWatcherTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermNetworkWatcherTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/network_watcher#read DataAzurermNetworkWatcher#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermNetworkWatcherTimeoutsToTerraform(struct?: DataAzurermNetworkWatcherTimeoutsOutputReference | DataAzurermNetworkWatcherTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermNetworkWatcherTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermNetworkWatcherTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermNetworkWatcherTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/network_watcher azurerm_network_watcher}.
 *
 * @stability stable
 */
export declare class DataAzurermNetworkWatcher extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/network_watcher azurerm_network_watcher} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermNetworkWatcherConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermNetworkWatcherTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermNetworkWatcherTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermNetworkWatcherTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
