import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermVirtualWanConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_wan#name DataAzurermVirtualWan#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_wan#resource_group_name DataAzurermVirtualWan#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_wan#timeouts DataAzurermVirtualWan#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermVirtualWanTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermVirtualWanTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_wan#read DataAzurermVirtualWan#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermVirtualWanTimeoutsToTerraform(struct?: DataAzurermVirtualWanTimeoutsOutputReference | DataAzurermVirtualWanTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermVirtualWanTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermVirtualWanTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermVirtualWanTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_wan azurerm_virtual_wan}.
 *
 * @stability stable
 */
export declare class DataAzurermVirtualWan extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_wan azurerm_virtual_wan} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermVirtualWanConfig);
    /**
     * @stability stable
     */
    get allowBranchToBranchTraffic(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get disableVpnEncryption(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get office365LocalBreakoutCategory(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    tags(key: string): string | cdktf.IResolvable;
    /**
     * @stability stable
     */
    get virtualHubIds(): string[];
    /**
     * @stability stable
     */
    get vpnSiteIds(): string[];
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermVirtualWanTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermVirtualWanTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermVirtualWanTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
