import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataFactoryTriggerTumblingWindowConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_tumbling_window#activated DataFactoryTriggerTumblingWindow#activated}.
     *
     * @stability stable
     */
    readonly activated?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_tumbling_window#additional_properties DataFactoryTriggerTumblingWindow#additional_properties}.
     *
     * @stability stable
     */
    readonly additionalProperties?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_tumbling_window#annotations DataFactoryTriggerTumblingWindow#annotations}.
     *
     * @stability stable
     */
    readonly annotations?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_tumbling_window#data_factory_id DataFactoryTriggerTumblingWindow#data_factory_id}.
     *
     * @stability stable
     */
    readonly dataFactoryId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_tumbling_window#delay DataFactoryTriggerTumblingWindow#delay}.
     *
     * @stability stable
     */
    readonly delay?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_tumbling_window#description DataFactoryTriggerTumblingWindow#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_tumbling_window#end_time DataFactoryTriggerTumblingWindow#end_time}.
     *
     * @stability stable
     */
    readonly endTime?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_tumbling_window#frequency DataFactoryTriggerTumblingWindow#frequency}.
     *
     * @stability stable
     */
    readonly frequency: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_tumbling_window#interval DataFactoryTriggerTumblingWindow#interval}.
     *
     * @stability stable
     */
    readonly interval: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_tumbling_window#max_concurrency DataFactoryTriggerTumblingWindow#max_concurrency}.
     *
     * @stability stable
     */
    readonly maxConcurrency?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_tumbling_window#name DataFactoryTriggerTumblingWindow#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_tumbling_window#start_time DataFactoryTriggerTumblingWindow#start_time}.
     *
     * @stability stable
     */
    readonly startTime: string;
    /**
     * pipeline block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_tumbling_window#pipeline DataFactoryTriggerTumblingWindow#pipeline}
     *
     * @stability stable
     */
    readonly pipeline: DataFactoryTriggerTumblingWindowPipeline;
    /**
     * retry block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_tumbling_window#retry DataFactoryTriggerTumblingWindow#retry}
     *
     * @stability stable
     */
    readonly retry?: DataFactoryTriggerTumblingWindowRetry;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_tumbling_window#timeouts DataFactoryTriggerTumblingWindow#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataFactoryTriggerTumblingWindowTimeouts;
    /**
     * trigger_dependency block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_tumbling_window#trigger_dependency DataFactoryTriggerTumblingWindow#trigger_dependency}
     *
     * @stability stable
     */
    readonly triggerDependency?: DataFactoryTriggerTumblingWindowTriggerDependency[] | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface DataFactoryTriggerTumblingWindowPipeline {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_tumbling_window#name DataFactoryTriggerTumblingWindow#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_tumbling_window#parameters DataFactoryTriggerTumblingWindow#parameters}.
     *
     * @stability stable
     */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function dataFactoryTriggerTumblingWindowPipelineToTerraform(struct?: DataFactoryTriggerTumblingWindowPipelineOutputReference | DataFactoryTriggerTumblingWindowPipeline): any;
/**
 * @stability stable
 */
export declare class DataFactoryTriggerTumblingWindowPipelineOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryTriggerTumblingWindowPipeline | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryTriggerTumblingWindowPipeline | undefined);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _parameters?;
    /**
     * @stability stable
     */
    get parameters(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set parameters(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetParameters(): void;
    /**
     * @stability stable
     */
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryTriggerTumblingWindowRetry {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_tumbling_window#count DataFactoryTriggerTumblingWindow#count}.
     *
     * @stability stable
     */
    readonly count: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_tumbling_window#interval DataFactoryTriggerTumblingWindow#interval}.
     *
     * @stability stable
     */
    readonly interval?: number;
}
export declare function dataFactoryTriggerTumblingWindowRetryToTerraform(struct?: DataFactoryTriggerTumblingWindowRetryOutputReference | DataFactoryTriggerTumblingWindowRetry): any;
/**
 * @stability stable
 */
export declare class DataFactoryTriggerTumblingWindowRetryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryTriggerTumblingWindowRetry | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryTriggerTumblingWindowRetry | undefined);
    private _count?;
    /**
     * @stability stable
     */
    get count(): number;
    /**
     * @stability stable
     */
    set count(value: number);
    /**
     * @stability stable
     */
    get countInput(): number | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryTriggerTumblingWindowTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_tumbling_window#create DataFactoryTriggerTumblingWindow#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_tumbling_window#delete DataFactoryTriggerTumblingWindow#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_tumbling_window#read DataFactoryTriggerTumblingWindow#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_tumbling_window#update DataFactoryTriggerTumblingWindow#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dataFactoryTriggerTumblingWindowTimeoutsToTerraform(struct?: DataFactoryTriggerTumblingWindowTimeoutsOutputReference | DataFactoryTriggerTumblingWindowTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataFactoryTriggerTumblingWindowTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryTriggerTumblingWindowTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryTriggerTumblingWindowTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryTriggerTumblingWindowTriggerDependency {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_tumbling_window#offset DataFactoryTriggerTumblingWindow#offset}.
     *
     * @stability stable
     */
    readonly offset?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_tumbling_window#size DataFactoryTriggerTumblingWindow#size}.
     *
     * @stability stable
     */
    readonly size?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_tumbling_window#trigger_name DataFactoryTriggerTumblingWindow#trigger_name}.
     *
     * @stability stable
     */
    readonly triggerName?: string;
}
export declare function dataFactoryTriggerTumblingWindowTriggerDependencyToTerraform(struct?: DataFactoryTriggerTumblingWindowTriggerDependency | cdktf.IResolvable): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_tumbling_window azurerm_data_factory_trigger_tumbling_window}.
 *
 * @stability stable
 */
export declare class DataFactoryTriggerTumblingWindow extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_tumbling_window azurerm_data_factory_trigger_tumbling_window} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataFactoryTriggerTumblingWindowConfig);
    private _activated?;
    /**
     * @stability stable
     */
    get activated(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set activated(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetActivated(): void;
    /**
     * @stability stable
     */
    get activatedInput(): boolean | cdktf.IResolvable | undefined;
    private _additionalProperties?;
    /**
     * @stability stable
     */
    get additionalProperties(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set additionalProperties(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetAdditionalProperties(): void;
    /**
     * @stability stable
     */
    get additionalPropertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _annotations?;
    /**
     * @stability stable
     */
    get annotations(): string[];
    /**
     * @stability stable
     */
    set annotations(value: string[]);
    /**
     * @stability stable
     */
    resetAnnotations(): void;
    /**
     * @stability stable
     */
    get annotationsInput(): string[] | undefined;
    private _dataFactoryId?;
    /**
     * @stability stable
     */
    get dataFactoryId(): string;
    /**
     * @stability stable
     */
    set dataFactoryId(value: string);
    /**
     * @stability stable
     */
    get dataFactoryIdInput(): string | undefined;
    private _delay?;
    /**
     * @stability stable
     */
    get delay(): string;
    /**
     * @stability stable
     */
    set delay(value: string);
    /**
     * @stability stable
     */
    resetDelay(): void;
    /**
     * @stability stable
     */
    get delayInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _endTime?;
    /**
     * @stability stable
     */
    get endTime(): string;
    /**
     * @stability stable
     */
    set endTime(value: string);
    /**
     * @stability stable
     */
    resetEndTime(): void;
    /**
     * @stability stable
     */
    get endTimeInput(): string | undefined;
    private _frequency?;
    /**
     * @stability stable
     */
    get frequency(): string;
    /**
     * @stability stable
     */
    set frequency(value: string);
    /**
     * @stability stable
     */
    get frequencyInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
    private _maxConcurrency?;
    /**
     * @stability stable
     */
    get maxConcurrency(): number;
    /**
     * @stability stable
     */
    set maxConcurrency(value: number);
    /**
     * @stability stable
     */
    resetMaxConcurrency(): void;
    /**
     * @stability stable
     */
    get maxConcurrencyInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _startTime?;
    /**
     * @stability stable
     */
    get startTime(): string;
    /**
     * @stability stable
     */
    set startTime(value: string);
    /**
     * @stability stable
     */
    get startTimeInput(): string | undefined;
    private _pipeline;
    /**
     * @stability stable
     */
    get pipeline(): DataFactoryTriggerTumblingWindowPipelineOutputReference;
    /**
     * @stability stable
     */
    putPipeline(value: DataFactoryTriggerTumblingWindowPipeline): void;
    /**
     * @stability stable
     */
    get pipelineInput(): DataFactoryTriggerTumblingWindowPipeline | undefined;
    private _retry;
    /**
     * @stability stable
     */
    get retry(): DataFactoryTriggerTumblingWindowRetryOutputReference;
    /**
     * @stability stable
     */
    putRetry(value: DataFactoryTriggerTumblingWindowRetry): void;
    /**
     * @stability stable
     */
    resetRetry(): void;
    /**
     * @stability stable
     */
    get retryInput(): DataFactoryTriggerTumblingWindowRetry | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataFactoryTriggerTumblingWindowTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataFactoryTriggerTumblingWindowTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataFactoryTriggerTumblingWindowTimeouts | undefined;
    private _triggerDependency?;
    /**
     * @stability stable
     */
    get triggerDependency(): DataFactoryTriggerTumblingWindowTriggerDependency[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set triggerDependency(value: DataFactoryTriggerTumblingWindowTriggerDependency[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTriggerDependency(): void;
    /**
     * @stability stable
     */
    get triggerDependencyInput(): cdktf.IResolvable | DataFactoryTriggerTumblingWindowTriggerDependency[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
