import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DiskPoolIscsiTargetConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_iscsi_target#acl_mode DiskPoolIscsiTarget#acl_mode}.
     *
     * @stability stable
     */
    readonly aclMode: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_iscsi_target#disks_pool_id DiskPoolIscsiTarget#disks_pool_id}.
     *
     * @stability stable
     */
    readonly disksPoolId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_iscsi_target#name DiskPoolIscsiTarget#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_iscsi_target#target_iqn DiskPoolIscsiTarget#target_iqn}.
     *
     * @stability stable
     */
    readonly targetIqn?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_iscsi_target#timeouts DiskPoolIscsiTarget#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DiskPoolIscsiTargetTimeouts;
}
/**
 * @stability stable
 */
export interface DiskPoolIscsiTargetTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_iscsi_target#create DiskPoolIscsiTarget#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_iscsi_target#delete DiskPoolIscsiTarget#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_iscsi_target#read DiskPoolIscsiTarget#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function diskPoolIscsiTargetTimeoutsToTerraform(struct?: DiskPoolIscsiTargetTimeoutsOutputReference | DiskPoolIscsiTargetTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DiskPoolIscsiTargetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DiskPoolIscsiTargetTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DiskPoolIscsiTargetTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_iscsi_target azurerm_disk_pool_iscsi_target}.
 *
 * @stability stable
 */
export declare class DiskPoolIscsiTarget extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_iscsi_target azurerm_disk_pool_iscsi_target} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DiskPoolIscsiTargetConfig);
    private _aclMode?;
    /**
     * @stability stable
     */
    get aclMode(): string;
    /**
     * @stability stable
     */
    set aclMode(value: string);
    /**
     * @stability stable
     */
    get aclModeInput(): string | undefined;
    private _disksPoolId?;
    /**
     * @stability stable
     */
    get disksPoolId(): string;
    /**
     * @stability stable
     */
    set disksPoolId(value: string);
    /**
     * @stability stable
     */
    get disksPoolIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get endpoints(): string[];
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get port(): number;
    private _targetIqn?;
    /**
     * @stability stable
     */
    get targetIqn(): string;
    /**
     * @stability stable
     */
    set targetIqn(value: string);
    /**
     * @stability stable
     */
    resetTargetIqn(): void;
    /**
     * @stability stable
     */
    get targetIqnInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DiskPoolIscsiTargetTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DiskPoolIscsiTargetTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DiskPoolIscsiTargetTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
