import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface EventgridSystemTopicEventSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#advanced_filtering_on_arrays_enabled EventgridSystemTopicEventSubscription#advanced_filtering_on_arrays_enabled}.
     *
     * @stability stable
     */
    readonly advancedFilteringOnArraysEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#event_delivery_schema EventgridSystemTopicEventSubscription#event_delivery_schema}.
     *
     * @stability stable
     */
    readonly eventDeliverySchema?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#eventhub_endpoint_id EventgridSystemTopicEventSubscription#eventhub_endpoint_id}.
     *
     * @stability stable
     */
    readonly eventhubEndpointId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#expiration_time_utc EventgridSystemTopicEventSubscription#expiration_time_utc}.
     *
     * @stability stable
     */
    readonly expirationTimeUtc?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#hybrid_connection_endpoint_id EventgridSystemTopicEventSubscription#hybrid_connection_endpoint_id}.
     *
     * @stability stable
     */
    readonly hybridConnectionEndpointId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#included_event_types EventgridSystemTopicEventSubscription#included_event_types}.
     *
     * @stability stable
     */
    readonly includedEventTypes?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#labels EventgridSystemTopicEventSubscription#labels}.
     *
     * @stability stable
     */
    readonly labels?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#name EventgridSystemTopicEventSubscription#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#resource_group_name EventgridSystemTopicEventSubscription#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#service_bus_queue_endpoint_id EventgridSystemTopicEventSubscription#service_bus_queue_endpoint_id}.
     *
     * @stability stable
     */
    readonly serviceBusQueueEndpointId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#service_bus_topic_endpoint_id EventgridSystemTopicEventSubscription#service_bus_topic_endpoint_id}.
     *
     * @stability stable
     */
    readonly serviceBusTopicEndpointId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#system_topic EventgridSystemTopicEventSubscription#system_topic}.
     *
     * @stability stable
     */
    readonly systemTopic: string;
    /**
     * advanced_filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#advanced_filter EventgridSystemTopicEventSubscription#advanced_filter}
     *
     * @stability stable
     */
    readonly advancedFilter?: EventgridSystemTopicEventSubscriptionAdvancedFilter;
    /**
     * azure_function_endpoint block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#azure_function_endpoint EventgridSystemTopicEventSubscription#azure_function_endpoint}
     *
     * @stability stable
     */
    readonly azureFunctionEndpoint?: EventgridSystemTopicEventSubscriptionAzureFunctionEndpoint;
    /**
     * dead_letter_identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#dead_letter_identity EventgridSystemTopicEventSubscription#dead_letter_identity}
     *
     * @stability stable
     */
    readonly deadLetterIdentity?: EventgridSystemTopicEventSubscriptionDeadLetterIdentity;
    /**
     * delivery_identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#delivery_identity EventgridSystemTopicEventSubscription#delivery_identity}
     *
     * @stability stable
     */
    readonly deliveryIdentity?: EventgridSystemTopicEventSubscriptionDeliveryIdentity;
    /**
     * retry_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#retry_policy EventgridSystemTopicEventSubscription#retry_policy}
     *
     * @stability stable
     */
    readonly retryPolicy?: EventgridSystemTopicEventSubscriptionRetryPolicy;
    /**
     * storage_blob_dead_letter_destination block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#storage_blob_dead_letter_destination EventgridSystemTopicEventSubscription#storage_blob_dead_letter_destination}
     *
     * @stability stable
     */
    readonly storageBlobDeadLetterDestination?: EventgridSystemTopicEventSubscriptionStorageBlobDeadLetterDestination;
    /**
     * storage_queue_endpoint block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#storage_queue_endpoint EventgridSystemTopicEventSubscription#storage_queue_endpoint}
     *
     * @stability stable
     */
    readonly storageQueueEndpoint?: EventgridSystemTopicEventSubscriptionStorageQueueEndpoint;
    /**
     * subject_filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#subject_filter EventgridSystemTopicEventSubscription#subject_filter}
     *
     * @stability stable
     */
    readonly subjectFilter?: EventgridSystemTopicEventSubscriptionSubjectFilter;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#timeouts EventgridSystemTopicEventSubscription#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: EventgridSystemTopicEventSubscriptionTimeouts;
    /**
     * webhook_endpoint block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#webhook_endpoint EventgridSystemTopicEventSubscription#webhook_endpoint}
     *
     * @stability stable
     */
    readonly webhookEndpoint?: EventgridSystemTopicEventSubscriptionWebhookEndpoint;
}
/**
 * @stability stable
 */
export interface EventgridSystemTopicEventSubscriptionAdvancedFilterBoolEquals {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#key EventgridSystemTopicEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#value EventgridSystemTopicEventSubscription#value}.
     *
     * @stability stable
     */
    readonly value: boolean | cdktf.IResolvable;
}
export declare function eventgridSystemTopicEventSubscriptionAdvancedFilterBoolEqualsToTerraform(struct?: EventgridSystemTopicEventSubscriptionAdvancedFilterBoolEquals | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface EventgridSystemTopicEventSubscriptionAdvancedFilterIsNotNull {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#key EventgridSystemTopicEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
}
export declare function eventgridSystemTopicEventSubscriptionAdvancedFilterIsNotNullToTerraform(struct?: EventgridSystemTopicEventSubscriptionAdvancedFilterIsNotNull | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface EventgridSystemTopicEventSubscriptionAdvancedFilterIsNullOrUndefined {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#key EventgridSystemTopicEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
}
export declare function eventgridSystemTopicEventSubscriptionAdvancedFilterIsNullOrUndefinedToTerraform(struct?: EventgridSystemTopicEventSubscriptionAdvancedFilterIsNullOrUndefined | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface EventgridSystemTopicEventSubscriptionAdvancedFilterNumberGreaterThan {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#key EventgridSystemTopicEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#value EventgridSystemTopicEventSubscription#value}.
     *
     * @stability stable
     */
    readonly value: number;
}
export declare function eventgridSystemTopicEventSubscriptionAdvancedFilterNumberGreaterThanToTerraform(struct?: EventgridSystemTopicEventSubscriptionAdvancedFilterNumberGreaterThan | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface EventgridSystemTopicEventSubscriptionAdvancedFilterNumberGreaterThanOrEquals {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#key EventgridSystemTopicEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#value EventgridSystemTopicEventSubscription#value}.
     *
     * @stability stable
     */
    readonly value: number;
}
export declare function eventgridSystemTopicEventSubscriptionAdvancedFilterNumberGreaterThanOrEqualsToTerraform(struct?: EventgridSystemTopicEventSubscriptionAdvancedFilterNumberGreaterThanOrEquals | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface EventgridSystemTopicEventSubscriptionAdvancedFilterNumberIn {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#key EventgridSystemTopicEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#values EventgridSystemTopicEventSubscription#values}.
     *
     * @stability stable
     */
    readonly values: number[];
}
export declare function eventgridSystemTopicEventSubscriptionAdvancedFilterNumberInToTerraform(struct?: EventgridSystemTopicEventSubscriptionAdvancedFilterNumberIn | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface EventgridSystemTopicEventSubscriptionAdvancedFilterNumberInRange {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#key EventgridSystemTopicEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#values EventgridSystemTopicEventSubscription#values}.
     *
     * @stability stable
     */
    readonly values: number[];
}
export declare function eventgridSystemTopicEventSubscriptionAdvancedFilterNumberInRangeToTerraform(struct?: EventgridSystemTopicEventSubscriptionAdvancedFilterNumberInRange | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface EventgridSystemTopicEventSubscriptionAdvancedFilterNumberLessThan {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#key EventgridSystemTopicEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#value EventgridSystemTopicEventSubscription#value}.
     *
     * @stability stable
     */
    readonly value: number;
}
export declare function eventgridSystemTopicEventSubscriptionAdvancedFilterNumberLessThanToTerraform(struct?: EventgridSystemTopicEventSubscriptionAdvancedFilterNumberLessThan | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface EventgridSystemTopicEventSubscriptionAdvancedFilterNumberLessThanOrEquals {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#key EventgridSystemTopicEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#value EventgridSystemTopicEventSubscription#value}.
     *
     * @stability stable
     */
    readonly value: number;
}
export declare function eventgridSystemTopicEventSubscriptionAdvancedFilterNumberLessThanOrEqualsToTerraform(struct?: EventgridSystemTopicEventSubscriptionAdvancedFilterNumberLessThanOrEquals | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface EventgridSystemTopicEventSubscriptionAdvancedFilterNumberNotIn {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#key EventgridSystemTopicEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#values EventgridSystemTopicEventSubscription#values}.
     *
     * @stability stable
     */
    readonly values: number[];
}
export declare function eventgridSystemTopicEventSubscriptionAdvancedFilterNumberNotInToTerraform(struct?: EventgridSystemTopicEventSubscriptionAdvancedFilterNumberNotIn | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface EventgridSystemTopicEventSubscriptionAdvancedFilterNumberNotInRange {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#key EventgridSystemTopicEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#values EventgridSystemTopicEventSubscription#values}.
     *
     * @stability stable
     */
    readonly values: number[];
}
export declare function eventgridSystemTopicEventSubscriptionAdvancedFilterNumberNotInRangeToTerraform(struct?: EventgridSystemTopicEventSubscriptionAdvancedFilterNumberNotInRange | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface EventgridSystemTopicEventSubscriptionAdvancedFilterStringBeginsWith {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#key EventgridSystemTopicEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#values EventgridSystemTopicEventSubscription#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function eventgridSystemTopicEventSubscriptionAdvancedFilterStringBeginsWithToTerraform(struct?: EventgridSystemTopicEventSubscriptionAdvancedFilterStringBeginsWith | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface EventgridSystemTopicEventSubscriptionAdvancedFilterStringContains {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#key EventgridSystemTopicEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#values EventgridSystemTopicEventSubscription#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function eventgridSystemTopicEventSubscriptionAdvancedFilterStringContainsToTerraform(struct?: EventgridSystemTopicEventSubscriptionAdvancedFilterStringContains | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface EventgridSystemTopicEventSubscriptionAdvancedFilterStringEndsWith {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#key EventgridSystemTopicEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#values EventgridSystemTopicEventSubscription#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function eventgridSystemTopicEventSubscriptionAdvancedFilterStringEndsWithToTerraform(struct?: EventgridSystemTopicEventSubscriptionAdvancedFilterStringEndsWith | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface EventgridSystemTopicEventSubscriptionAdvancedFilterStringIn {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#key EventgridSystemTopicEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#values EventgridSystemTopicEventSubscription#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function eventgridSystemTopicEventSubscriptionAdvancedFilterStringInToTerraform(struct?: EventgridSystemTopicEventSubscriptionAdvancedFilterStringIn | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface EventgridSystemTopicEventSubscriptionAdvancedFilterStringNotBeginsWith {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#key EventgridSystemTopicEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#values EventgridSystemTopicEventSubscription#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function eventgridSystemTopicEventSubscriptionAdvancedFilterStringNotBeginsWithToTerraform(struct?: EventgridSystemTopicEventSubscriptionAdvancedFilterStringNotBeginsWith | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface EventgridSystemTopicEventSubscriptionAdvancedFilterStringNotContains {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#key EventgridSystemTopicEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#values EventgridSystemTopicEventSubscription#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function eventgridSystemTopicEventSubscriptionAdvancedFilterStringNotContainsToTerraform(struct?: EventgridSystemTopicEventSubscriptionAdvancedFilterStringNotContains | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface EventgridSystemTopicEventSubscriptionAdvancedFilterStringNotEndsWith {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#key EventgridSystemTopicEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#values EventgridSystemTopicEventSubscription#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function eventgridSystemTopicEventSubscriptionAdvancedFilterStringNotEndsWithToTerraform(struct?: EventgridSystemTopicEventSubscriptionAdvancedFilterStringNotEndsWith | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface EventgridSystemTopicEventSubscriptionAdvancedFilterStringNotIn {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#key EventgridSystemTopicEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#values EventgridSystemTopicEventSubscription#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function eventgridSystemTopicEventSubscriptionAdvancedFilterStringNotInToTerraform(struct?: EventgridSystemTopicEventSubscriptionAdvancedFilterStringNotIn | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface EventgridSystemTopicEventSubscriptionAdvancedFilter {
    /**
     * bool_equals block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#bool_equals EventgridSystemTopicEventSubscription#bool_equals}
     *
     * @stability stable
     */
    readonly boolEquals?: EventgridSystemTopicEventSubscriptionAdvancedFilterBoolEquals[] | cdktf.IResolvable;
    /**
     * is_not_null block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#is_not_null EventgridSystemTopicEventSubscription#is_not_null}
     *
     * @stability stable
     */
    readonly isNotNull?: EventgridSystemTopicEventSubscriptionAdvancedFilterIsNotNull[] | cdktf.IResolvable;
    /**
     * is_null_or_undefined block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#is_null_or_undefined EventgridSystemTopicEventSubscription#is_null_or_undefined}
     *
     * @stability stable
     */
    readonly isNullOrUndefined?: EventgridSystemTopicEventSubscriptionAdvancedFilterIsNullOrUndefined[] | cdktf.IResolvable;
    /**
     * number_greater_than block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#number_greater_than EventgridSystemTopicEventSubscription#number_greater_than}
     *
     * @stability stable
     */
    readonly numberGreaterThan?: EventgridSystemTopicEventSubscriptionAdvancedFilterNumberGreaterThan[] | cdktf.IResolvable;
    /**
     * number_greater_than_or_equals block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#number_greater_than_or_equals EventgridSystemTopicEventSubscription#number_greater_than_or_equals}
     *
     * @stability stable
     */
    readonly numberGreaterThanOrEquals?: EventgridSystemTopicEventSubscriptionAdvancedFilterNumberGreaterThanOrEquals[] | cdktf.IResolvable;
    /**
     * number_in block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#number_in EventgridSystemTopicEventSubscription#number_in}
     *
     * @stability stable
     */
    readonly numberIn?: EventgridSystemTopicEventSubscriptionAdvancedFilterNumberIn[] | cdktf.IResolvable;
    /**
     * number_in_range block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#number_in_range EventgridSystemTopicEventSubscription#number_in_range}
     *
     * @stability stable
     */
    readonly numberInRange?: EventgridSystemTopicEventSubscriptionAdvancedFilterNumberInRange[] | cdktf.IResolvable;
    /**
     * number_less_than block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#number_less_than EventgridSystemTopicEventSubscription#number_less_than}
     *
     * @stability stable
     */
    readonly numberLessThan?: EventgridSystemTopicEventSubscriptionAdvancedFilterNumberLessThan[] | cdktf.IResolvable;
    /**
     * number_less_than_or_equals block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#number_less_than_or_equals EventgridSystemTopicEventSubscription#number_less_than_or_equals}
     *
     * @stability stable
     */
    readonly numberLessThanOrEquals?: EventgridSystemTopicEventSubscriptionAdvancedFilterNumberLessThanOrEquals[] | cdktf.IResolvable;
    /**
     * number_not_in block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#number_not_in EventgridSystemTopicEventSubscription#number_not_in}
     *
     * @stability stable
     */
    readonly numberNotIn?: EventgridSystemTopicEventSubscriptionAdvancedFilterNumberNotIn[] | cdktf.IResolvable;
    /**
     * number_not_in_range block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#number_not_in_range EventgridSystemTopicEventSubscription#number_not_in_range}
     *
     * @stability stable
     */
    readonly numberNotInRange?: EventgridSystemTopicEventSubscriptionAdvancedFilterNumberNotInRange[] | cdktf.IResolvable;
    /**
     * string_begins_with block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#string_begins_with EventgridSystemTopicEventSubscription#string_begins_with}
     *
     * @stability stable
     */
    readonly stringBeginsWith?: EventgridSystemTopicEventSubscriptionAdvancedFilterStringBeginsWith[] | cdktf.IResolvable;
    /**
     * string_contains block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#string_contains EventgridSystemTopicEventSubscription#string_contains}
     *
     * @stability stable
     */
    readonly stringContains?: EventgridSystemTopicEventSubscriptionAdvancedFilterStringContains[] | cdktf.IResolvable;
    /**
     * string_ends_with block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#string_ends_with EventgridSystemTopicEventSubscription#string_ends_with}
     *
     * @stability stable
     */
    readonly stringEndsWith?: EventgridSystemTopicEventSubscriptionAdvancedFilterStringEndsWith[] | cdktf.IResolvable;
    /**
     * string_in block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#string_in EventgridSystemTopicEventSubscription#string_in}
     *
     * @stability stable
     */
    readonly stringIn?: EventgridSystemTopicEventSubscriptionAdvancedFilterStringIn[] | cdktf.IResolvable;
    /**
     * string_not_begins_with block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#string_not_begins_with EventgridSystemTopicEventSubscription#string_not_begins_with}
     *
     * @stability stable
     */
    readonly stringNotBeginsWith?: EventgridSystemTopicEventSubscriptionAdvancedFilterStringNotBeginsWith[] | cdktf.IResolvable;
    /**
     * string_not_contains block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#string_not_contains EventgridSystemTopicEventSubscription#string_not_contains}
     *
     * @stability stable
     */
    readonly stringNotContains?: EventgridSystemTopicEventSubscriptionAdvancedFilterStringNotContains[] | cdktf.IResolvable;
    /**
     * string_not_ends_with block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#string_not_ends_with EventgridSystemTopicEventSubscription#string_not_ends_with}
     *
     * @stability stable
     */
    readonly stringNotEndsWith?: EventgridSystemTopicEventSubscriptionAdvancedFilterStringNotEndsWith[] | cdktf.IResolvable;
    /**
     * string_not_in block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#string_not_in EventgridSystemTopicEventSubscription#string_not_in}
     *
     * @stability stable
     */
    readonly stringNotIn?: EventgridSystemTopicEventSubscriptionAdvancedFilterStringNotIn[] | cdktf.IResolvable;
}
export declare function eventgridSystemTopicEventSubscriptionAdvancedFilterToTerraform(struct?: EventgridSystemTopicEventSubscriptionAdvancedFilterOutputReference | EventgridSystemTopicEventSubscriptionAdvancedFilter): any;
/**
 * @stability stable
 */
export declare class EventgridSystemTopicEventSubscriptionAdvancedFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventgridSystemTopicEventSubscriptionAdvancedFilter | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventgridSystemTopicEventSubscriptionAdvancedFilter | undefined);
    private _boolEquals?;
    /**
     * @stability stable
     */
    get boolEquals(): EventgridSystemTopicEventSubscriptionAdvancedFilterBoolEquals[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set boolEquals(value: EventgridSystemTopicEventSubscriptionAdvancedFilterBoolEquals[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetBoolEquals(): void;
    /**
     * @stability stable
     */
    get boolEqualsInput(): cdktf.IResolvable | EventgridSystemTopicEventSubscriptionAdvancedFilterBoolEquals[] | undefined;
    private _isNotNull?;
    /**
     * @stability stable
     */
    get isNotNull(): EventgridSystemTopicEventSubscriptionAdvancedFilterIsNotNull[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isNotNull(value: EventgridSystemTopicEventSubscriptionAdvancedFilterIsNotNull[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsNotNull(): void;
    /**
     * @stability stable
     */
    get isNotNullInput(): cdktf.IResolvable | EventgridSystemTopicEventSubscriptionAdvancedFilterIsNotNull[] | undefined;
    private _isNullOrUndefined?;
    /**
     * @stability stable
     */
    get isNullOrUndefined(): EventgridSystemTopicEventSubscriptionAdvancedFilterIsNullOrUndefined[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isNullOrUndefined(value: EventgridSystemTopicEventSubscriptionAdvancedFilterIsNullOrUndefined[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsNullOrUndefined(): void;
    /**
     * @stability stable
     */
    get isNullOrUndefinedInput(): cdktf.IResolvable | EventgridSystemTopicEventSubscriptionAdvancedFilterIsNullOrUndefined[] | undefined;
    private _numberGreaterThan?;
    /**
     * @stability stable
     */
    get numberGreaterThan(): EventgridSystemTopicEventSubscriptionAdvancedFilterNumberGreaterThan[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set numberGreaterThan(value: EventgridSystemTopicEventSubscriptionAdvancedFilterNumberGreaterThan[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNumberGreaterThan(): void;
    /**
     * @stability stable
     */
    get numberGreaterThanInput(): cdktf.IResolvable | EventgridSystemTopicEventSubscriptionAdvancedFilterNumberGreaterThan[] | undefined;
    private _numberGreaterThanOrEquals?;
    /**
     * @stability stable
     */
    get numberGreaterThanOrEquals(): EventgridSystemTopicEventSubscriptionAdvancedFilterNumberGreaterThanOrEquals[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set numberGreaterThanOrEquals(value: EventgridSystemTopicEventSubscriptionAdvancedFilterNumberGreaterThanOrEquals[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNumberGreaterThanOrEquals(): void;
    /**
     * @stability stable
     */
    get numberGreaterThanOrEqualsInput(): cdktf.IResolvable | EventgridSystemTopicEventSubscriptionAdvancedFilterNumberGreaterThanOrEquals[] | undefined;
    private _numberIn?;
    /**
     * @stability stable
     */
    get numberIn(): EventgridSystemTopicEventSubscriptionAdvancedFilterNumberIn[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set numberIn(value: EventgridSystemTopicEventSubscriptionAdvancedFilterNumberIn[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNumberIn(): void;
    /**
     * @stability stable
     */
    get numberInInput(): cdktf.IResolvable | EventgridSystemTopicEventSubscriptionAdvancedFilterNumberIn[] | undefined;
    private _numberInRange?;
    /**
     * @stability stable
     */
    get numberInRange(): EventgridSystemTopicEventSubscriptionAdvancedFilterNumberInRange[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set numberInRange(value: EventgridSystemTopicEventSubscriptionAdvancedFilterNumberInRange[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNumberInRange(): void;
    /**
     * @stability stable
     */
    get numberInRangeInput(): cdktf.IResolvable | EventgridSystemTopicEventSubscriptionAdvancedFilterNumberInRange[] | undefined;
    private _numberLessThan?;
    /**
     * @stability stable
     */
    get numberLessThan(): EventgridSystemTopicEventSubscriptionAdvancedFilterNumberLessThan[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set numberLessThan(value: EventgridSystemTopicEventSubscriptionAdvancedFilterNumberLessThan[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNumberLessThan(): void;
    /**
     * @stability stable
     */
    get numberLessThanInput(): cdktf.IResolvable | EventgridSystemTopicEventSubscriptionAdvancedFilterNumberLessThan[] | undefined;
    private _numberLessThanOrEquals?;
    /**
     * @stability stable
     */
    get numberLessThanOrEquals(): EventgridSystemTopicEventSubscriptionAdvancedFilterNumberLessThanOrEquals[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set numberLessThanOrEquals(value: EventgridSystemTopicEventSubscriptionAdvancedFilterNumberLessThanOrEquals[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNumberLessThanOrEquals(): void;
    /**
     * @stability stable
     */
    get numberLessThanOrEqualsInput(): cdktf.IResolvable | EventgridSystemTopicEventSubscriptionAdvancedFilterNumberLessThanOrEquals[] | undefined;
    private _numberNotIn?;
    /**
     * @stability stable
     */
    get numberNotIn(): EventgridSystemTopicEventSubscriptionAdvancedFilterNumberNotIn[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set numberNotIn(value: EventgridSystemTopicEventSubscriptionAdvancedFilterNumberNotIn[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNumberNotIn(): void;
    /**
     * @stability stable
     */
    get numberNotInInput(): cdktf.IResolvable | EventgridSystemTopicEventSubscriptionAdvancedFilterNumberNotIn[] | undefined;
    private _numberNotInRange?;
    /**
     * @stability stable
     */
    get numberNotInRange(): EventgridSystemTopicEventSubscriptionAdvancedFilterNumberNotInRange[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set numberNotInRange(value: EventgridSystemTopicEventSubscriptionAdvancedFilterNumberNotInRange[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNumberNotInRange(): void;
    /**
     * @stability stable
     */
    get numberNotInRangeInput(): cdktf.IResolvable | EventgridSystemTopicEventSubscriptionAdvancedFilterNumberNotInRange[] | undefined;
    private _stringBeginsWith?;
    /**
     * @stability stable
     */
    get stringBeginsWith(): EventgridSystemTopicEventSubscriptionAdvancedFilterStringBeginsWith[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set stringBeginsWith(value: EventgridSystemTopicEventSubscriptionAdvancedFilterStringBeginsWith[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetStringBeginsWith(): void;
    /**
     * @stability stable
     */
    get stringBeginsWithInput(): cdktf.IResolvable | EventgridSystemTopicEventSubscriptionAdvancedFilterStringBeginsWith[] | undefined;
    private _stringContains?;
    /**
     * @stability stable
     */
    get stringContains(): EventgridSystemTopicEventSubscriptionAdvancedFilterStringContains[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set stringContains(value: EventgridSystemTopicEventSubscriptionAdvancedFilterStringContains[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetStringContains(): void;
    /**
     * @stability stable
     */
    get stringContainsInput(): cdktf.IResolvable | EventgridSystemTopicEventSubscriptionAdvancedFilterStringContains[] | undefined;
    private _stringEndsWith?;
    /**
     * @stability stable
     */
    get stringEndsWith(): EventgridSystemTopicEventSubscriptionAdvancedFilterStringEndsWith[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set stringEndsWith(value: EventgridSystemTopicEventSubscriptionAdvancedFilterStringEndsWith[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetStringEndsWith(): void;
    /**
     * @stability stable
     */
    get stringEndsWithInput(): cdktf.IResolvable | EventgridSystemTopicEventSubscriptionAdvancedFilterStringEndsWith[] | undefined;
    private _stringIn?;
    /**
     * @stability stable
     */
    get stringIn(): EventgridSystemTopicEventSubscriptionAdvancedFilterStringIn[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set stringIn(value: EventgridSystemTopicEventSubscriptionAdvancedFilterStringIn[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetStringIn(): void;
    /**
     * @stability stable
     */
    get stringInInput(): cdktf.IResolvable | EventgridSystemTopicEventSubscriptionAdvancedFilterStringIn[] | undefined;
    private _stringNotBeginsWith?;
    /**
     * @stability stable
     */
    get stringNotBeginsWith(): EventgridSystemTopicEventSubscriptionAdvancedFilterStringNotBeginsWith[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set stringNotBeginsWith(value: EventgridSystemTopicEventSubscriptionAdvancedFilterStringNotBeginsWith[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetStringNotBeginsWith(): void;
    /**
     * @stability stable
     */
    get stringNotBeginsWithInput(): cdktf.IResolvable | EventgridSystemTopicEventSubscriptionAdvancedFilterStringNotBeginsWith[] | undefined;
    private _stringNotContains?;
    /**
     * @stability stable
     */
    get stringNotContains(): EventgridSystemTopicEventSubscriptionAdvancedFilterStringNotContains[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set stringNotContains(value: EventgridSystemTopicEventSubscriptionAdvancedFilterStringNotContains[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetStringNotContains(): void;
    /**
     * @stability stable
     */
    get stringNotContainsInput(): cdktf.IResolvable | EventgridSystemTopicEventSubscriptionAdvancedFilterStringNotContains[] | undefined;
    private _stringNotEndsWith?;
    /**
     * @stability stable
     */
    get stringNotEndsWith(): EventgridSystemTopicEventSubscriptionAdvancedFilterStringNotEndsWith[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set stringNotEndsWith(value: EventgridSystemTopicEventSubscriptionAdvancedFilterStringNotEndsWith[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetStringNotEndsWith(): void;
    /**
     * @stability stable
     */
    get stringNotEndsWithInput(): cdktf.IResolvable | EventgridSystemTopicEventSubscriptionAdvancedFilterStringNotEndsWith[] | undefined;
    private _stringNotIn?;
    /**
     * @stability stable
     */
    get stringNotIn(): EventgridSystemTopicEventSubscriptionAdvancedFilterStringNotIn[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set stringNotIn(value: EventgridSystemTopicEventSubscriptionAdvancedFilterStringNotIn[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetStringNotIn(): void;
    /**
     * @stability stable
     */
    get stringNotInInput(): cdktf.IResolvable | EventgridSystemTopicEventSubscriptionAdvancedFilterStringNotIn[] | undefined;
}
/**
 * @stability stable
 */
export interface EventgridSystemTopicEventSubscriptionAzureFunctionEndpoint {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#function_id EventgridSystemTopicEventSubscription#function_id}.
     *
     * @stability stable
     */
    readonly functionId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#max_events_per_batch EventgridSystemTopicEventSubscription#max_events_per_batch}.
     *
     * @stability stable
     */
    readonly maxEventsPerBatch?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#preferred_batch_size_in_kilobytes EventgridSystemTopicEventSubscription#preferred_batch_size_in_kilobytes}.
     *
     * @stability stable
     */
    readonly preferredBatchSizeInKilobytes?: number;
}
export declare function eventgridSystemTopicEventSubscriptionAzureFunctionEndpointToTerraform(struct?: EventgridSystemTopicEventSubscriptionAzureFunctionEndpointOutputReference | EventgridSystemTopicEventSubscriptionAzureFunctionEndpoint): any;
/**
 * @stability stable
 */
export declare class EventgridSystemTopicEventSubscriptionAzureFunctionEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventgridSystemTopicEventSubscriptionAzureFunctionEndpoint | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventgridSystemTopicEventSubscriptionAzureFunctionEndpoint | undefined);
    private _functionId?;
    /**
     * @stability stable
     */
    get functionId(): string;
    /**
     * @stability stable
     */
    set functionId(value: string);
    /**
     * @stability stable
     */
    get functionIdInput(): string | undefined;
    private _maxEventsPerBatch?;
    /**
     * @stability stable
     */
    get maxEventsPerBatch(): number;
    /**
     * @stability stable
     */
    set maxEventsPerBatch(value: number);
    /**
     * @stability stable
     */
    resetMaxEventsPerBatch(): void;
    /**
     * @stability stable
     */
    get maxEventsPerBatchInput(): number | undefined;
    private _preferredBatchSizeInKilobytes?;
    /**
     * @stability stable
     */
    get preferredBatchSizeInKilobytes(): number;
    /**
     * @stability stable
     */
    set preferredBatchSizeInKilobytes(value: number);
    /**
     * @stability stable
     */
    resetPreferredBatchSizeInKilobytes(): void;
    /**
     * @stability stable
     */
    get preferredBatchSizeInKilobytesInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface EventgridSystemTopicEventSubscriptionDeadLetterIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#type EventgridSystemTopicEventSubscription#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#user_assigned_identity EventgridSystemTopicEventSubscription#user_assigned_identity}.
     *
     * @stability stable
     */
    readonly userAssignedIdentity?: string;
}
export declare function eventgridSystemTopicEventSubscriptionDeadLetterIdentityToTerraform(struct?: EventgridSystemTopicEventSubscriptionDeadLetterIdentityOutputReference | EventgridSystemTopicEventSubscriptionDeadLetterIdentity): any;
/**
 * @stability stable
 */
export declare class EventgridSystemTopicEventSubscriptionDeadLetterIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventgridSystemTopicEventSubscriptionDeadLetterIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventgridSystemTopicEventSubscriptionDeadLetterIdentity | undefined);
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _userAssignedIdentity?;
    /**
     * @stability stable
     */
    get userAssignedIdentity(): string;
    /**
     * @stability stable
     */
    set userAssignedIdentity(value: string);
    /**
     * @stability stable
     */
    resetUserAssignedIdentity(): void;
    /**
     * @stability stable
     */
    get userAssignedIdentityInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface EventgridSystemTopicEventSubscriptionDeliveryIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#type EventgridSystemTopicEventSubscription#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#user_assigned_identity EventgridSystemTopicEventSubscription#user_assigned_identity}.
     *
     * @stability stable
     */
    readonly userAssignedIdentity?: string;
}
export declare function eventgridSystemTopicEventSubscriptionDeliveryIdentityToTerraform(struct?: EventgridSystemTopicEventSubscriptionDeliveryIdentityOutputReference | EventgridSystemTopicEventSubscriptionDeliveryIdentity): any;
/**
 * @stability stable
 */
export declare class EventgridSystemTopicEventSubscriptionDeliveryIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventgridSystemTopicEventSubscriptionDeliveryIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventgridSystemTopicEventSubscriptionDeliveryIdentity | undefined);
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _userAssignedIdentity?;
    /**
     * @stability stable
     */
    get userAssignedIdentity(): string;
    /**
     * @stability stable
     */
    set userAssignedIdentity(value: string);
    /**
     * @stability stable
     */
    resetUserAssignedIdentity(): void;
    /**
     * @stability stable
     */
    get userAssignedIdentityInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface EventgridSystemTopicEventSubscriptionRetryPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#event_time_to_live EventgridSystemTopicEventSubscription#event_time_to_live}.
     *
     * @stability stable
     */
    readonly eventTimeToLive: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#max_delivery_attempts EventgridSystemTopicEventSubscription#max_delivery_attempts}.
     *
     * @stability stable
     */
    readonly maxDeliveryAttempts: number;
}
export declare function eventgridSystemTopicEventSubscriptionRetryPolicyToTerraform(struct?: EventgridSystemTopicEventSubscriptionRetryPolicyOutputReference | EventgridSystemTopicEventSubscriptionRetryPolicy): any;
/**
 * @stability stable
 */
export declare class EventgridSystemTopicEventSubscriptionRetryPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventgridSystemTopicEventSubscriptionRetryPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventgridSystemTopicEventSubscriptionRetryPolicy | undefined);
    private _eventTimeToLive?;
    /**
     * @stability stable
     */
    get eventTimeToLive(): number;
    /**
     * @stability stable
     */
    set eventTimeToLive(value: number);
    /**
     * @stability stable
     */
    get eventTimeToLiveInput(): number | undefined;
    private _maxDeliveryAttempts?;
    /**
     * @stability stable
     */
    get maxDeliveryAttempts(): number;
    /**
     * @stability stable
     */
    set maxDeliveryAttempts(value: number);
    /**
     * @stability stable
     */
    get maxDeliveryAttemptsInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface EventgridSystemTopicEventSubscriptionStorageBlobDeadLetterDestination {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#storage_account_id EventgridSystemTopicEventSubscription#storage_account_id}.
     *
     * @stability stable
     */
    readonly storageAccountId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#storage_blob_container_name EventgridSystemTopicEventSubscription#storage_blob_container_name}.
     *
     * @stability stable
     */
    readonly storageBlobContainerName: string;
}
export declare function eventgridSystemTopicEventSubscriptionStorageBlobDeadLetterDestinationToTerraform(struct?: EventgridSystemTopicEventSubscriptionStorageBlobDeadLetterDestinationOutputReference | EventgridSystemTopicEventSubscriptionStorageBlobDeadLetterDestination): any;
/**
 * @stability stable
 */
export declare class EventgridSystemTopicEventSubscriptionStorageBlobDeadLetterDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventgridSystemTopicEventSubscriptionStorageBlobDeadLetterDestination | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventgridSystemTopicEventSubscriptionStorageBlobDeadLetterDestination | undefined);
    private _storageAccountId?;
    /**
     * @stability stable
     */
    get storageAccountId(): string;
    /**
     * @stability stable
     */
    set storageAccountId(value: string);
    /**
     * @stability stable
     */
    get storageAccountIdInput(): string | undefined;
    private _storageBlobContainerName?;
    /**
     * @stability stable
     */
    get storageBlobContainerName(): string;
    /**
     * @stability stable
     */
    set storageBlobContainerName(value: string);
    /**
     * @stability stable
     */
    get storageBlobContainerNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface EventgridSystemTopicEventSubscriptionStorageQueueEndpoint {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#queue_message_time_to_live_in_seconds EventgridSystemTopicEventSubscription#queue_message_time_to_live_in_seconds}.
     *
     * @stability stable
     */
    readonly queueMessageTimeToLiveInSeconds?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#queue_name EventgridSystemTopicEventSubscription#queue_name}.
     *
     * @stability stable
     */
    readonly queueName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#storage_account_id EventgridSystemTopicEventSubscription#storage_account_id}.
     *
     * @stability stable
     */
    readonly storageAccountId: string;
}
export declare function eventgridSystemTopicEventSubscriptionStorageQueueEndpointToTerraform(struct?: EventgridSystemTopicEventSubscriptionStorageQueueEndpointOutputReference | EventgridSystemTopicEventSubscriptionStorageQueueEndpoint): any;
/**
 * @stability stable
 */
export declare class EventgridSystemTopicEventSubscriptionStorageQueueEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventgridSystemTopicEventSubscriptionStorageQueueEndpoint | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventgridSystemTopicEventSubscriptionStorageQueueEndpoint | undefined);
    private _queueMessageTimeToLiveInSeconds?;
    /**
     * @stability stable
     */
    get queueMessageTimeToLiveInSeconds(): number;
    /**
     * @stability stable
     */
    set queueMessageTimeToLiveInSeconds(value: number);
    /**
     * @stability stable
     */
    resetQueueMessageTimeToLiveInSeconds(): void;
    /**
     * @stability stable
     */
    get queueMessageTimeToLiveInSecondsInput(): number | undefined;
    private _queueName?;
    /**
     * @stability stable
     */
    get queueName(): string;
    /**
     * @stability stable
     */
    set queueName(value: string);
    /**
     * @stability stable
     */
    get queueNameInput(): string | undefined;
    private _storageAccountId?;
    /**
     * @stability stable
     */
    get storageAccountId(): string;
    /**
     * @stability stable
     */
    set storageAccountId(value: string);
    /**
     * @stability stable
     */
    get storageAccountIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface EventgridSystemTopicEventSubscriptionSubjectFilter {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#case_sensitive EventgridSystemTopicEventSubscription#case_sensitive}.
     *
     * @stability stable
     */
    readonly caseSensitive?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#subject_begins_with EventgridSystemTopicEventSubscription#subject_begins_with}.
     *
     * @stability stable
     */
    readonly subjectBeginsWith?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#subject_ends_with EventgridSystemTopicEventSubscription#subject_ends_with}.
     *
     * @stability stable
     */
    readonly subjectEndsWith?: string;
}
export declare function eventgridSystemTopicEventSubscriptionSubjectFilterToTerraform(struct?: EventgridSystemTopicEventSubscriptionSubjectFilterOutputReference | EventgridSystemTopicEventSubscriptionSubjectFilter): any;
/**
 * @stability stable
 */
export declare class EventgridSystemTopicEventSubscriptionSubjectFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventgridSystemTopicEventSubscriptionSubjectFilter | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventgridSystemTopicEventSubscriptionSubjectFilter | undefined);
    private _caseSensitive?;
    /**
     * @stability stable
     */
    get caseSensitive(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set caseSensitive(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCaseSensitive(): void;
    /**
     * @stability stable
     */
    get caseSensitiveInput(): boolean | cdktf.IResolvable | undefined;
    private _subjectBeginsWith?;
    /**
     * @stability stable
     */
    get subjectBeginsWith(): string;
    /**
     * @stability stable
     */
    set subjectBeginsWith(value: string);
    /**
     * @stability stable
     */
    resetSubjectBeginsWith(): void;
    /**
     * @stability stable
     */
    get subjectBeginsWithInput(): string | undefined;
    private _subjectEndsWith?;
    /**
     * @stability stable
     */
    get subjectEndsWith(): string;
    /**
     * @stability stable
     */
    set subjectEndsWith(value: string);
    /**
     * @stability stable
     */
    resetSubjectEndsWith(): void;
    /**
     * @stability stable
     */
    get subjectEndsWithInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface EventgridSystemTopicEventSubscriptionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#create EventgridSystemTopicEventSubscription#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#delete EventgridSystemTopicEventSubscription#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#read EventgridSystemTopicEventSubscription#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#update EventgridSystemTopicEventSubscription#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function eventgridSystemTopicEventSubscriptionTimeoutsToTerraform(struct?: EventgridSystemTopicEventSubscriptionTimeoutsOutputReference | EventgridSystemTopicEventSubscriptionTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class EventgridSystemTopicEventSubscriptionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventgridSystemTopicEventSubscriptionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventgridSystemTopicEventSubscriptionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface EventgridSystemTopicEventSubscriptionWebhookEndpoint {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#active_directory_app_id_or_uri EventgridSystemTopicEventSubscription#active_directory_app_id_or_uri}.
     *
     * @stability stable
     */
    readonly activeDirectoryAppIdOrUri?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#active_directory_tenant_id EventgridSystemTopicEventSubscription#active_directory_tenant_id}.
     *
     * @stability stable
     */
    readonly activeDirectoryTenantId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#max_events_per_batch EventgridSystemTopicEventSubscription#max_events_per_batch}.
     *
     * @stability stable
     */
    readonly maxEventsPerBatch?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#preferred_batch_size_in_kilobytes EventgridSystemTopicEventSubscription#preferred_batch_size_in_kilobytes}.
     *
     * @stability stable
     */
    readonly preferredBatchSizeInKilobytes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription#url EventgridSystemTopicEventSubscription#url}.
     *
     * @stability stable
     */
    readonly url: string;
}
export declare function eventgridSystemTopicEventSubscriptionWebhookEndpointToTerraform(struct?: EventgridSystemTopicEventSubscriptionWebhookEndpointOutputReference | EventgridSystemTopicEventSubscriptionWebhookEndpoint): any;
/**
 * @stability stable
 */
export declare class EventgridSystemTopicEventSubscriptionWebhookEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventgridSystemTopicEventSubscriptionWebhookEndpoint | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventgridSystemTopicEventSubscriptionWebhookEndpoint | undefined);
    private _activeDirectoryAppIdOrUri?;
    /**
     * @stability stable
     */
    get activeDirectoryAppIdOrUri(): string;
    /**
     * @stability stable
     */
    set activeDirectoryAppIdOrUri(value: string);
    /**
     * @stability stable
     */
    resetActiveDirectoryAppIdOrUri(): void;
    /**
     * @stability stable
     */
    get activeDirectoryAppIdOrUriInput(): string | undefined;
    private _activeDirectoryTenantId?;
    /**
     * @stability stable
     */
    get activeDirectoryTenantId(): string;
    /**
     * @stability stable
     */
    set activeDirectoryTenantId(value: string);
    /**
     * @stability stable
     */
    resetActiveDirectoryTenantId(): void;
    /**
     * @stability stable
     */
    get activeDirectoryTenantIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get baseUrl(): string;
    private _maxEventsPerBatch?;
    /**
     * @stability stable
     */
    get maxEventsPerBatch(): number;
    /**
     * @stability stable
     */
    set maxEventsPerBatch(value: number);
    /**
     * @stability stable
     */
    resetMaxEventsPerBatch(): void;
    /**
     * @stability stable
     */
    get maxEventsPerBatchInput(): number | undefined;
    private _preferredBatchSizeInKilobytes?;
    /**
     * @stability stable
     */
    get preferredBatchSizeInKilobytes(): number;
    /**
     * @stability stable
     */
    set preferredBatchSizeInKilobytes(value: number);
    /**
     * @stability stable
     */
    resetPreferredBatchSizeInKilobytes(): void;
    /**
     * @stability stable
     */
    get preferredBatchSizeInKilobytesInput(): number | undefined;
    private _url?;
    /**
     * @stability stable
     */
    get url(): string;
    /**
     * @stability stable
     */
    set url(value: string);
    /**
     * @stability stable
     */
    get urlInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription azurerm_eventgrid_system_topic_event_subscription}.
 *
 * @stability stable
 */
export declare class EventgridSystemTopicEventSubscription extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_system_topic_event_subscription azurerm_eventgrid_system_topic_event_subscription} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: EventgridSystemTopicEventSubscriptionConfig);
    private _advancedFilteringOnArraysEnabled?;
    /**
     * @stability stable
     */
    get advancedFilteringOnArraysEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set advancedFilteringOnArraysEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAdvancedFilteringOnArraysEnabled(): void;
    /**
     * @stability stable
     */
    get advancedFilteringOnArraysEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _eventDeliverySchema?;
    /**
     * @stability stable
     */
    get eventDeliverySchema(): string;
    /**
     * @stability stable
     */
    set eventDeliverySchema(value: string);
    /**
     * @stability stable
     */
    resetEventDeliverySchema(): void;
    /**
     * @stability stable
     */
    get eventDeliverySchemaInput(): string | undefined;
    private _eventhubEndpointId?;
    /**
     * @stability stable
     */
    get eventhubEndpointId(): string;
    /**
     * @stability stable
     */
    set eventhubEndpointId(value: string);
    /**
     * @stability stable
     */
    resetEventhubEndpointId(): void;
    /**
     * @stability stable
     */
    get eventhubEndpointIdInput(): string | undefined;
    private _expirationTimeUtc?;
    /**
     * @stability stable
     */
    get expirationTimeUtc(): string;
    /**
     * @stability stable
     */
    set expirationTimeUtc(value: string);
    /**
     * @stability stable
     */
    resetExpirationTimeUtc(): void;
    /**
     * @stability stable
     */
    get expirationTimeUtcInput(): string | undefined;
    private _hybridConnectionEndpointId?;
    /**
     * @stability stable
     */
    get hybridConnectionEndpointId(): string;
    /**
     * @stability stable
     */
    set hybridConnectionEndpointId(value: string);
    /**
     * @stability stable
     */
    resetHybridConnectionEndpointId(): void;
    /**
     * @stability stable
     */
    get hybridConnectionEndpointIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _includedEventTypes?;
    /**
     * @stability stable
     */
    get includedEventTypes(): string[];
    /**
     * @stability stable
     */
    set includedEventTypes(value: string[]);
    /**
     * @stability stable
     */
    resetIncludedEventTypes(): void;
    /**
     * @stability stable
     */
    get includedEventTypesInput(): string[] | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): string[];
    /**
     * @stability stable
     */
    set labels(value: string[]);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): string[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _serviceBusQueueEndpointId?;
    /**
     * @stability stable
     */
    get serviceBusQueueEndpointId(): string;
    /**
     * @stability stable
     */
    set serviceBusQueueEndpointId(value: string);
    /**
     * @stability stable
     */
    resetServiceBusQueueEndpointId(): void;
    /**
     * @stability stable
     */
    get serviceBusQueueEndpointIdInput(): string | undefined;
    private _serviceBusTopicEndpointId?;
    /**
     * @stability stable
     */
    get serviceBusTopicEndpointId(): string;
    /**
     * @stability stable
     */
    set serviceBusTopicEndpointId(value: string);
    /**
     * @stability stable
     */
    resetServiceBusTopicEndpointId(): void;
    /**
     * @stability stable
     */
    get serviceBusTopicEndpointIdInput(): string | undefined;
    private _systemTopic?;
    /**
     * @stability stable
     */
    get systemTopic(): string;
    /**
     * @stability stable
     */
    set systemTopic(value: string);
    /**
     * @stability stable
     */
    get systemTopicInput(): string | undefined;
    private _advancedFilter;
    /**
     * @stability stable
     */
    get advancedFilter(): EventgridSystemTopicEventSubscriptionAdvancedFilterOutputReference;
    /**
     * @stability stable
     */
    putAdvancedFilter(value: EventgridSystemTopicEventSubscriptionAdvancedFilter): void;
    /**
     * @stability stable
     */
    resetAdvancedFilter(): void;
    /**
     * @stability stable
     */
    get advancedFilterInput(): EventgridSystemTopicEventSubscriptionAdvancedFilter | undefined;
    private _azureFunctionEndpoint;
    /**
     * @stability stable
     */
    get azureFunctionEndpoint(): EventgridSystemTopicEventSubscriptionAzureFunctionEndpointOutputReference;
    /**
     * @stability stable
     */
    putAzureFunctionEndpoint(value: EventgridSystemTopicEventSubscriptionAzureFunctionEndpoint): void;
    /**
     * @stability stable
     */
    resetAzureFunctionEndpoint(): void;
    /**
     * @stability stable
     */
    get azureFunctionEndpointInput(): EventgridSystemTopicEventSubscriptionAzureFunctionEndpoint | undefined;
    private _deadLetterIdentity;
    /**
     * @stability stable
     */
    get deadLetterIdentity(): EventgridSystemTopicEventSubscriptionDeadLetterIdentityOutputReference;
    /**
     * @stability stable
     */
    putDeadLetterIdentity(value: EventgridSystemTopicEventSubscriptionDeadLetterIdentity): void;
    /**
     * @stability stable
     */
    resetDeadLetterIdentity(): void;
    /**
     * @stability stable
     */
    get deadLetterIdentityInput(): EventgridSystemTopicEventSubscriptionDeadLetterIdentity | undefined;
    private _deliveryIdentity;
    /**
     * @stability stable
     */
    get deliveryIdentity(): EventgridSystemTopicEventSubscriptionDeliveryIdentityOutputReference;
    /**
     * @stability stable
     */
    putDeliveryIdentity(value: EventgridSystemTopicEventSubscriptionDeliveryIdentity): void;
    /**
     * @stability stable
     */
    resetDeliveryIdentity(): void;
    /**
     * @stability stable
     */
    get deliveryIdentityInput(): EventgridSystemTopicEventSubscriptionDeliveryIdentity | undefined;
    private _retryPolicy;
    /**
     * @stability stable
     */
    get retryPolicy(): EventgridSystemTopicEventSubscriptionRetryPolicyOutputReference;
    /**
     * @stability stable
     */
    putRetryPolicy(value: EventgridSystemTopicEventSubscriptionRetryPolicy): void;
    /**
     * @stability stable
     */
    resetRetryPolicy(): void;
    /**
     * @stability stable
     */
    get retryPolicyInput(): EventgridSystemTopicEventSubscriptionRetryPolicy | undefined;
    private _storageBlobDeadLetterDestination;
    /**
     * @stability stable
     */
    get storageBlobDeadLetterDestination(): EventgridSystemTopicEventSubscriptionStorageBlobDeadLetterDestinationOutputReference;
    /**
     * @stability stable
     */
    putStorageBlobDeadLetterDestination(value: EventgridSystemTopicEventSubscriptionStorageBlobDeadLetterDestination): void;
    /**
     * @stability stable
     */
    resetStorageBlobDeadLetterDestination(): void;
    /**
     * @stability stable
     */
    get storageBlobDeadLetterDestinationInput(): EventgridSystemTopicEventSubscriptionStorageBlobDeadLetterDestination | undefined;
    private _storageQueueEndpoint;
    /**
     * @stability stable
     */
    get storageQueueEndpoint(): EventgridSystemTopicEventSubscriptionStorageQueueEndpointOutputReference;
    /**
     * @stability stable
     */
    putStorageQueueEndpoint(value: EventgridSystemTopicEventSubscriptionStorageQueueEndpoint): void;
    /**
     * @stability stable
     */
    resetStorageQueueEndpoint(): void;
    /**
     * @stability stable
     */
    get storageQueueEndpointInput(): EventgridSystemTopicEventSubscriptionStorageQueueEndpoint | undefined;
    private _subjectFilter;
    /**
     * @stability stable
     */
    get subjectFilter(): EventgridSystemTopicEventSubscriptionSubjectFilterOutputReference;
    /**
     * @stability stable
     */
    putSubjectFilter(value: EventgridSystemTopicEventSubscriptionSubjectFilter): void;
    /**
     * @stability stable
     */
    resetSubjectFilter(): void;
    /**
     * @stability stable
     */
    get subjectFilterInput(): EventgridSystemTopicEventSubscriptionSubjectFilter | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): EventgridSystemTopicEventSubscriptionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: EventgridSystemTopicEventSubscriptionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): EventgridSystemTopicEventSubscriptionTimeouts | undefined;
    private _webhookEndpoint;
    /**
     * @stability stable
     */
    get webhookEndpoint(): EventgridSystemTopicEventSubscriptionWebhookEndpointOutputReference;
    /**
     * @stability stable
     */
    putWebhookEndpoint(value: EventgridSystemTopicEventSubscriptionWebhookEndpoint): void;
    /**
     * @stability stable
     */
    resetWebhookEndpoint(): void;
    /**
     * @stability stable
     */
    get webhookEndpointInput(): EventgridSystemTopicEventSubscriptionWebhookEndpoint | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
