import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface HdinsightMlServicesClusterConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#cluster_version HdinsightMlServicesCluster#cluster_version}.
     *
     * @stability stable
     */
    readonly clusterVersion: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#location HdinsightMlServicesCluster#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#name HdinsightMlServicesCluster#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#resource_group_name HdinsightMlServicesCluster#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#rstudio HdinsightMlServicesCluster#rstudio}.
     *
     * @stability stable
     */
    readonly rstudio: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#tags HdinsightMlServicesCluster#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#tier HdinsightMlServicesCluster#tier}.
     *
     * @stability stable
     */
    readonly tier: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#tls_min_version HdinsightMlServicesCluster#tls_min_version}.
     *
     * @stability stable
     */
    readonly tlsMinVersion?: string;
    /**
     * gateway block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#gateway HdinsightMlServicesCluster#gateway}
     *
     * @stability stable
     */
    readonly gateway: HdinsightMlServicesClusterGateway;
    /**
     * roles block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#roles HdinsightMlServicesCluster#roles}
     *
     * @stability stable
     */
    readonly roles: HdinsightMlServicesClusterRoles;
    /**
     * storage_account block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#storage_account HdinsightMlServicesCluster#storage_account}
     *
     * @stability stable
     */
    readonly storageAccount?: HdinsightMlServicesClusterStorageAccount[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#timeouts HdinsightMlServicesCluster#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: HdinsightMlServicesClusterTimeouts;
}
/**
 * @stability stable
 */
export interface HdinsightMlServicesClusterGateway {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#enabled HdinsightMlServicesCluster#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#password HdinsightMlServicesCluster#password}.
     *
     * @stability stable
     */
    readonly password: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#username HdinsightMlServicesCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
}
export declare function hdinsightMlServicesClusterGatewayToTerraform(struct?: HdinsightMlServicesClusterGatewayOutputReference | HdinsightMlServicesClusterGateway): any;
/**
 * @stability stable
 */
export declare class HdinsightMlServicesClusterGatewayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightMlServicesClusterGateway | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightMlServicesClusterGateway | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightMlServicesClusterRolesEdgeNode {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#password HdinsightMlServicesCluster#password}.
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#ssh_keys HdinsightMlServicesCluster#ssh_keys}.
     *
     * @stability stable
     */
    readonly sshKeys?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#subnet_id HdinsightMlServicesCluster#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#username HdinsightMlServicesCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#virtual_network_id HdinsightMlServicesCluster#virtual_network_id}.
     *
     * @stability stable
     */
    readonly virtualNetworkId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#vm_size HdinsightMlServicesCluster#vm_size}.
     *
     * @stability stable
     */
    readonly vmSize: string;
}
export declare function hdinsightMlServicesClusterRolesEdgeNodeToTerraform(struct?: HdinsightMlServicesClusterRolesEdgeNodeOutputReference | HdinsightMlServicesClusterRolesEdgeNode): any;
/**
 * @stability stable
 */
export declare class HdinsightMlServicesClusterRolesEdgeNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightMlServicesClusterRolesEdgeNode | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightMlServicesClusterRolesEdgeNode | undefined);
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _sshKeys?;
    /**
     * @stability stable
     */
    get sshKeys(): string[];
    /**
     * @stability stable
     */
    set sshKeys(value: string[]);
    /**
     * @stability stable
     */
    resetSshKeys(): void;
    /**
     * @stability stable
     */
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    resetSubnetId(): void;
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    /**
     * @stability stable
     */
    get virtualNetworkId(): string;
    /**
     * @stability stable
     */
    set virtualNetworkId(value: string);
    /**
     * @stability stable
     */
    resetVirtualNetworkId(): void;
    /**
     * @stability stable
     */
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    /**
     * @stability stable
     */
    get vmSize(): string;
    /**
     * @stability stable
     */
    set vmSize(value: string);
    /**
     * @stability stable
     */
    get vmSizeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightMlServicesClusterRolesHeadNode {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#password HdinsightMlServicesCluster#password}.
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#ssh_keys HdinsightMlServicesCluster#ssh_keys}.
     *
     * @stability stable
     */
    readonly sshKeys?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#subnet_id HdinsightMlServicesCluster#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#username HdinsightMlServicesCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#virtual_network_id HdinsightMlServicesCluster#virtual_network_id}.
     *
     * @stability stable
     */
    readonly virtualNetworkId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#vm_size HdinsightMlServicesCluster#vm_size}.
     *
     * @stability stable
     */
    readonly vmSize: string;
}
export declare function hdinsightMlServicesClusterRolesHeadNodeToTerraform(struct?: HdinsightMlServicesClusterRolesHeadNodeOutputReference | HdinsightMlServicesClusterRolesHeadNode): any;
/**
 * @stability stable
 */
export declare class HdinsightMlServicesClusterRolesHeadNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightMlServicesClusterRolesHeadNode | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightMlServicesClusterRolesHeadNode | undefined);
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _sshKeys?;
    /**
     * @stability stable
     */
    get sshKeys(): string[];
    /**
     * @stability stable
     */
    set sshKeys(value: string[]);
    /**
     * @stability stable
     */
    resetSshKeys(): void;
    /**
     * @stability stable
     */
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    resetSubnetId(): void;
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    /**
     * @stability stable
     */
    get virtualNetworkId(): string;
    /**
     * @stability stable
     */
    set virtualNetworkId(value: string);
    /**
     * @stability stable
     */
    resetVirtualNetworkId(): void;
    /**
     * @stability stable
     */
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    /**
     * @stability stable
     */
    get vmSize(): string;
    /**
     * @stability stable
     */
    set vmSize(value: string);
    /**
     * @stability stable
     */
    get vmSizeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightMlServicesClusterRolesWorkerNode {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#min_instance_count HdinsightMlServicesCluster#min_instance_count}.
     *
     * @stability stable
     */
    readonly minInstanceCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#password HdinsightMlServicesCluster#password}.
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#ssh_keys HdinsightMlServicesCluster#ssh_keys}.
     *
     * @stability stable
     */
    readonly sshKeys?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#subnet_id HdinsightMlServicesCluster#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#target_instance_count HdinsightMlServicesCluster#target_instance_count}.
     *
     * @stability stable
     */
    readonly targetInstanceCount: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#username HdinsightMlServicesCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#virtual_network_id HdinsightMlServicesCluster#virtual_network_id}.
     *
     * @stability stable
     */
    readonly virtualNetworkId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#vm_size HdinsightMlServicesCluster#vm_size}.
     *
     * @stability stable
     */
    readonly vmSize: string;
}
export declare function hdinsightMlServicesClusterRolesWorkerNodeToTerraform(struct?: HdinsightMlServicesClusterRolesWorkerNodeOutputReference | HdinsightMlServicesClusterRolesWorkerNode): any;
/**
 * @stability stable
 */
export declare class HdinsightMlServicesClusterRolesWorkerNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightMlServicesClusterRolesWorkerNode | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightMlServicesClusterRolesWorkerNode | undefined);
    private _minInstanceCount?;
    /**
     * @stability stable
     */
    get minInstanceCount(): number;
    /**
     * @stability stable
     */
    set minInstanceCount(value: number);
    /**
     * @stability stable
     */
    resetMinInstanceCount(): void;
    /**
     * @stability stable
     */
    get minInstanceCountInput(): number | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _sshKeys?;
    /**
     * @stability stable
     */
    get sshKeys(): string[];
    /**
     * @stability stable
     */
    set sshKeys(value: string[]);
    /**
     * @stability stable
     */
    resetSshKeys(): void;
    /**
     * @stability stable
     */
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    resetSubnetId(): void;
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _targetInstanceCount?;
    /**
     * @stability stable
     */
    get targetInstanceCount(): number;
    /**
     * @stability stable
     */
    set targetInstanceCount(value: number);
    /**
     * @stability stable
     */
    get targetInstanceCountInput(): number | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    /**
     * @stability stable
     */
    get virtualNetworkId(): string;
    /**
     * @stability stable
     */
    set virtualNetworkId(value: string);
    /**
     * @stability stable
     */
    resetVirtualNetworkId(): void;
    /**
     * @stability stable
     */
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    /**
     * @stability stable
     */
    get vmSize(): string;
    /**
     * @stability stable
     */
    set vmSize(value: string);
    /**
     * @stability stable
     */
    get vmSizeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightMlServicesClusterRolesZookeeperNode {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#password HdinsightMlServicesCluster#password}.
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#ssh_keys HdinsightMlServicesCluster#ssh_keys}.
     *
     * @stability stable
     */
    readonly sshKeys?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#subnet_id HdinsightMlServicesCluster#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#username HdinsightMlServicesCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#virtual_network_id HdinsightMlServicesCluster#virtual_network_id}.
     *
     * @stability stable
     */
    readonly virtualNetworkId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#vm_size HdinsightMlServicesCluster#vm_size}.
     *
     * @stability stable
     */
    readonly vmSize: string;
}
export declare function hdinsightMlServicesClusterRolesZookeeperNodeToTerraform(struct?: HdinsightMlServicesClusterRolesZookeeperNodeOutputReference | HdinsightMlServicesClusterRolesZookeeperNode): any;
/**
 * @stability stable
 */
export declare class HdinsightMlServicesClusterRolesZookeeperNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightMlServicesClusterRolesZookeeperNode | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightMlServicesClusterRolesZookeeperNode | undefined);
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _sshKeys?;
    /**
     * @stability stable
     */
    get sshKeys(): string[];
    /**
     * @stability stable
     */
    set sshKeys(value: string[]);
    /**
     * @stability stable
     */
    resetSshKeys(): void;
    /**
     * @stability stable
     */
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    resetSubnetId(): void;
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    /**
     * @stability stable
     */
    get virtualNetworkId(): string;
    /**
     * @stability stable
     */
    set virtualNetworkId(value: string);
    /**
     * @stability stable
     */
    resetVirtualNetworkId(): void;
    /**
     * @stability stable
     */
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    /**
     * @stability stable
     */
    get vmSize(): string;
    /**
     * @stability stable
     */
    set vmSize(value: string);
    /**
     * @stability stable
     */
    get vmSizeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightMlServicesClusterRoles {
    /**
     * edge_node block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#edge_node HdinsightMlServicesCluster#edge_node}
     *
     * @stability stable
     */
    readonly edgeNode: HdinsightMlServicesClusterRolesEdgeNode;
    /**
     * head_node block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#head_node HdinsightMlServicesCluster#head_node}
     *
     * @stability stable
     */
    readonly headNode: HdinsightMlServicesClusterRolesHeadNode;
    /**
     * worker_node block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#worker_node HdinsightMlServicesCluster#worker_node}
     *
     * @stability stable
     */
    readonly workerNode: HdinsightMlServicesClusterRolesWorkerNode;
    /**
     * zookeeper_node block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#zookeeper_node HdinsightMlServicesCluster#zookeeper_node}
     *
     * @stability stable
     */
    readonly zookeeperNode: HdinsightMlServicesClusterRolesZookeeperNode;
}
export declare function hdinsightMlServicesClusterRolesToTerraform(struct?: HdinsightMlServicesClusterRolesOutputReference | HdinsightMlServicesClusterRoles): any;
/**
 * @stability stable
 */
export declare class HdinsightMlServicesClusterRolesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightMlServicesClusterRoles | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightMlServicesClusterRoles | undefined);
    private _edgeNode;
    /**
     * @stability stable
     */
    get edgeNode(): HdinsightMlServicesClusterRolesEdgeNodeOutputReference;
    /**
     * @stability stable
     */
    putEdgeNode(value: HdinsightMlServicesClusterRolesEdgeNode): void;
    /**
     * @stability stable
     */
    get edgeNodeInput(): HdinsightMlServicesClusterRolesEdgeNode | undefined;
    private _headNode;
    /**
     * @stability stable
     */
    get headNode(): HdinsightMlServicesClusterRolesHeadNodeOutputReference;
    /**
     * @stability stable
     */
    putHeadNode(value: HdinsightMlServicesClusterRolesHeadNode): void;
    /**
     * @stability stable
     */
    get headNodeInput(): HdinsightMlServicesClusterRolesHeadNode | undefined;
    private _workerNode;
    /**
     * @stability stable
     */
    get workerNode(): HdinsightMlServicesClusterRolesWorkerNodeOutputReference;
    /**
     * @stability stable
     */
    putWorkerNode(value: HdinsightMlServicesClusterRolesWorkerNode): void;
    /**
     * @stability stable
     */
    get workerNodeInput(): HdinsightMlServicesClusterRolesWorkerNode | undefined;
    private _zookeeperNode;
    /**
     * @stability stable
     */
    get zookeeperNode(): HdinsightMlServicesClusterRolesZookeeperNodeOutputReference;
    /**
     * @stability stable
     */
    putZookeeperNode(value: HdinsightMlServicesClusterRolesZookeeperNode): void;
    /**
     * @stability stable
     */
    get zookeeperNodeInput(): HdinsightMlServicesClusterRolesZookeeperNode | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightMlServicesClusterStorageAccount {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#is_default HdinsightMlServicesCluster#is_default}.
     *
     * @stability stable
     */
    readonly isDefault: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#storage_account_key HdinsightMlServicesCluster#storage_account_key}.
     *
     * @stability stable
     */
    readonly storageAccountKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#storage_container_id HdinsightMlServicesCluster#storage_container_id}.
     *
     * @stability stable
     */
    readonly storageContainerId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#storage_resource_id HdinsightMlServicesCluster#storage_resource_id}.
     *
     * @stability stable
     */
    readonly storageResourceId?: string;
}
export declare function hdinsightMlServicesClusterStorageAccountToTerraform(struct?: HdinsightMlServicesClusterStorageAccount | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface HdinsightMlServicesClusterTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#create HdinsightMlServicesCluster#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#delete HdinsightMlServicesCluster#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#read HdinsightMlServicesCluster#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster#update HdinsightMlServicesCluster#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function hdinsightMlServicesClusterTimeoutsToTerraform(struct?: HdinsightMlServicesClusterTimeoutsOutputReference | HdinsightMlServicesClusterTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class HdinsightMlServicesClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightMlServicesClusterTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightMlServicesClusterTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster azurerm_hdinsight_ml_services_cluster}.
 *
 * @stability stable
 */
export declare class HdinsightMlServicesCluster extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_ml_services_cluster azurerm_hdinsight_ml_services_cluster} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: HdinsightMlServicesClusterConfig);
    private _clusterVersion?;
    /**
     * @stability stable
     */
    get clusterVersion(): string;
    /**
     * @stability stable
     */
    set clusterVersion(value: string);
    /**
     * @stability stable
     */
    get clusterVersionInput(): string | undefined;
    /**
     * @stability stable
     */
    get edgeSshEndpoint(): string;
    /**
     * @stability stable
     */
    get httpsEndpoint(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _rstudio?;
    /**
     * @stability stable
     */
    get rstudio(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set rstudio(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get rstudioInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get sshEndpoint(): string;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tier?;
    /**
     * @stability stable
     */
    get tier(): string;
    /**
     * @stability stable
     */
    set tier(value: string);
    /**
     * @stability stable
     */
    get tierInput(): string | undefined;
    private _tlsMinVersion?;
    /**
     * @stability stable
     */
    get tlsMinVersion(): string;
    /**
     * @stability stable
     */
    set tlsMinVersion(value: string);
    /**
     * @stability stable
     */
    resetTlsMinVersion(): void;
    /**
     * @stability stable
     */
    get tlsMinVersionInput(): string | undefined;
    private _gateway;
    /**
     * @stability stable
     */
    get gateway(): HdinsightMlServicesClusterGatewayOutputReference;
    /**
     * @stability stable
     */
    putGateway(value: HdinsightMlServicesClusterGateway): void;
    /**
     * @stability stable
     */
    get gatewayInput(): HdinsightMlServicesClusterGateway | undefined;
    private _roles;
    /**
     * @stability stable
     */
    get roles(): HdinsightMlServicesClusterRolesOutputReference;
    /**
     * @stability stable
     */
    putRoles(value: HdinsightMlServicesClusterRoles): void;
    /**
     * @stability stable
     */
    get rolesInput(): HdinsightMlServicesClusterRoles | undefined;
    private _storageAccount?;
    /**
     * @stability stable
     */
    get storageAccount(): HdinsightMlServicesClusterStorageAccount[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set storageAccount(value: HdinsightMlServicesClusterStorageAccount[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetStorageAccount(): void;
    /**
     * @stability stable
     */
    get storageAccountInput(): cdktf.IResolvable | HdinsightMlServicesClusterStorageAccount[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): HdinsightMlServicesClusterTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: HdinsightMlServicesClusterTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): HdinsightMlServicesClusterTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
