import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IotSecuritySolutionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#disabled_data_sources IotSecuritySolution#disabled_data_sources}.
     *
     * @stability stable
     */
    readonly disabledDataSources?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#display_name IotSecuritySolution#display_name}.
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#enabled IotSecuritySolution#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#events_to_export IotSecuritySolution#events_to_export}.
     *
     * @stability stable
     */
    readonly eventsToExport?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#iothub_ids IotSecuritySolution#iothub_ids}.
     *
     * @stability stable
     */
    readonly iothubIds: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#location IotSecuritySolution#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#log_analytics_workspace_id IotSecuritySolution#log_analytics_workspace_id}.
     *
     * @stability stable
     */
    readonly logAnalyticsWorkspaceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#log_unmasked_ips_enabled IotSecuritySolution#log_unmasked_ips_enabled}.
     *
     * @stability stable
     */
    readonly logUnmaskedIpsEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#name IotSecuritySolution#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#query_for_resources IotSecuritySolution#query_for_resources}.
     *
     * @stability stable
     */
    readonly queryForResources?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#query_subscription_ids IotSecuritySolution#query_subscription_ids}.
     *
     * @stability stable
     */
    readonly querySubscriptionIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#resource_group_name IotSecuritySolution#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#tags IotSecuritySolution#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * additional_workspace block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#additional_workspace IotSecuritySolution#additional_workspace}
     *
     * @stability stable
     */
    readonly additionalWorkspace?: IotSecuritySolutionAdditionalWorkspace[] | cdktf.IResolvable;
    /**
     * recommendations_enabled block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#recommendations_enabled IotSecuritySolution#recommendations_enabled}
     *
     * @stability stable
     */
    readonly recommendationsEnabled?: IotSecuritySolutionRecommendationsEnabled;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#timeouts IotSecuritySolution#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: IotSecuritySolutionTimeouts;
}
/**
 * @stability stable
 */
export interface IotSecuritySolutionAdditionalWorkspace {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#data_types IotSecuritySolution#data_types}.
     *
     * @stability stable
     */
    readonly dataTypes: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#workspace_id IotSecuritySolution#workspace_id}.
     *
     * @stability stable
     */
    readonly workspaceId: string;
}
export declare function iotSecuritySolutionAdditionalWorkspaceToTerraform(struct?: IotSecuritySolutionAdditionalWorkspace | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface IotSecuritySolutionRecommendationsEnabled {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#acr_authentication IotSecuritySolution#acr_authentication}.
     *
     * @stability stable
     */
    readonly acrAuthentication?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#agent_send_unutilized_msg IotSecuritySolution#agent_send_unutilized_msg}.
     *
     * @stability stable
     */
    readonly agentSendUnutilizedMsg?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#baseline IotSecuritySolution#baseline}.
     *
     * @stability stable
     */
    readonly baseline?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#edge_hub_mem_optimize IotSecuritySolution#edge_hub_mem_optimize}.
     *
     * @stability stable
     */
    readonly edgeHubMemOptimize?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#edge_logging_option IotSecuritySolution#edge_logging_option}.
     *
     * @stability stable
     */
    readonly edgeLoggingOption?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#inconsistent_module_settings IotSecuritySolution#inconsistent_module_settings}.
     *
     * @stability stable
     */
    readonly inconsistentModuleSettings?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#install_agent IotSecuritySolution#install_agent}.
     *
     * @stability stable
     */
    readonly installAgent?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#ip_filter_deny_all IotSecuritySolution#ip_filter_deny_all}.
     *
     * @stability stable
     */
    readonly ipFilterDenyAll?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#ip_filter_permissive_rule IotSecuritySolution#ip_filter_permissive_rule}.
     *
     * @stability stable
     */
    readonly ipFilterPermissiveRule?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#open_ports IotSecuritySolution#open_ports}.
     *
     * @stability stable
     */
    readonly openPorts?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#permissive_firewall_policy IotSecuritySolution#permissive_firewall_policy}.
     *
     * @stability stable
     */
    readonly permissiveFirewallPolicy?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#permissive_input_firewall_rules IotSecuritySolution#permissive_input_firewall_rules}.
     *
     * @stability stable
     */
    readonly permissiveInputFirewallRules?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#permissive_output_firewall_rules IotSecuritySolution#permissive_output_firewall_rules}.
     *
     * @stability stable
     */
    readonly permissiveOutputFirewallRules?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#privileged_docker_options IotSecuritySolution#privileged_docker_options}.
     *
     * @stability stable
     */
    readonly privilegedDockerOptions?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#shared_credentials IotSecuritySolution#shared_credentials}.
     *
     * @stability stable
     */
    readonly sharedCredentials?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#vulnerable_tls_cipher_suite IotSecuritySolution#vulnerable_tls_cipher_suite}.
     *
     * @stability stable
     */
    readonly vulnerableTlsCipherSuite?: boolean | cdktf.IResolvable;
}
export declare function iotSecuritySolutionRecommendationsEnabledToTerraform(struct?: IotSecuritySolutionRecommendationsEnabledOutputReference | IotSecuritySolutionRecommendationsEnabled): any;
/**
 * @stability stable
 */
export declare class IotSecuritySolutionRecommendationsEnabledOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): IotSecuritySolutionRecommendationsEnabled | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: IotSecuritySolutionRecommendationsEnabled | undefined);
    private _acrAuthentication?;
    /**
     * @stability stable
     */
    get acrAuthentication(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set acrAuthentication(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAcrAuthentication(): void;
    /**
     * @stability stable
     */
    get acrAuthenticationInput(): boolean | cdktf.IResolvable | undefined;
    private _agentSendUnutilizedMsg?;
    /**
     * @stability stable
     */
    get agentSendUnutilizedMsg(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set agentSendUnutilizedMsg(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAgentSendUnutilizedMsg(): void;
    /**
     * @stability stable
     */
    get agentSendUnutilizedMsgInput(): boolean | cdktf.IResolvable | undefined;
    private _baseline?;
    /**
     * @stability stable
     */
    get baseline(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set baseline(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetBaseline(): void;
    /**
     * @stability stable
     */
    get baselineInput(): boolean | cdktf.IResolvable | undefined;
    private _edgeHubMemOptimize?;
    /**
     * @stability stable
     */
    get edgeHubMemOptimize(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set edgeHubMemOptimize(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEdgeHubMemOptimize(): void;
    /**
     * @stability stable
     */
    get edgeHubMemOptimizeInput(): boolean | cdktf.IResolvable | undefined;
    private _edgeLoggingOption?;
    /**
     * @stability stable
     */
    get edgeLoggingOption(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set edgeLoggingOption(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEdgeLoggingOption(): void;
    /**
     * @stability stable
     */
    get edgeLoggingOptionInput(): boolean | cdktf.IResolvable | undefined;
    private _inconsistentModuleSettings?;
    /**
     * @stability stable
     */
    get inconsistentModuleSettings(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set inconsistentModuleSettings(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetInconsistentModuleSettings(): void;
    /**
     * @stability stable
     */
    get inconsistentModuleSettingsInput(): boolean | cdktf.IResolvable | undefined;
    private _installAgent?;
    /**
     * @stability stable
     */
    get installAgent(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set installAgent(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetInstallAgent(): void;
    /**
     * @stability stable
     */
    get installAgentInput(): boolean | cdktf.IResolvable | undefined;
    private _ipFilterDenyAll?;
    /**
     * @stability stable
     */
    get ipFilterDenyAll(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set ipFilterDenyAll(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIpFilterDenyAll(): void;
    /**
     * @stability stable
     */
    get ipFilterDenyAllInput(): boolean | cdktf.IResolvable | undefined;
    private _ipFilterPermissiveRule?;
    /**
     * @stability stable
     */
    get ipFilterPermissiveRule(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set ipFilterPermissiveRule(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIpFilterPermissiveRule(): void;
    /**
     * @stability stable
     */
    get ipFilterPermissiveRuleInput(): boolean | cdktf.IResolvable | undefined;
    private _openPorts?;
    /**
     * @stability stable
     */
    get openPorts(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set openPorts(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOpenPorts(): void;
    /**
     * @stability stable
     */
    get openPortsInput(): boolean | cdktf.IResolvable | undefined;
    private _permissiveFirewallPolicy?;
    /**
     * @stability stable
     */
    get permissiveFirewallPolicy(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set permissiveFirewallPolicy(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPermissiveFirewallPolicy(): void;
    /**
     * @stability stable
     */
    get permissiveFirewallPolicyInput(): boolean | cdktf.IResolvable | undefined;
    private _permissiveInputFirewallRules?;
    /**
     * @stability stable
     */
    get permissiveInputFirewallRules(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set permissiveInputFirewallRules(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPermissiveInputFirewallRules(): void;
    /**
     * @stability stable
     */
    get permissiveInputFirewallRulesInput(): boolean | cdktf.IResolvable | undefined;
    private _permissiveOutputFirewallRules?;
    /**
     * @stability stable
     */
    get permissiveOutputFirewallRules(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set permissiveOutputFirewallRules(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPermissiveOutputFirewallRules(): void;
    /**
     * @stability stable
     */
    get permissiveOutputFirewallRulesInput(): boolean | cdktf.IResolvable | undefined;
    private _privilegedDockerOptions?;
    /**
     * @stability stable
     */
    get privilegedDockerOptions(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set privilegedDockerOptions(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPrivilegedDockerOptions(): void;
    /**
     * @stability stable
     */
    get privilegedDockerOptionsInput(): boolean | cdktf.IResolvable | undefined;
    private _sharedCredentials?;
    /**
     * @stability stable
     */
    get sharedCredentials(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set sharedCredentials(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSharedCredentials(): void;
    /**
     * @stability stable
     */
    get sharedCredentialsInput(): boolean | cdktf.IResolvable | undefined;
    private _vulnerableTlsCipherSuite?;
    /**
     * @stability stable
     */
    get vulnerableTlsCipherSuite(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set vulnerableTlsCipherSuite(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetVulnerableTlsCipherSuite(): void;
    /**
     * @stability stable
     */
    get vulnerableTlsCipherSuiteInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface IotSecuritySolutionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#create IotSecuritySolution#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#delete IotSecuritySolution#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#read IotSecuritySolution#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#update IotSecuritySolution#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function iotSecuritySolutionTimeoutsToTerraform(struct?: IotSecuritySolutionTimeoutsOutputReference | IotSecuritySolutionTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class IotSecuritySolutionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): IotSecuritySolutionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: IotSecuritySolutionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution azurerm_iot_security_solution}.
 *
 * @stability stable
 */
export declare class IotSecuritySolution extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution azurerm_iot_security_solution} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IotSecuritySolutionConfig);
    private _disabledDataSources?;
    /**
     * @stability stable
     */
    get disabledDataSources(): string[];
    /**
     * @stability stable
     */
    set disabledDataSources(value: string[]);
    /**
     * @stability stable
     */
    resetDisabledDataSources(): void;
    /**
     * @stability stable
     */
    get disabledDataSourcesInput(): string[] | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _eventsToExport?;
    /**
     * @stability stable
     */
    get eventsToExport(): string[];
    /**
     * @stability stable
     */
    set eventsToExport(value: string[]);
    /**
     * @stability stable
     */
    resetEventsToExport(): void;
    /**
     * @stability stable
     */
    get eventsToExportInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _iothubIds?;
    /**
     * @stability stable
     */
    get iothubIds(): string[];
    /**
     * @stability stable
     */
    set iothubIds(value: string[]);
    /**
     * @stability stable
     */
    get iothubIdsInput(): string[] | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _logAnalyticsWorkspaceId?;
    /**
     * @stability stable
     */
    get logAnalyticsWorkspaceId(): string;
    /**
     * @stability stable
     */
    set logAnalyticsWorkspaceId(value: string);
    /**
     * @stability stable
     */
    resetLogAnalyticsWorkspaceId(): void;
    /**
     * @stability stable
     */
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _logUnmaskedIpsEnabled?;
    /**
     * @stability stable
     */
    get logUnmaskedIpsEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set logUnmaskedIpsEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLogUnmaskedIpsEnabled(): void;
    /**
     * @stability stable
     */
    get logUnmaskedIpsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _queryForResources?;
    /**
     * @stability stable
     */
    get queryForResources(): string;
    /**
     * @stability stable
     */
    set queryForResources(value: string);
    /**
     * @stability stable
     */
    resetQueryForResources(): void;
    /**
     * @stability stable
     */
    get queryForResourcesInput(): string | undefined;
    private _querySubscriptionIds?;
    /**
     * @stability stable
     */
    get querySubscriptionIds(): string[];
    /**
     * @stability stable
     */
    set querySubscriptionIds(value: string[]);
    /**
     * @stability stable
     */
    resetQuerySubscriptionIds(): void;
    /**
     * @stability stable
     */
    get querySubscriptionIdsInput(): string[] | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _additionalWorkspace?;
    /**
     * @stability stable
     */
    get additionalWorkspace(): IotSecuritySolutionAdditionalWorkspace[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set additionalWorkspace(value: IotSecuritySolutionAdditionalWorkspace[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAdditionalWorkspace(): void;
    /**
     * @stability stable
     */
    get additionalWorkspaceInput(): cdktf.IResolvable | IotSecuritySolutionAdditionalWorkspace[] | undefined;
    private _recommendationsEnabled;
    /**
     * @stability stable
     */
    get recommendationsEnabled(): IotSecuritySolutionRecommendationsEnabledOutputReference;
    /**
     * @stability stable
     */
    putRecommendationsEnabled(value: IotSecuritySolutionRecommendationsEnabled): void;
    /**
     * @stability stable
     */
    resetRecommendationsEnabled(): void;
    /**
     * @stability stable
     */
    get recommendationsEnabledInput(): IotSecuritySolutionRecommendationsEnabled | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): IotSecuritySolutionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: IotSecuritySolutionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): IotSecuritySolutionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
