import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MaintenanceAssignmentVirtualMachineConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/maintenance_assignment_virtual_machine#location MaintenanceAssignmentVirtualMachine#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/maintenance_assignment_virtual_machine#maintenance_configuration_id MaintenanceAssignmentVirtualMachine#maintenance_configuration_id}.
     *
     * @stability stable
     */
    readonly maintenanceConfigurationId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/maintenance_assignment_virtual_machine#virtual_machine_id MaintenanceAssignmentVirtualMachine#virtual_machine_id}.
     *
     * @stability stable
     */
    readonly virtualMachineId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/maintenance_assignment_virtual_machine#timeouts MaintenanceAssignmentVirtualMachine#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MaintenanceAssignmentVirtualMachineTimeouts;
}
/**
 * @stability stable
 */
export interface MaintenanceAssignmentVirtualMachineTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/maintenance_assignment_virtual_machine#create MaintenanceAssignmentVirtualMachine#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/maintenance_assignment_virtual_machine#delete MaintenanceAssignmentVirtualMachine#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/maintenance_assignment_virtual_machine#read MaintenanceAssignmentVirtualMachine#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function maintenanceAssignmentVirtualMachineTimeoutsToTerraform(struct?: MaintenanceAssignmentVirtualMachineTimeoutsOutputReference | MaintenanceAssignmentVirtualMachineTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class MaintenanceAssignmentVirtualMachineTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MaintenanceAssignmentVirtualMachineTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MaintenanceAssignmentVirtualMachineTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/maintenance_assignment_virtual_machine azurerm_maintenance_assignment_virtual_machine}.
 *
 * @stability stable
 */
export declare class MaintenanceAssignmentVirtualMachine extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/maintenance_assignment_virtual_machine azurerm_maintenance_assignment_virtual_machine} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MaintenanceAssignmentVirtualMachineConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _maintenanceConfigurationId?;
    /**
     * @stability stable
     */
    get maintenanceConfigurationId(): string;
    /**
     * @stability stable
     */
    set maintenanceConfigurationId(value: string);
    /**
     * @stability stable
     */
    get maintenanceConfigurationIdInput(): string | undefined;
    private _virtualMachineId?;
    /**
     * @stability stable
     */
    get virtualMachineId(): string;
    /**
     * @stability stable
     */
    set virtualMachineId(value: string);
    /**
     * @stability stable
     */
    get virtualMachineIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MaintenanceAssignmentVirtualMachineTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MaintenanceAssignmentVirtualMachineTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MaintenanceAssignmentVirtualMachineTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
