import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MediaLiveEventOutputConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event_output#archive_window_duration MediaLiveEventOutput#archive_window_duration}.
     *
     * @stability stable
     */
    readonly archiveWindowDuration: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event_output#asset_name MediaLiveEventOutput#asset_name}.
     *
     * @stability stable
     */
    readonly assetName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event_output#description MediaLiveEventOutput#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event_output#hls_fragments_per_ts_segment MediaLiveEventOutput#hls_fragments_per_ts_segment}.
     *
     * @stability stable
     */
    readonly hlsFragmentsPerTsSegment?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event_output#live_event_id MediaLiveEventOutput#live_event_id}.
     *
     * @stability stable
     */
    readonly liveEventId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event_output#manifest_name MediaLiveEventOutput#manifest_name}.
     *
     * @stability stable
     */
    readonly manifestName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event_output#name MediaLiveEventOutput#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event_output#output_snap_time_in_seconds MediaLiveEventOutput#output_snap_time_in_seconds}.
     *
     * @stability stable
     */
    readonly outputSnapTimeInSeconds?: number;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event_output#timeouts MediaLiveEventOutput#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MediaLiveEventOutputTimeouts;
}
/**
 * @stability stable
 */
export interface MediaLiveEventOutputTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event_output#create MediaLiveEventOutput#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event_output#delete MediaLiveEventOutput#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event_output#read MediaLiveEventOutput#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event_output#update MediaLiveEventOutput#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function mediaLiveEventOutputTimeoutsToTerraform(struct?: MediaLiveEventOutputTimeoutsOutputReference | MediaLiveEventOutputTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class MediaLiveEventOutputTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaLiveEventOutputTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaLiveEventOutputTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event_output azurerm_media_live_event_output}.
 *
 * @stability stable
 */
export declare class MediaLiveEventOutput extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event_output azurerm_media_live_event_output} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MediaLiveEventOutputConfig);
    private _archiveWindowDuration?;
    /**
     * @stability stable
     */
    get archiveWindowDuration(): string;
    /**
     * @stability stable
     */
    set archiveWindowDuration(value: string);
    /**
     * @stability stable
     */
    get archiveWindowDurationInput(): string | undefined;
    private _assetName?;
    /**
     * @stability stable
     */
    get assetName(): string;
    /**
     * @stability stable
     */
    set assetName(value: string);
    /**
     * @stability stable
     */
    get assetNameInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _hlsFragmentsPerTsSegment?;
    /**
     * @stability stable
     */
    get hlsFragmentsPerTsSegment(): number;
    /**
     * @stability stable
     */
    set hlsFragmentsPerTsSegment(value: number);
    /**
     * @stability stable
     */
    resetHlsFragmentsPerTsSegment(): void;
    /**
     * @stability stable
     */
    get hlsFragmentsPerTsSegmentInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _liveEventId?;
    /**
     * @stability stable
     */
    get liveEventId(): string;
    /**
     * @stability stable
     */
    set liveEventId(value: string);
    /**
     * @stability stable
     */
    get liveEventIdInput(): string | undefined;
    private _manifestName?;
    /**
     * @stability stable
     */
    get manifestName(): string;
    /**
     * @stability stable
     */
    set manifestName(value: string);
    /**
     * @stability stable
     */
    resetManifestName(): void;
    /**
     * @stability stable
     */
    get manifestNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _outputSnapTimeInSeconds?;
    /**
     * @stability stable
     */
    get outputSnapTimeInSeconds(): number;
    /**
     * @stability stable
     */
    set outputSnapTimeInSeconds(value: number);
    /**
     * @stability stable
     */
    resetOutputSnapTimeInSeconds(): void;
    /**
     * @stability stable
     */
    get outputSnapTimeInSecondsInput(): number | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MediaLiveEventOutputTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MediaLiveEventOutputTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MediaLiveEventOutputTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
