import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MediaStreamingEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_endpoint#auto_start_enabled MediaStreamingEndpoint#auto_start_enabled}.
     *
     * @stability stable
     */
    readonly autoStartEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_endpoint#cdn_enabled MediaStreamingEndpoint#cdn_enabled}.
     *
     * @stability stable
     */
    readonly cdnEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_endpoint#cdn_profile MediaStreamingEndpoint#cdn_profile}.
     *
     * @stability stable
     */
    readonly cdnProfile?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_endpoint#cdn_provider MediaStreamingEndpoint#cdn_provider}.
     *
     * @stability stable
     */
    readonly cdnProvider?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_endpoint#custom_host_names MediaStreamingEndpoint#custom_host_names}.
     *
     * @stability stable
     */
    readonly customHostNames?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_endpoint#description MediaStreamingEndpoint#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_endpoint#location MediaStreamingEndpoint#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_endpoint#max_cache_age_seconds MediaStreamingEndpoint#max_cache_age_seconds}.
     *
     * @stability stable
     */
    readonly maxCacheAgeSeconds?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_endpoint#media_services_account_name MediaStreamingEndpoint#media_services_account_name}.
     *
     * @stability stable
     */
    readonly mediaServicesAccountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_endpoint#name MediaStreamingEndpoint#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_endpoint#resource_group_name MediaStreamingEndpoint#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_endpoint#scale_units MediaStreamingEndpoint#scale_units}.
     *
     * @stability stable
     */
    readonly scaleUnits: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_endpoint#tags MediaStreamingEndpoint#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * access_control block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_endpoint#access_control MediaStreamingEndpoint#access_control}
     *
     * @stability stable
     */
    readonly accessControl?: MediaStreamingEndpointAccessControl;
    /**
     * cross_site_access_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_endpoint#cross_site_access_policy MediaStreamingEndpoint#cross_site_access_policy}
     *
     * @stability stable
     */
    readonly crossSiteAccessPolicy?: MediaStreamingEndpointCrossSiteAccessPolicy;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_endpoint#timeouts MediaStreamingEndpoint#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MediaStreamingEndpointTimeouts;
}
/**
 * @stability stable
 */
export interface MediaStreamingEndpointAccessControlAkamaiSignatureHeaderAuthenticationKey {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_endpoint#base64_key MediaStreamingEndpoint#base64_key}.
     *
     * @stability stable
     */
    readonly base64Key?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_endpoint#expiration MediaStreamingEndpoint#expiration}.
     *
     * @stability stable
     */
    readonly expiration?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_endpoint#identifier MediaStreamingEndpoint#identifier}.
     *
     * @stability stable
     */
    readonly identifier?: string;
}
export declare function mediaStreamingEndpointAccessControlAkamaiSignatureHeaderAuthenticationKeyToTerraform(struct?: MediaStreamingEndpointAccessControlAkamaiSignatureHeaderAuthenticationKey | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface MediaStreamingEndpointAccessControlIpAllow {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_endpoint#address MediaStreamingEndpoint#address}.
     *
     * @stability stable
     */
    readonly address?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_endpoint#name MediaStreamingEndpoint#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_endpoint#subnet_prefix_length MediaStreamingEndpoint#subnet_prefix_length}.
     *
     * @stability stable
     */
    readonly subnetPrefixLength?: number;
}
export declare function mediaStreamingEndpointAccessControlIpAllowToTerraform(struct?: MediaStreamingEndpointAccessControlIpAllow | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface MediaStreamingEndpointAccessControl {
    /**
     * akamai_signature_header_authentication_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_endpoint#akamai_signature_header_authentication_key MediaStreamingEndpoint#akamai_signature_header_authentication_key}
     *
     * @stability stable
     */
    readonly akamaiSignatureHeaderAuthenticationKey?: MediaStreamingEndpointAccessControlAkamaiSignatureHeaderAuthenticationKey[] | cdktf.IResolvable;
    /**
     * ip_allow block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_endpoint#ip_allow MediaStreamingEndpoint#ip_allow}
     *
     * @stability stable
     */
    readonly ipAllow?: MediaStreamingEndpointAccessControlIpAllow[] | cdktf.IResolvable;
}
export declare function mediaStreamingEndpointAccessControlToTerraform(struct?: MediaStreamingEndpointAccessControlOutputReference | MediaStreamingEndpointAccessControl): any;
/**
 * @stability stable
 */
export declare class MediaStreamingEndpointAccessControlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaStreamingEndpointAccessControl | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaStreamingEndpointAccessControl | undefined);
    private _akamaiSignatureHeaderAuthenticationKey?;
    /**
     * @stability stable
     */
    get akamaiSignatureHeaderAuthenticationKey(): MediaStreamingEndpointAccessControlAkamaiSignatureHeaderAuthenticationKey[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set akamaiSignatureHeaderAuthenticationKey(value: MediaStreamingEndpointAccessControlAkamaiSignatureHeaderAuthenticationKey[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAkamaiSignatureHeaderAuthenticationKey(): void;
    /**
     * @stability stable
     */
    get akamaiSignatureHeaderAuthenticationKeyInput(): cdktf.IResolvable | MediaStreamingEndpointAccessControlAkamaiSignatureHeaderAuthenticationKey[] | undefined;
    private _ipAllow?;
    /**
     * @stability stable
     */
    get ipAllow(): MediaStreamingEndpointAccessControlIpAllow[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set ipAllow(value: MediaStreamingEndpointAccessControlIpAllow[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIpAllow(): void;
    /**
     * @stability stable
     */
    get ipAllowInput(): cdktf.IResolvable | MediaStreamingEndpointAccessControlIpAllow[] | undefined;
}
/**
 * @stability stable
 */
export interface MediaStreamingEndpointCrossSiteAccessPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_endpoint#client_access_policy MediaStreamingEndpoint#client_access_policy}.
     *
     * @stability stable
     */
    readonly clientAccessPolicy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_endpoint#cross_domain_policy MediaStreamingEndpoint#cross_domain_policy}.
     *
     * @stability stable
     */
    readonly crossDomainPolicy?: string;
}
export declare function mediaStreamingEndpointCrossSiteAccessPolicyToTerraform(struct?: MediaStreamingEndpointCrossSiteAccessPolicyOutputReference | MediaStreamingEndpointCrossSiteAccessPolicy): any;
/**
 * @stability stable
 */
export declare class MediaStreamingEndpointCrossSiteAccessPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaStreamingEndpointCrossSiteAccessPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaStreamingEndpointCrossSiteAccessPolicy | undefined);
    private _clientAccessPolicy?;
    /**
     * @stability stable
     */
    get clientAccessPolicy(): string;
    /**
     * @stability stable
     */
    set clientAccessPolicy(value: string);
    /**
     * @stability stable
     */
    resetClientAccessPolicy(): void;
    /**
     * @stability stable
     */
    get clientAccessPolicyInput(): string | undefined;
    private _crossDomainPolicy?;
    /**
     * @stability stable
     */
    get crossDomainPolicy(): string;
    /**
     * @stability stable
     */
    set crossDomainPolicy(value: string);
    /**
     * @stability stable
     */
    resetCrossDomainPolicy(): void;
    /**
     * @stability stable
     */
    get crossDomainPolicyInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MediaStreamingEndpointTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_endpoint#create MediaStreamingEndpoint#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_endpoint#delete MediaStreamingEndpoint#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_endpoint#read MediaStreamingEndpoint#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_endpoint#update MediaStreamingEndpoint#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function mediaStreamingEndpointTimeoutsToTerraform(struct?: MediaStreamingEndpointTimeoutsOutputReference | MediaStreamingEndpointTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class MediaStreamingEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaStreamingEndpointTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaStreamingEndpointTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_endpoint azurerm_media_streaming_endpoint}.
 *
 * @stability stable
 */
export declare class MediaStreamingEndpoint extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_endpoint azurerm_media_streaming_endpoint} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MediaStreamingEndpointConfig);
    private _autoStartEnabled?;
    /**
     * @stability stable
     */
    get autoStartEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set autoStartEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutoStartEnabled(): void;
    /**
     * @stability stable
     */
    get autoStartEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _cdnEnabled?;
    /**
     * @stability stable
     */
    get cdnEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set cdnEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCdnEnabled(): void;
    /**
     * @stability stable
     */
    get cdnEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _cdnProfile?;
    /**
     * @stability stable
     */
    get cdnProfile(): string;
    /**
     * @stability stable
     */
    set cdnProfile(value: string);
    /**
     * @stability stable
     */
    resetCdnProfile(): void;
    /**
     * @stability stable
     */
    get cdnProfileInput(): string | undefined;
    private _cdnProvider?;
    /**
     * @stability stable
     */
    get cdnProvider(): string;
    /**
     * @stability stable
     */
    set cdnProvider(value: string);
    /**
     * @stability stable
     */
    resetCdnProvider(): void;
    /**
     * @stability stable
     */
    get cdnProviderInput(): string | undefined;
    private _customHostNames?;
    /**
     * @stability stable
     */
    get customHostNames(): string[];
    /**
     * @stability stable
     */
    set customHostNames(value: string[]);
    /**
     * @stability stable
     */
    resetCustomHostNames(): void;
    /**
     * @stability stable
     */
    get customHostNamesInput(): string[] | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get hostName(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _maxCacheAgeSeconds?;
    /**
     * @stability stable
     */
    get maxCacheAgeSeconds(): number;
    /**
     * @stability stable
     */
    set maxCacheAgeSeconds(value: number);
    /**
     * @stability stable
     */
    resetMaxCacheAgeSeconds(): void;
    /**
     * @stability stable
     */
    get maxCacheAgeSecondsInput(): number | undefined;
    private _mediaServicesAccountName?;
    /**
     * @stability stable
     */
    get mediaServicesAccountName(): string;
    /**
     * @stability stable
     */
    set mediaServicesAccountName(value: string);
    /**
     * @stability stable
     */
    get mediaServicesAccountNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _scaleUnits?;
    /**
     * @stability stable
     */
    get scaleUnits(): number;
    /**
     * @stability stable
     */
    set scaleUnits(value: number);
    /**
     * @stability stable
     */
    get scaleUnitsInput(): number | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _accessControl;
    /**
     * @stability stable
     */
    get accessControl(): MediaStreamingEndpointAccessControlOutputReference;
    /**
     * @stability stable
     */
    putAccessControl(value: MediaStreamingEndpointAccessControl): void;
    /**
     * @stability stable
     */
    resetAccessControl(): void;
    /**
     * @stability stable
     */
    get accessControlInput(): MediaStreamingEndpointAccessControl | undefined;
    private _crossSiteAccessPolicy;
    /**
     * @stability stable
     */
    get crossSiteAccessPolicy(): MediaStreamingEndpointCrossSiteAccessPolicyOutputReference;
    /**
     * @stability stable
     */
    putCrossSiteAccessPolicy(value: MediaStreamingEndpointCrossSiteAccessPolicy): void;
    /**
     * @stability stable
     */
    resetCrossSiteAccessPolicy(): void;
    /**
     * @stability stable
     */
    get crossSiteAccessPolicyInput(): MediaStreamingEndpointCrossSiteAccessPolicy | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MediaStreamingEndpointTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MediaStreamingEndpointTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MediaStreamingEndpointTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
