import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PostgresqlServerConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#administrator_login PostgresqlServer#administrator_login}.
     *
     * @stability stable
     */
    readonly administratorLogin?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#administrator_login_password PostgresqlServer#administrator_login_password}.
     *
     * @stability stable
     */
    readonly administratorLoginPassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#auto_grow_enabled PostgresqlServer#auto_grow_enabled}.
     *
     * @stability stable
     */
    readonly autoGrowEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#backup_retention_days PostgresqlServer#backup_retention_days}.
     *
     * @stability stable
     */
    readonly backupRetentionDays?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#create_mode PostgresqlServer#create_mode}.
     *
     * @stability stable
     */
    readonly createMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#creation_source_server_id PostgresqlServer#creation_source_server_id}.
     *
     * @stability stable
     */
    readonly creationSourceServerId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#geo_redundant_backup_enabled PostgresqlServer#geo_redundant_backup_enabled}.
     *
     * @stability stable
     */
    readonly geoRedundantBackupEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#infrastructure_encryption_enabled PostgresqlServer#infrastructure_encryption_enabled}.
     *
     * @stability stable
     */
    readonly infrastructureEncryptionEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#location PostgresqlServer#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#name PostgresqlServer#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#public_network_access_enabled PostgresqlServer#public_network_access_enabled}.
     *
     * @stability stable
     */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#resource_group_name PostgresqlServer#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#restore_point_in_time PostgresqlServer#restore_point_in_time}.
     *
     * @stability stable
     */
    readonly restorePointInTime?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#sku_name PostgresqlServer#sku_name}.
     *
     * @stability stable
     */
    readonly skuName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#ssl_enforcement PostgresqlServer#ssl_enforcement}.
     *
     * @stability stable
     */
    readonly sslEnforcement?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#ssl_enforcement_enabled PostgresqlServer#ssl_enforcement_enabled}.
     *
     * @stability stable
     */
    readonly sslEnforcementEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#ssl_minimal_tls_version_enforced PostgresqlServer#ssl_minimal_tls_version_enforced}.
     *
     * @stability stable
     */
    readonly sslMinimalTlsVersionEnforced?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#storage_mb PostgresqlServer#storage_mb}.
     *
     * @stability stable
     */
    readonly storageMb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#tags PostgresqlServer#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#version PostgresqlServer#version}.
     *
     * @stability stable
     */
    readonly version: string;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#identity PostgresqlServer#identity}
     *
     * @stability stable
     */
    readonly identity?: PostgresqlServerIdentity;
    /**
     * storage_profile block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#storage_profile PostgresqlServer#storage_profile}
     *
     * @stability stable
     */
    readonly storageProfile?: PostgresqlServerStorageProfile;
    /**
     * threat_detection_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#threat_detection_policy PostgresqlServer#threat_detection_policy}
     *
     * @stability stable
     */
    readonly threatDetectionPolicy?: PostgresqlServerThreatDetectionPolicy;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#timeouts PostgresqlServer#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: PostgresqlServerTimeouts;
}
/**
 * @stability stable
 */
export interface PostgresqlServerIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#type PostgresqlServer#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function postgresqlServerIdentityToTerraform(struct?: PostgresqlServerIdentityOutputReference | PostgresqlServerIdentity): any;
/**
 * @stability stable
 */
export declare class PostgresqlServerIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PostgresqlServerIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PostgresqlServerIdentity | undefined);
    /**
     * @stability stable
     */
    get principalId(): string;
    /**
     * @stability stable
     */
    get tenantId(): string;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface PostgresqlServerStorageProfile {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#auto_grow PostgresqlServer#auto_grow}.
     *
     * @stability stable
     */
    readonly autoGrow?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#backup_retention_days PostgresqlServer#backup_retention_days}.
     *
     * @stability stable
     */
    readonly backupRetentionDays?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#geo_redundant_backup PostgresqlServer#geo_redundant_backup}.
     *
     * @stability stable
     */
    readonly geoRedundantBackup?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#storage_mb PostgresqlServer#storage_mb}.
     *
     * @stability stable
     */
    readonly storageMb?: number;
}
export declare function postgresqlServerStorageProfileToTerraform(struct?: PostgresqlServerStorageProfileOutputReference | PostgresqlServerStorageProfile): any;
/**
 * @stability stable
 */
export declare class PostgresqlServerStorageProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PostgresqlServerStorageProfile | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PostgresqlServerStorageProfile | undefined);
    private _autoGrow?;
    /**
     * @stability stable
     */
    get autoGrow(): string;
    /**
     * @stability stable
     */
    set autoGrow(value: string);
    /**
     * @stability stable
     */
    resetAutoGrow(): void;
    /**
     * @stability stable
     */
    get autoGrowInput(): string | undefined;
    private _backupRetentionDays?;
    /**
     * @stability stable
     */
    get backupRetentionDays(): number;
    /**
     * @stability stable
     */
    set backupRetentionDays(value: number);
    /**
     * @stability stable
     */
    resetBackupRetentionDays(): void;
    /**
     * @stability stable
     */
    get backupRetentionDaysInput(): number | undefined;
    private _geoRedundantBackup?;
    /**
     * @stability stable
     */
    get geoRedundantBackup(): string;
    /**
     * @stability stable
     */
    set geoRedundantBackup(value: string);
    /**
     * @stability stable
     */
    resetGeoRedundantBackup(): void;
    /**
     * @stability stable
     */
    get geoRedundantBackupInput(): string | undefined;
    private _storageMb?;
    /**
     * @stability stable
     */
    get storageMb(): number;
    /**
     * @stability stable
     */
    set storageMb(value: number);
    /**
     * @stability stable
     */
    resetStorageMb(): void;
    /**
     * @stability stable
     */
    get storageMbInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface PostgresqlServerThreatDetectionPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#disabled_alerts PostgresqlServer#disabled_alerts}.
     *
     * @stability stable
     */
    readonly disabledAlerts?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#email_account_admins PostgresqlServer#email_account_admins}.
     *
     * @stability stable
     */
    readonly emailAccountAdmins?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#email_addresses PostgresqlServer#email_addresses}.
     *
     * @stability stable
     */
    readonly emailAddresses?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#enabled PostgresqlServer#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#retention_days PostgresqlServer#retention_days}.
     *
     * @stability stable
     */
    readonly retentionDays?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#storage_account_access_key PostgresqlServer#storage_account_access_key}.
     *
     * @stability stable
     */
    readonly storageAccountAccessKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#storage_endpoint PostgresqlServer#storage_endpoint}.
     *
     * @stability stable
     */
    readonly storageEndpoint?: string;
}
export declare function postgresqlServerThreatDetectionPolicyToTerraform(struct?: PostgresqlServerThreatDetectionPolicyOutputReference | PostgresqlServerThreatDetectionPolicy): any;
/**
 * @stability stable
 */
export declare class PostgresqlServerThreatDetectionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PostgresqlServerThreatDetectionPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PostgresqlServerThreatDetectionPolicy | undefined);
    private _disabledAlerts?;
    /**
     * @stability stable
     */
    get disabledAlerts(): string[];
    /**
     * @stability stable
     */
    set disabledAlerts(value: string[]);
    /**
     * @stability stable
     */
    resetDisabledAlerts(): void;
    /**
     * @stability stable
     */
    get disabledAlertsInput(): string[] | undefined;
    private _emailAccountAdmins?;
    /**
     * @stability stable
     */
    get emailAccountAdmins(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set emailAccountAdmins(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEmailAccountAdmins(): void;
    /**
     * @stability stable
     */
    get emailAccountAdminsInput(): boolean | cdktf.IResolvable | undefined;
    private _emailAddresses?;
    /**
     * @stability stable
     */
    get emailAddresses(): string[];
    /**
     * @stability stable
     */
    set emailAddresses(value: string[]);
    /**
     * @stability stable
     */
    resetEmailAddresses(): void;
    /**
     * @stability stable
     */
    get emailAddressesInput(): string[] | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _retentionDays?;
    /**
     * @stability stable
     */
    get retentionDays(): number;
    /**
     * @stability stable
     */
    set retentionDays(value: number);
    /**
     * @stability stable
     */
    resetRetentionDays(): void;
    /**
     * @stability stable
     */
    get retentionDaysInput(): number | undefined;
    private _storageAccountAccessKey?;
    /**
     * @stability stable
     */
    get storageAccountAccessKey(): string;
    /**
     * @stability stable
     */
    set storageAccountAccessKey(value: string);
    /**
     * @stability stable
     */
    resetStorageAccountAccessKey(): void;
    /**
     * @stability stable
     */
    get storageAccountAccessKeyInput(): string | undefined;
    private _storageEndpoint?;
    /**
     * @stability stable
     */
    get storageEndpoint(): string;
    /**
     * @stability stable
     */
    set storageEndpoint(value: string);
    /**
     * @stability stable
     */
    resetStorageEndpoint(): void;
    /**
     * @stability stable
     */
    get storageEndpointInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface PostgresqlServerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#create PostgresqlServer#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#delete PostgresqlServer#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#read PostgresqlServer#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server#update PostgresqlServer#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function postgresqlServerTimeoutsToTerraform(struct?: PostgresqlServerTimeoutsOutputReference | PostgresqlServerTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class PostgresqlServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PostgresqlServerTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PostgresqlServerTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server azurerm_postgresql_server}.
 *
 * @stability stable
 */
export declare class PostgresqlServer extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_server azurerm_postgresql_server} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PostgresqlServerConfig);
    private _administratorLogin?;
    /**
     * @stability stable
     */
    get administratorLogin(): string;
    /**
     * @stability stable
     */
    set administratorLogin(value: string);
    /**
     * @stability stable
     */
    resetAdministratorLogin(): void;
    /**
     * @stability stable
     */
    get administratorLoginInput(): string | undefined;
    private _administratorLoginPassword?;
    /**
     * @stability stable
     */
    get administratorLoginPassword(): string;
    /**
     * @stability stable
     */
    set administratorLoginPassword(value: string);
    /**
     * @stability stable
     */
    resetAdministratorLoginPassword(): void;
    /**
     * @stability stable
     */
    get administratorLoginPasswordInput(): string | undefined;
    private _autoGrowEnabled?;
    /**
     * @stability stable
     */
    get autoGrowEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set autoGrowEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutoGrowEnabled(): void;
    /**
     * @stability stable
     */
    get autoGrowEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _backupRetentionDays?;
    /**
     * @stability stable
     */
    get backupRetentionDays(): number;
    /**
     * @stability stable
     */
    set backupRetentionDays(value: number);
    /**
     * @stability stable
     */
    resetBackupRetentionDays(): void;
    /**
     * @stability stable
     */
    get backupRetentionDaysInput(): number | undefined;
    private _createMode?;
    /**
     * @stability stable
     */
    get createMode(): string;
    /**
     * @stability stable
     */
    set createMode(value: string);
    /**
     * @stability stable
     */
    resetCreateMode(): void;
    /**
     * @stability stable
     */
    get createModeInput(): string | undefined;
    private _creationSourceServerId?;
    /**
     * @stability stable
     */
    get creationSourceServerId(): string;
    /**
     * @stability stable
     */
    set creationSourceServerId(value: string);
    /**
     * @stability stable
     */
    resetCreationSourceServerId(): void;
    /**
     * @stability stable
     */
    get creationSourceServerIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get fqdn(): string;
    private _geoRedundantBackupEnabled?;
    /**
     * @stability stable
     */
    get geoRedundantBackupEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set geoRedundantBackupEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGeoRedundantBackupEnabled(): void;
    /**
     * @stability stable
     */
    get geoRedundantBackupEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _infrastructureEncryptionEnabled?;
    /**
     * @stability stable
     */
    get infrastructureEncryptionEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set infrastructureEncryptionEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetInfrastructureEncryptionEnabled(): void;
    /**
     * @stability stable
     */
    get infrastructureEncryptionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _publicNetworkAccessEnabled?;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPublicNetworkAccessEnabled(): void;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _restorePointInTime?;
    /**
     * @stability stable
     */
    get restorePointInTime(): string;
    /**
     * @stability stable
     */
    set restorePointInTime(value: string);
    /**
     * @stability stable
     */
    resetRestorePointInTime(): void;
    /**
     * @stability stable
     */
    get restorePointInTimeInput(): string | undefined;
    private _skuName?;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    set skuName(value: string);
    /**
     * @stability stable
     */
    get skuNameInput(): string | undefined;
    private _sslEnforcement?;
    /**
     * @stability stable
     */
    get sslEnforcement(): string;
    /**
     * @stability stable
     */
    set sslEnforcement(value: string);
    /**
     * @stability stable
     */
    resetSslEnforcement(): void;
    /**
     * @stability stable
     */
    get sslEnforcementInput(): string | undefined;
    private _sslEnforcementEnabled?;
    /**
     * @stability stable
     */
    get sslEnforcementEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set sslEnforcementEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSslEnforcementEnabled(): void;
    /**
     * @stability stable
     */
    get sslEnforcementEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _sslMinimalTlsVersionEnforced?;
    /**
     * @stability stable
     */
    get sslMinimalTlsVersionEnforced(): string;
    /**
     * @stability stable
     */
    set sslMinimalTlsVersionEnforced(value: string);
    /**
     * @stability stable
     */
    resetSslMinimalTlsVersionEnforced(): void;
    /**
     * @stability stable
     */
    get sslMinimalTlsVersionEnforcedInput(): string | undefined;
    private _storageMb?;
    /**
     * @stability stable
     */
    get storageMb(): number;
    /**
     * @stability stable
     */
    set storageMb(value: number);
    /**
     * @stability stable
     */
    resetStorageMb(): void;
    /**
     * @stability stable
     */
    get storageMbInput(): number | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): PostgresqlServerIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: PostgresqlServerIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): PostgresqlServerIdentity | undefined;
    private _storageProfile;
    /**
     * @stability stable
     */
    get storageProfile(): PostgresqlServerStorageProfileOutputReference;
    /**
     * @stability stable
     */
    putStorageProfile(value: PostgresqlServerStorageProfile): void;
    /**
     * @stability stable
     */
    resetStorageProfile(): void;
    /**
     * @stability stable
     */
    get storageProfileInput(): PostgresqlServerStorageProfile | undefined;
    private _threatDetectionPolicy;
    /**
     * @stability stable
     */
    get threatDetectionPolicy(): PostgresqlServerThreatDetectionPolicyOutputReference;
    /**
     * @stability stable
     */
    putThreatDetectionPolicy(value: PostgresqlServerThreatDetectionPolicy): void;
    /**
     * @stability stable
     */
    resetThreatDetectionPolicy(): void;
    /**
     * @stability stable
     */
    get threatDetectionPolicyInput(): PostgresqlServerThreatDetectionPolicy | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): PostgresqlServerTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: PostgresqlServerTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): PostgresqlServerTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
