import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PrivateDnsTxtRecordConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_txt_record#name PrivateDnsTxtRecord#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_txt_record#resource_group_name PrivateDnsTxtRecord#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_txt_record#tags PrivateDnsTxtRecord#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_txt_record#ttl PrivateDnsTxtRecord#ttl}.
     *
     * @stability stable
     */
    readonly ttl: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_txt_record#zone_name PrivateDnsTxtRecord#zone_name}.
     *
     * @stability stable
     */
    readonly zoneName: string;
    /**
     * record block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_txt_record#record PrivateDnsTxtRecord#record}
     *
     * @stability stable
     */
    readonly record: PrivateDnsTxtRecordRecord[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_txt_record#timeouts PrivateDnsTxtRecord#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: PrivateDnsTxtRecordTimeouts;
}
/**
 * @stability stable
 */
export interface PrivateDnsTxtRecordRecord {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_txt_record#value PrivateDnsTxtRecord#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function privateDnsTxtRecordRecordToTerraform(struct?: PrivateDnsTxtRecordRecord | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface PrivateDnsTxtRecordTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_txt_record#create PrivateDnsTxtRecord#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_txt_record#delete PrivateDnsTxtRecord#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_txt_record#read PrivateDnsTxtRecord#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_txt_record#update PrivateDnsTxtRecord#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function privateDnsTxtRecordTimeoutsToTerraform(struct?: PrivateDnsTxtRecordTimeoutsOutputReference | PrivateDnsTxtRecordTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class PrivateDnsTxtRecordTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivateDnsTxtRecordTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivateDnsTxtRecordTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_txt_record azurerm_private_dns_txt_record}.
 *
 * @stability stable
 */
export declare class PrivateDnsTxtRecord extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_txt_record azurerm_private_dns_txt_record} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PrivateDnsTxtRecordConfig);
    /**
     * @stability stable
     */
    get fqdn(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _ttl?;
    /**
     * @stability stable
     */
    get ttl(): number;
    /**
     * @stability stable
     */
    set ttl(value: number);
    /**
     * @stability stable
     */
    get ttlInput(): number | undefined;
    private _zoneName?;
    /**
     * @stability stable
     */
    get zoneName(): string;
    /**
     * @stability stable
     */
    set zoneName(value: string);
    /**
     * @stability stable
     */
    get zoneNameInput(): string | undefined;
    private _record?;
    /**
     * @stability stable
     */
    get record(): PrivateDnsTxtRecordRecord[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set record(value: PrivateDnsTxtRecordRecord[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get recordInput(): cdktf.IResolvable | PrivateDnsTxtRecordRecord[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): PrivateDnsTxtRecordTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: PrivateDnsTxtRecordTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): PrivateDnsTxtRecordTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
