import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PrivateEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_endpoint#location PrivateEndpoint#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_endpoint#name PrivateEndpoint#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_endpoint#resource_group_name PrivateEndpoint#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_endpoint#subnet_id PrivateEndpoint#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_endpoint#tags PrivateEndpoint#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * private_dns_zone_group block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_endpoint#private_dns_zone_group PrivateEndpoint#private_dns_zone_group}
     *
     * @stability stable
     */
    readonly privateDnsZoneGroup?: PrivateEndpointPrivateDnsZoneGroup;
    /**
     * private_service_connection block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_endpoint#private_service_connection PrivateEndpoint#private_service_connection}
     *
     * @stability stable
     */
    readonly privateServiceConnection: PrivateEndpointPrivateServiceConnection;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_endpoint#timeouts PrivateEndpoint#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: PrivateEndpointTimeouts;
}
/**
 * @stability stable
 */
export declare class PrivateEndpointCustomDnsConfigs extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get fqdn(): string;
    /**
     * @stability stable
     */
    get ipAddresses(): string[];
}
/**
 * @stability stable
 */
export declare class PrivateEndpointNetworkInterface extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
}
/**
 * @stability stable
 */
export declare class PrivateEndpointPrivateDnsZoneConfigsRecordSets extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get fqdn(): string;
    /**
     * @stability stable
     */
    get ipAddresses(): string[];
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get ttl(): number;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class PrivateEndpointPrivateDnsZoneConfigs extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get privateDnsZoneId(): string;
    /**
     * @stability stable
     */
    get recordSets(): cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface PrivateEndpointPrivateDnsZoneGroup {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_endpoint#name PrivateEndpoint#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_endpoint#private_dns_zone_ids PrivateEndpoint#private_dns_zone_ids}.
     *
     * @stability stable
     */
    readonly privateDnsZoneIds: string[];
}
export declare function privateEndpointPrivateDnsZoneGroupToTerraform(struct?: PrivateEndpointPrivateDnsZoneGroupOutputReference | PrivateEndpointPrivateDnsZoneGroup): any;
/**
 * @stability stable
 */
export declare class PrivateEndpointPrivateDnsZoneGroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivateEndpointPrivateDnsZoneGroup | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivateEndpointPrivateDnsZoneGroup | undefined);
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _privateDnsZoneIds?;
    /**
     * @stability stable
     */
    get privateDnsZoneIds(): string[];
    /**
     * @stability stable
     */
    set privateDnsZoneIds(value: string[]);
    /**
     * @stability stable
     */
    get privateDnsZoneIdsInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface PrivateEndpointPrivateServiceConnection {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_endpoint#is_manual_connection PrivateEndpoint#is_manual_connection}.
     *
     * @stability stable
     */
    readonly isManualConnection: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_endpoint#name PrivateEndpoint#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_endpoint#private_connection_resource_alias PrivateEndpoint#private_connection_resource_alias}.
     *
     * @stability stable
     */
    readonly privateConnectionResourceAlias?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_endpoint#private_connection_resource_id PrivateEndpoint#private_connection_resource_id}.
     *
     * @stability stable
     */
    readonly privateConnectionResourceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_endpoint#request_message PrivateEndpoint#request_message}.
     *
     * @stability stable
     */
    readonly requestMessage?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_endpoint#subresource_names PrivateEndpoint#subresource_names}.
     *
     * @stability stable
     */
    readonly subresourceNames?: string[];
}
export declare function privateEndpointPrivateServiceConnectionToTerraform(struct?: PrivateEndpointPrivateServiceConnectionOutputReference | PrivateEndpointPrivateServiceConnection): any;
/**
 * @stability stable
 */
export declare class PrivateEndpointPrivateServiceConnectionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivateEndpointPrivateServiceConnection | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivateEndpointPrivateServiceConnection | undefined);
    private _isManualConnection?;
    /**
     * @stability stable
     */
    get isManualConnection(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isManualConnection(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get isManualConnectionInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _privateConnectionResourceAlias?;
    /**
     * @stability stable
     */
    get privateConnectionResourceAlias(): string;
    /**
     * @stability stable
     */
    set privateConnectionResourceAlias(value: string);
    /**
     * @stability stable
     */
    resetPrivateConnectionResourceAlias(): void;
    /**
     * @stability stable
     */
    get privateConnectionResourceAliasInput(): string | undefined;
    private _privateConnectionResourceId?;
    /**
     * @stability stable
     */
    get privateConnectionResourceId(): string;
    /**
     * @stability stable
     */
    set privateConnectionResourceId(value: string);
    /**
     * @stability stable
     */
    resetPrivateConnectionResourceId(): void;
    /**
     * @stability stable
     */
    get privateConnectionResourceIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get privateIpAddress(): string;
    private _requestMessage?;
    /**
     * @stability stable
     */
    get requestMessage(): string;
    /**
     * @stability stable
     */
    set requestMessage(value: string);
    /**
     * @stability stable
     */
    resetRequestMessage(): void;
    /**
     * @stability stable
     */
    get requestMessageInput(): string | undefined;
    private _subresourceNames?;
    /**
     * @stability stable
     */
    get subresourceNames(): string[];
    /**
     * @stability stable
     */
    set subresourceNames(value: string[]);
    /**
     * @stability stable
     */
    resetSubresourceNames(): void;
    /**
     * @stability stable
     */
    get subresourceNamesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface PrivateEndpointTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_endpoint#create PrivateEndpoint#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_endpoint#delete PrivateEndpoint#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_endpoint#read PrivateEndpoint#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_endpoint#update PrivateEndpoint#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function privateEndpointTimeoutsToTerraform(struct?: PrivateEndpointTimeoutsOutputReference | PrivateEndpointTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class PrivateEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivateEndpointTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivateEndpointTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/private_endpoint azurerm_private_endpoint}.
 *
 * @stability stable
 */
export declare class PrivateEndpoint extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/private_endpoint azurerm_private_endpoint} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PrivateEndpointConfig);
    /**
     * @stability stable
     */
    customDnsConfigs(index: string): PrivateEndpointCustomDnsConfigs;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    networkInterface(index: string): PrivateEndpointNetworkInterface;
    /**
     * @stability stable
     */
    privateDnsZoneConfigs(index: string): PrivateEndpointPrivateDnsZoneConfigs;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _privateDnsZoneGroup;
    /**
     * @stability stable
     */
    get privateDnsZoneGroup(): PrivateEndpointPrivateDnsZoneGroupOutputReference;
    /**
     * @stability stable
     */
    putPrivateDnsZoneGroup(value: PrivateEndpointPrivateDnsZoneGroup): void;
    /**
     * @stability stable
     */
    resetPrivateDnsZoneGroup(): void;
    /**
     * @stability stable
     */
    get privateDnsZoneGroupInput(): PrivateEndpointPrivateDnsZoneGroup | undefined;
    private _privateServiceConnection;
    /**
     * @stability stable
     */
    get privateServiceConnection(): PrivateEndpointPrivateServiceConnectionOutputReference;
    /**
     * @stability stable
     */
    putPrivateServiceConnection(value: PrivateEndpointPrivateServiceConnection): void;
    /**
     * @stability stable
     */
    get privateServiceConnectionInput(): PrivateEndpointPrivateServiceConnection | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): PrivateEndpointTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: PrivateEndpointTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): PrivateEndpointTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
