import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ResourceProviderRegistrationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_provider_registration#name ResourceProviderRegistration#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * feature block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_provider_registration#feature ResourceProviderRegistration#feature}
     *
     * @stability stable
     */
    readonly feature?: ResourceProviderRegistrationFeature[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_provider_registration#timeouts ResourceProviderRegistration#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ResourceProviderRegistrationTimeouts;
}
/**
 * @stability stable
 */
export interface ResourceProviderRegistrationFeature {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_provider_registration#name ResourceProviderRegistration#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_provider_registration#registered ResourceProviderRegistration#registered}.
     *
     * @stability stable
     */
    readonly registered: boolean | cdktf.IResolvable;
}
export declare function resourceProviderRegistrationFeatureToTerraform(struct?: ResourceProviderRegistrationFeature | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ResourceProviderRegistrationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_provider_registration#create ResourceProviderRegistration#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_provider_registration#delete ResourceProviderRegistration#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_provider_registration#read ResourceProviderRegistration#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_provider_registration#update ResourceProviderRegistration#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function resourceProviderRegistrationTimeoutsToTerraform(struct?: ResourceProviderRegistrationTimeoutsOutputReference | ResourceProviderRegistrationTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ResourceProviderRegistrationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ResourceProviderRegistrationTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ResourceProviderRegistrationTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/resource_provider_registration azurerm_resource_provider_registration}.
 *
 * @stability stable
 */
export declare class ResourceProviderRegistration extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/resource_provider_registration azurerm_resource_provider_registration} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ResourceProviderRegistrationConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _feature?;
    /**
     * @stability stable
     */
    get feature(): ResourceProviderRegistrationFeature[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set feature(value: ResourceProviderRegistrationFeature[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetFeature(): void;
    /**
     * @stability stable
     */
    get featureInput(): cdktf.IResolvable | ResourceProviderRegistrationFeature[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ResourceProviderRegistrationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ResourceProviderRegistrationTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ResourceProviderRegistrationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
