import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SentinelAlertRuleScheduledConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#alert_rule_template_guid SentinelAlertRuleScheduled#alert_rule_template_guid}.
     *
     * @stability stable
     */
    readonly alertRuleTemplateGuid?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#description SentinelAlertRuleScheduled#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#display_name SentinelAlertRuleScheduled#display_name}.
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#enabled SentinelAlertRuleScheduled#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#log_analytics_workspace_id SentinelAlertRuleScheduled#log_analytics_workspace_id}.
     *
     * @stability stable
     */
    readonly logAnalyticsWorkspaceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#name SentinelAlertRuleScheduled#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#query SentinelAlertRuleScheduled#query}.
     *
     * @stability stable
     */
    readonly query: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#query_frequency SentinelAlertRuleScheduled#query_frequency}.
     *
     * @stability stable
     */
    readonly queryFrequency?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#query_period SentinelAlertRuleScheduled#query_period}.
     *
     * @stability stable
     */
    readonly queryPeriod?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#severity SentinelAlertRuleScheduled#severity}.
     *
     * @stability stable
     */
    readonly severity: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#suppression_duration SentinelAlertRuleScheduled#suppression_duration}.
     *
     * @stability stable
     */
    readonly suppressionDuration?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#suppression_enabled SentinelAlertRuleScheduled#suppression_enabled}.
     *
     * @stability stable
     */
    readonly suppressionEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#tactics SentinelAlertRuleScheduled#tactics}.
     *
     * @stability stable
     */
    readonly tactics?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#trigger_operator SentinelAlertRuleScheduled#trigger_operator}.
     *
     * @stability stable
     */
    readonly triggerOperator?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#trigger_threshold SentinelAlertRuleScheduled#trigger_threshold}.
     *
     * @stability stable
     */
    readonly triggerThreshold?: number;
    /**
     * event_grouping block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#event_grouping SentinelAlertRuleScheduled#event_grouping}
     *
     * @stability stable
     */
    readonly eventGrouping?: SentinelAlertRuleScheduledEventGrouping;
    /**
     * incident_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#incident_configuration SentinelAlertRuleScheduled#incident_configuration}
     *
     * @stability stable
     */
    readonly incidentConfiguration?: SentinelAlertRuleScheduledIncidentConfiguration;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#timeouts SentinelAlertRuleScheduled#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SentinelAlertRuleScheduledTimeouts;
}
/**
 * @stability stable
 */
export interface SentinelAlertRuleScheduledEventGrouping {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#aggregation_method SentinelAlertRuleScheduled#aggregation_method}.
     *
     * @stability stable
     */
    readonly aggregationMethod: string;
}
export declare function sentinelAlertRuleScheduledEventGroupingToTerraform(struct?: SentinelAlertRuleScheduledEventGroupingOutputReference | SentinelAlertRuleScheduledEventGrouping): any;
/**
 * @stability stable
 */
export declare class SentinelAlertRuleScheduledEventGroupingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SentinelAlertRuleScheduledEventGrouping | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SentinelAlertRuleScheduledEventGrouping | undefined);
    private _aggregationMethod?;
    /**
     * @stability stable
     */
    get aggregationMethod(): string;
    /**
     * @stability stable
     */
    set aggregationMethod(value: string);
    /**
     * @stability stable
     */
    get aggregationMethodInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SentinelAlertRuleScheduledIncidentConfigurationGrouping {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#enabled SentinelAlertRuleScheduled#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#entity_matching_method SentinelAlertRuleScheduled#entity_matching_method}.
     *
     * @stability stable
     */
    readonly entityMatchingMethod?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#group_by SentinelAlertRuleScheduled#group_by}.
     *
     * @stability stable
     */
    readonly groupBy?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#lookback_duration SentinelAlertRuleScheduled#lookback_duration}.
     *
     * @stability stable
     */
    readonly lookbackDuration?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#reopen_closed_incidents SentinelAlertRuleScheduled#reopen_closed_incidents}.
     *
     * @stability stable
     */
    readonly reopenClosedIncidents?: boolean | cdktf.IResolvable;
}
export declare function sentinelAlertRuleScheduledIncidentConfigurationGroupingToTerraform(struct?: SentinelAlertRuleScheduledIncidentConfigurationGroupingOutputReference | SentinelAlertRuleScheduledIncidentConfigurationGrouping): any;
/**
 * @stability stable
 */
export declare class SentinelAlertRuleScheduledIncidentConfigurationGroupingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SentinelAlertRuleScheduledIncidentConfigurationGrouping | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SentinelAlertRuleScheduledIncidentConfigurationGrouping | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _entityMatchingMethod?;
    /**
     * @stability stable
     */
    get entityMatchingMethod(): string;
    /**
     * @stability stable
     */
    set entityMatchingMethod(value: string);
    /**
     * @stability stable
     */
    resetEntityMatchingMethod(): void;
    /**
     * @stability stable
     */
    get entityMatchingMethodInput(): string | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): string[];
    /**
     * @stability stable
     */
    set groupBy(value: string[]);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): string[] | undefined;
    private _lookbackDuration?;
    /**
     * @stability stable
     */
    get lookbackDuration(): string;
    /**
     * @stability stable
     */
    set lookbackDuration(value: string);
    /**
     * @stability stable
     */
    resetLookbackDuration(): void;
    /**
     * @stability stable
     */
    get lookbackDurationInput(): string | undefined;
    private _reopenClosedIncidents?;
    /**
     * @stability stable
     */
    get reopenClosedIncidents(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set reopenClosedIncidents(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetReopenClosedIncidents(): void;
    /**
     * @stability stable
     */
    get reopenClosedIncidentsInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface SentinelAlertRuleScheduledIncidentConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#create_incident SentinelAlertRuleScheduled#create_incident}.
     *
     * @stability stable
     */
    readonly createIncident: boolean | cdktf.IResolvable;
    /**
     * grouping block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#grouping SentinelAlertRuleScheduled#grouping}
     *
     * @stability stable
     */
    readonly grouping: SentinelAlertRuleScheduledIncidentConfigurationGrouping;
}
export declare function sentinelAlertRuleScheduledIncidentConfigurationToTerraform(struct?: SentinelAlertRuleScheduledIncidentConfigurationOutputReference | SentinelAlertRuleScheduledIncidentConfiguration): any;
/**
 * @stability stable
 */
export declare class SentinelAlertRuleScheduledIncidentConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SentinelAlertRuleScheduledIncidentConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SentinelAlertRuleScheduledIncidentConfiguration | undefined);
    private _createIncident?;
    /**
     * @stability stable
     */
    get createIncident(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set createIncident(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get createIncidentInput(): boolean | cdktf.IResolvable | undefined;
    private _grouping;
    /**
     * @stability stable
     */
    get grouping(): SentinelAlertRuleScheduledIncidentConfigurationGroupingOutputReference;
    /**
     * @stability stable
     */
    putGrouping(value: SentinelAlertRuleScheduledIncidentConfigurationGrouping): void;
    /**
     * @stability stable
     */
    get groupingInput(): SentinelAlertRuleScheduledIncidentConfigurationGrouping | undefined;
}
/**
 * @stability stable
 */
export interface SentinelAlertRuleScheduledTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#create SentinelAlertRuleScheduled#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#delete SentinelAlertRuleScheduled#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#read SentinelAlertRuleScheduled#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#update SentinelAlertRuleScheduled#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function sentinelAlertRuleScheduledTimeoutsToTerraform(struct?: SentinelAlertRuleScheduledTimeoutsOutputReference | SentinelAlertRuleScheduledTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class SentinelAlertRuleScheduledTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SentinelAlertRuleScheduledTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SentinelAlertRuleScheduledTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled azurerm_sentinel_alert_rule_scheduled}.
 *
 * @stability stable
 */
export declare class SentinelAlertRuleScheduled extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled azurerm_sentinel_alert_rule_scheduled} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SentinelAlertRuleScheduledConfig);
    private _alertRuleTemplateGuid?;
    /**
     * @stability stable
     */
    get alertRuleTemplateGuid(): string;
    /**
     * @stability stable
     */
    set alertRuleTemplateGuid(value: string);
    /**
     * @stability stable
     */
    resetAlertRuleTemplateGuid(): void;
    /**
     * @stability stable
     */
    get alertRuleTemplateGuidInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _logAnalyticsWorkspaceId?;
    /**
     * @stability stable
     */
    get logAnalyticsWorkspaceId(): string;
    /**
     * @stability stable
     */
    set logAnalyticsWorkspaceId(value: string);
    /**
     * @stability stable
     */
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
    private _queryFrequency?;
    /**
     * @stability stable
     */
    get queryFrequency(): string;
    /**
     * @stability stable
     */
    set queryFrequency(value: string);
    /**
     * @stability stable
     */
    resetQueryFrequency(): void;
    /**
     * @stability stable
     */
    get queryFrequencyInput(): string | undefined;
    private _queryPeriod?;
    /**
     * @stability stable
     */
    get queryPeriod(): string;
    /**
     * @stability stable
     */
    set queryPeriod(value: string);
    /**
     * @stability stable
     */
    resetQueryPeriod(): void;
    /**
     * @stability stable
     */
    get queryPeriodInput(): string | undefined;
    private _severity?;
    /**
     * @stability stable
     */
    get severity(): string;
    /**
     * @stability stable
     */
    set severity(value: string);
    /**
     * @stability stable
     */
    get severityInput(): string | undefined;
    private _suppressionDuration?;
    /**
     * @stability stable
     */
    get suppressionDuration(): string;
    /**
     * @stability stable
     */
    set suppressionDuration(value: string);
    /**
     * @stability stable
     */
    resetSuppressionDuration(): void;
    /**
     * @stability stable
     */
    get suppressionDurationInput(): string | undefined;
    private _suppressionEnabled?;
    /**
     * @stability stable
     */
    get suppressionEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set suppressionEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSuppressionEnabled(): void;
    /**
     * @stability stable
     */
    get suppressionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tactics?;
    /**
     * @stability stable
     */
    get tactics(): string[];
    /**
     * @stability stable
     */
    set tactics(value: string[]);
    /**
     * @stability stable
     */
    resetTactics(): void;
    /**
     * @stability stable
     */
    get tacticsInput(): string[] | undefined;
    private _triggerOperator?;
    /**
     * @stability stable
     */
    get triggerOperator(): string;
    /**
     * @stability stable
     */
    set triggerOperator(value: string);
    /**
     * @stability stable
     */
    resetTriggerOperator(): void;
    /**
     * @stability stable
     */
    get triggerOperatorInput(): string | undefined;
    private _triggerThreshold?;
    /**
     * @stability stable
     */
    get triggerThreshold(): number;
    /**
     * @stability stable
     */
    set triggerThreshold(value: number);
    /**
     * @stability stable
     */
    resetTriggerThreshold(): void;
    /**
     * @stability stable
     */
    get triggerThresholdInput(): number | undefined;
    private _eventGrouping;
    /**
     * @stability stable
     */
    get eventGrouping(): SentinelAlertRuleScheduledEventGroupingOutputReference;
    /**
     * @stability stable
     */
    putEventGrouping(value: SentinelAlertRuleScheduledEventGrouping): void;
    /**
     * @stability stable
     */
    resetEventGrouping(): void;
    /**
     * @stability stable
     */
    get eventGroupingInput(): SentinelAlertRuleScheduledEventGrouping | undefined;
    private _incidentConfiguration;
    /**
     * @stability stable
     */
    get incidentConfiguration(): SentinelAlertRuleScheduledIncidentConfigurationOutputReference;
    /**
     * @stability stable
     */
    putIncidentConfiguration(value: SentinelAlertRuleScheduledIncidentConfiguration): void;
    /**
     * @stability stable
     */
    resetIncidentConfiguration(): void;
    /**
     * @stability stable
     */
    get incidentConfigurationInput(): SentinelAlertRuleScheduledIncidentConfiguration | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SentinelAlertRuleScheduledTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SentinelAlertRuleScheduledTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SentinelAlertRuleScheduledTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
