import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ServiceFabricManagedClusterConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#backup_service_enabled ServiceFabricManagedCluster#backup_service_enabled}.
     *
     * @stability stable
     */
    readonly backupServiceEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#client_connection_port ServiceFabricManagedCluster#client_connection_port}.
     *
     * @stability stable
     */
    readonly clientConnectionPort: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#dns_name ServiceFabricManagedCluster#dns_name}.
     *
     * @stability stable
     */
    readonly dnsName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#dns_service_enabled ServiceFabricManagedCluster#dns_service_enabled}.
     *
     * @stability stable
     */
    readonly dnsServiceEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#http_gateway_port ServiceFabricManagedCluster#http_gateway_port}.
     *
     * @stability stable
     */
    readonly httpGatewayPort: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#location ServiceFabricManagedCluster#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#name ServiceFabricManagedCluster#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#password ServiceFabricManagedCluster#password}.
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#resource_group_name ServiceFabricManagedCluster#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#sku ServiceFabricManagedCluster#sku}.
     *
     * @stability stable
     */
    readonly sku?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#tags ServiceFabricManagedCluster#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#upgrade_wave ServiceFabricManagedCluster#upgrade_wave}.
     *
     * @stability stable
     */
    readonly upgradeWave?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#username ServiceFabricManagedCluster#username}.
     *
     * @stability stable
     */
    readonly username?: string;
    /**
     * authentication block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#authentication ServiceFabricManagedCluster#authentication}
     *
     * @stability stable
     */
    readonly authentication?: ServiceFabricManagedClusterAuthentication;
    /**
     * custom_fabric_setting block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#custom_fabric_setting ServiceFabricManagedCluster#custom_fabric_setting}
     *
     * @stability stable
     */
    readonly customFabricSetting?: ServiceFabricManagedClusterCustomFabricSetting[] | cdktf.IResolvable;
    /**
     * lb_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#lb_rule ServiceFabricManagedCluster#lb_rule}
     *
     * @stability stable
     */
    readonly lbRule: ServiceFabricManagedClusterLbRule[] | cdktf.IResolvable;
    /**
     * node_type block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#node_type ServiceFabricManagedCluster#node_type}
     *
     * @stability stable
     */
    readonly nodeType?: ServiceFabricManagedClusterNodeType[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#timeouts ServiceFabricManagedCluster#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ServiceFabricManagedClusterTimeouts;
}
/**
 * @stability stable
 */
export interface ServiceFabricManagedClusterAuthenticationActiveDirectory {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#client_application_id ServiceFabricManagedCluster#client_application_id}.
     *
     * @stability stable
     */
    readonly clientApplicationId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#cluster_application_id ServiceFabricManagedCluster#cluster_application_id}.
     *
     * @stability stable
     */
    readonly clusterApplicationId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#tenant_id ServiceFabricManagedCluster#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId: string;
}
export declare function serviceFabricManagedClusterAuthenticationActiveDirectoryToTerraform(struct?: ServiceFabricManagedClusterAuthenticationActiveDirectoryOutputReference | ServiceFabricManagedClusterAuthenticationActiveDirectory): any;
/**
 * @stability stable
 */
export declare class ServiceFabricManagedClusterAuthenticationActiveDirectoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServiceFabricManagedClusterAuthenticationActiveDirectory | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServiceFabricManagedClusterAuthenticationActiveDirectory | undefined);
    private _clientApplicationId?;
    /**
     * @stability stable
     */
    get clientApplicationId(): string;
    /**
     * @stability stable
     */
    set clientApplicationId(value: string);
    /**
     * @stability stable
     */
    get clientApplicationIdInput(): string | undefined;
    private _clusterApplicationId?;
    /**
     * @stability stable
     */
    get clusterApplicationId(): string;
    /**
     * @stability stable
     */
    set clusterApplicationId(value: string);
    /**
     * @stability stable
     */
    get clusterApplicationIdInput(): string | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    set tenantId(value: string);
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ServiceFabricManagedClusterAuthenticationCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#common_name ServiceFabricManagedCluster#common_name}.
     *
     * @stability stable
     */
    readonly commonName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#thumbprint ServiceFabricManagedCluster#thumbprint}.
     *
     * @stability stable
     */
    readonly thumbprint: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#type ServiceFabricManagedCluster#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function serviceFabricManagedClusterAuthenticationCertificateToTerraform(struct?: ServiceFabricManagedClusterAuthenticationCertificate | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ServiceFabricManagedClusterAuthentication {
    /**
     * active_directory block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#active_directory ServiceFabricManagedCluster#active_directory}
     *
     * @stability stable
     */
    readonly activeDirectory?: ServiceFabricManagedClusterAuthenticationActiveDirectory;
    /**
     * certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#certificate ServiceFabricManagedCluster#certificate}
     *
     * @stability stable
     */
    readonly certificate?: ServiceFabricManagedClusterAuthenticationCertificate[] | cdktf.IResolvable;
}
export declare function serviceFabricManagedClusterAuthenticationToTerraform(struct?: ServiceFabricManagedClusterAuthenticationOutputReference | ServiceFabricManagedClusterAuthentication): any;
/**
 * @stability stable
 */
export declare class ServiceFabricManagedClusterAuthenticationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServiceFabricManagedClusterAuthentication | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServiceFabricManagedClusterAuthentication | undefined);
    private _activeDirectory;
    /**
     * @stability stable
     */
    get activeDirectory(): ServiceFabricManagedClusterAuthenticationActiveDirectoryOutputReference;
    /**
     * @stability stable
     */
    putActiveDirectory(value: ServiceFabricManagedClusterAuthenticationActiveDirectory): void;
    /**
     * @stability stable
     */
    resetActiveDirectory(): void;
    /**
     * @stability stable
     */
    get activeDirectoryInput(): ServiceFabricManagedClusterAuthenticationActiveDirectory | undefined;
    private _certificate?;
    /**
     * @stability stable
     */
    get certificate(): ServiceFabricManagedClusterAuthenticationCertificate[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set certificate(value: ServiceFabricManagedClusterAuthenticationCertificate[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCertificate(): void;
    /**
     * @stability stable
     */
    get certificateInput(): cdktf.IResolvable | ServiceFabricManagedClusterAuthenticationCertificate[] | undefined;
}
/**
 * @stability stable
 */
export interface ServiceFabricManagedClusterCustomFabricSetting {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#parameter ServiceFabricManagedCluster#parameter}.
     *
     * @stability stable
     */
    readonly parameter: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#section ServiceFabricManagedCluster#section}.
     *
     * @stability stable
     */
    readonly section: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#value ServiceFabricManagedCluster#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function serviceFabricManagedClusterCustomFabricSettingToTerraform(struct?: ServiceFabricManagedClusterCustomFabricSetting | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ServiceFabricManagedClusterLbRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#backend_port ServiceFabricManagedCluster#backend_port}.
     *
     * @stability stable
     */
    readonly backendPort: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#frontend_port ServiceFabricManagedCluster#frontend_port}.
     *
     * @stability stable
     */
    readonly frontendPort: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#probe_protocol ServiceFabricManagedCluster#probe_protocol}.
     *
     * @stability stable
     */
    readonly probeProtocol: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#probe_request_path ServiceFabricManagedCluster#probe_request_path}.
     *
     * @stability stable
     */
    readonly probeRequestPath?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#protocol ServiceFabricManagedCluster#protocol}.
     *
     * @stability stable
     */
    readonly protocol: string;
}
export declare function serviceFabricManagedClusterLbRuleToTerraform(struct?: ServiceFabricManagedClusterLbRule | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ServiceFabricManagedClusterNodeTypeVmSecretsCertificates {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#store ServiceFabricManagedCluster#store}.
     *
     * @stability stable
     */
    readonly store: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#url ServiceFabricManagedCluster#url}.
     *
     * @stability stable
     */
    readonly url: string;
}
export declare function serviceFabricManagedClusterNodeTypeVmSecretsCertificatesToTerraform(struct?: ServiceFabricManagedClusterNodeTypeVmSecretsCertificates | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ServiceFabricManagedClusterNodeTypeVmSecrets {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#vault_id ServiceFabricManagedCluster#vault_id}.
     *
     * @stability stable
     */
    readonly vaultId: string;
    /**
     * certificates block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#certificates ServiceFabricManagedCluster#certificates}
     *
     * @stability stable
     */
    readonly certificates: ServiceFabricManagedClusterNodeTypeVmSecretsCertificates[] | cdktf.IResolvable;
}
export declare function serviceFabricManagedClusterNodeTypeVmSecretsToTerraform(struct?: ServiceFabricManagedClusterNodeTypeVmSecrets | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ServiceFabricManagedClusterNodeType {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#application_port_range ServiceFabricManagedCluster#application_port_range}.
     *
     * @stability stable
     */
    readonly applicationPortRange: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#capacities ServiceFabricManagedCluster#capacities}.
     *
     * @stability stable
     */
    readonly capacities?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#data_disk_size_gb ServiceFabricManagedCluster#data_disk_size_gb}.
     *
     * @stability stable
     */
    readonly dataDiskSizeGb: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#data_disk_type ServiceFabricManagedCluster#data_disk_type}.
     *
     * @stability stable
     */
    readonly dataDiskType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#ephemeral_port_range ServiceFabricManagedCluster#ephemeral_port_range}.
     *
     * @stability stable
     */
    readonly ephemeralPortRange: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#multiple_placement_groups_enabled ServiceFabricManagedCluster#multiple_placement_groups_enabled}.
     *
     * @stability stable
     */
    readonly multiplePlacementGroupsEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#name ServiceFabricManagedCluster#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#placement_properties ServiceFabricManagedCluster#placement_properties}.
     *
     * @stability stable
     */
    readonly placementProperties?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#primary ServiceFabricManagedCluster#primary}.
     *
     * @stability stable
     */
    readonly primary?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#stateless ServiceFabricManagedCluster#stateless}.
     *
     * @stability stable
     */
    readonly stateless?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#vm_image_offer ServiceFabricManagedCluster#vm_image_offer}.
     *
     * @stability stable
     */
    readonly vmImageOffer: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#vm_image_publisher ServiceFabricManagedCluster#vm_image_publisher}.
     *
     * @stability stable
     */
    readonly vmImagePublisher: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#vm_image_sku ServiceFabricManagedCluster#vm_image_sku}.
     *
     * @stability stable
     */
    readonly vmImageSku: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#vm_image_version ServiceFabricManagedCluster#vm_image_version}.
     *
     * @stability stable
     */
    readonly vmImageVersion: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#vm_instance_count ServiceFabricManagedCluster#vm_instance_count}.
     *
     * @stability stable
     */
    readonly vmInstanceCount: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#vm_size ServiceFabricManagedCluster#vm_size}.
     *
     * @stability stable
     */
    readonly vmSize: string;
    /**
     * vm_secrets block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#vm_secrets ServiceFabricManagedCluster#vm_secrets}
     *
     * @stability stable
     */
    readonly vmSecrets?: ServiceFabricManagedClusterNodeTypeVmSecrets[] | cdktf.IResolvable;
}
export declare function serviceFabricManagedClusterNodeTypeToTerraform(struct?: ServiceFabricManagedClusterNodeType | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ServiceFabricManagedClusterTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#create ServiceFabricManagedCluster#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#delete ServiceFabricManagedCluster#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#read ServiceFabricManagedCluster#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster#update ServiceFabricManagedCluster#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function serviceFabricManagedClusterTimeoutsToTerraform(struct?: ServiceFabricManagedClusterTimeoutsOutputReference | ServiceFabricManagedClusterTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ServiceFabricManagedClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServiceFabricManagedClusterTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServiceFabricManagedClusterTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster azurerm_service_fabric_managed_cluster}.
 *
 * @stability stable
 */
export declare class ServiceFabricManagedCluster extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster azurerm_service_fabric_managed_cluster} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ServiceFabricManagedClusterConfig);
    private _backupServiceEnabled?;
    /**
     * @stability stable
     */
    get backupServiceEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set backupServiceEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetBackupServiceEnabled(): void;
    /**
     * @stability stable
     */
    get backupServiceEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _clientConnectionPort?;
    /**
     * @stability stable
     */
    get clientConnectionPort(): number;
    /**
     * @stability stable
     */
    set clientConnectionPort(value: number);
    /**
     * @stability stable
     */
    get clientConnectionPortInput(): number | undefined;
    private _dnsName?;
    /**
     * @stability stable
     */
    get dnsName(): string;
    /**
     * @stability stable
     */
    set dnsName(value: string);
    /**
     * @stability stable
     */
    resetDnsName(): void;
    /**
     * @stability stable
     */
    get dnsNameInput(): string | undefined;
    private _dnsServiceEnabled?;
    /**
     * @stability stable
     */
    get dnsServiceEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dnsServiceEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDnsServiceEnabled(): void;
    /**
     * @stability stable
     */
    get dnsServiceEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _httpGatewayPort?;
    /**
     * @stability stable
     */
    get httpGatewayPort(): number;
    /**
     * @stability stable
     */
    set httpGatewayPort(value: number);
    /**
     * @stability stable
     */
    get httpGatewayPortInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _sku?;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    set sku(value: string);
    /**
     * @stability stable
     */
    resetSku(): void;
    /**
     * @stability stable
     */
    get skuInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _upgradeWave?;
    /**
     * @stability stable
     */
    get upgradeWave(): string;
    /**
     * @stability stable
     */
    set upgradeWave(value: string);
    /**
     * @stability stable
     */
    resetUpgradeWave(): void;
    /**
     * @stability stable
     */
    get upgradeWaveInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    resetUsername(): void;
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
    private _authentication;
    /**
     * @stability stable
     */
    get authentication(): ServiceFabricManagedClusterAuthenticationOutputReference;
    /**
     * @stability stable
     */
    putAuthentication(value: ServiceFabricManagedClusterAuthentication): void;
    /**
     * @stability stable
     */
    resetAuthentication(): void;
    /**
     * @stability stable
     */
    get authenticationInput(): ServiceFabricManagedClusterAuthentication | undefined;
    private _customFabricSetting?;
    /**
     * @stability stable
     */
    get customFabricSetting(): ServiceFabricManagedClusterCustomFabricSetting[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set customFabricSetting(value: ServiceFabricManagedClusterCustomFabricSetting[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCustomFabricSetting(): void;
    /**
     * @stability stable
     */
    get customFabricSettingInput(): cdktf.IResolvable | ServiceFabricManagedClusterCustomFabricSetting[] | undefined;
    private _lbRule?;
    /**
     * @stability stable
     */
    get lbRule(): ServiceFabricManagedClusterLbRule[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set lbRule(value: ServiceFabricManagedClusterLbRule[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get lbRuleInput(): cdktf.IResolvable | ServiceFabricManagedClusterLbRule[] | undefined;
    private _nodeType?;
    /**
     * @stability stable
     */
    get nodeType(): ServiceFabricManagedClusterNodeType[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set nodeType(value: ServiceFabricManagedClusterNodeType[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNodeType(): void;
    /**
     * @stability stable
     */
    get nodeTypeInput(): cdktf.IResolvable | ServiceFabricManagedClusterNodeType[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ServiceFabricManagedClusterTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ServiceFabricManagedClusterTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ServiceFabricManagedClusterTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
