import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SharedImageConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image#description SharedImage#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image#eula SharedImage#eula}.
     *
     * @stability stable
     */
    readonly eula?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image#gallery_name SharedImage#gallery_name}.
     *
     * @stability stable
     */
    readonly galleryName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image#hyper_v_generation SharedImage#hyper_v_generation}.
     *
     * @stability stable
     */
    readonly hyperVGeneration?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image#location SharedImage#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image#name SharedImage#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image#os_type SharedImage#os_type}.
     *
     * @stability stable
     */
    readonly osType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image#privacy_statement_uri SharedImage#privacy_statement_uri}.
     *
     * @stability stable
     */
    readonly privacyStatementUri?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image#release_note_uri SharedImage#release_note_uri}.
     *
     * @stability stable
     */
    readonly releaseNoteUri?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image#resource_group_name SharedImage#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image#specialized SharedImage#specialized}.
     *
     * @stability stable
     */
    readonly specialized?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image#tags SharedImage#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image#trusted_launch_enabled SharedImage#trusted_launch_enabled}.
     *
     * @stability stable
     */
    readonly trustedLaunchEnabled?: boolean | cdktf.IResolvable;
    /**
     * identifier block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image#identifier SharedImage#identifier}
     *
     * @stability stable
     */
    readonly identifier: SharedImageIdentifier;
    /**
     * purchase_plan block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image#purchase_plan SharedImage#purchase_plan}
     *
     * @stability stable
     */
    readonly purchasePlan?: SharedImagePurchasePlan;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image#timeouts SharedImage#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SharedImageTimeouts;
}
/**
 * @stability stable
 */
export interface SharedImageIdentifier {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image#offer SharedImage#offer}.
     *
     * @stability stable
     */
    readonly offer: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image#publisher SharedImage#publisher}.
     *
     * @stability stable
     */
    readonly publisher: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image#sku SharedImage#sku}.
     *
     * @stability stable
     */
    readonly sku: string;
}
export declare function sharedImageIdentifierToTerraform(struct?: SharedImageIdentifierOutputReference | SharedImageIdentifier): any;
/**
 * @stability stable
 */
export declare class SharedImageIdentifierOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SharedImageIdentifier | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SharedImageIdentifier | undefined);
    private _offer?;
    /**
     * @stability stable
     */
    get offer(): string;
    /**
     * @stability stable
     */
    set offer(value: string);
    /**
     * @stability stable
     */
    get offerInput(): string | undefined;
    private _publisher?;
    /**
     * @stability stable
     */
    get publisher(): string;
    /**
     * @stability stable
     */
    set publisher(value: string);
    /**
     * @stability stable
     */
    get publisherInput(): string | undefined;
    private _sku?;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    set sku(value: string);
    /**
     * @stability stable
     */
    get skuInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SharedImagePurchasePlan {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image#name SharedImage#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image#product SharedImage#product}.
     *
     * @stability stable
     */
    readonly product?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image#publisher SharedImage#publisher}.
     *
     * @stability stable
     */
    readonly publisher?: string;
}
export declare function sharedImagePurchasePlanToTerraform(struct?: SharedImagePurchasePlanOutputReference | SharedImagePurchasePlan): any;
/**
 * @stability stable
 */
export declare class SharedImagePurchasePlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SharedImagePurchasePlan | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SharedImagePurchasePlan | undefined);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _product?;
    /**
     * @stability stable
     */
    get product(): string;
    /**
     * @stability stable
     */
    set product(value: string);
    /**
     * @stability stable
     */
    resetProduct(): void;
    /**
     * @stability stable
     */
    get productInput(): string | undefined;
    private _publisher?;
    /**
     * @stability stable
     */
    get publisher(): string;
    /**
     * @stability stable
     */
    set publisher(value: string);
    /**
     * @stability stable
     */
    resetPublisher(): void;
    /**
     * @stability stable
     */
    get publisherInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SharedImageTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image#create SharedImage#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image#delete SharedImage#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image#read SharedImage#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image#update SharedImage#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function sharedImageTimeoutsToTerraform(struct?: SharedImageTimeoutsOutputReference | SharedImageTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class SharedImageTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SharedImageTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SharedImageTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image azurerm_shared_image}.
 *
 * @stability stable
 */
export declare class SharedImage extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/shared_image azurerm_shared_image} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SharedImageConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _eula?;
    /**
     * @stability stable
     */
    get eula(): string;
    /**
     * @stability stable
     */
    set eula(value: string);
    /**
     * @stability stable
     */
    resetEula(): void;
    /**
     * @stability stable
     */
    get eulaInput(): string | undefined;
    private _galleryName?;
    /**
     * @stability stable
     */
    get galleryName(): string;
    /**
     * @stability stable
     */
    set galleryName(value: string);
    /**
     * @stability stable
     */
    get galleryNameInput(): string | undefined;
    private _hyperVGeneration?;
    /**
     * @stability stable
     */
    get hyperVGeneration(): string;
    /**
     * @stability stable
     */
    set hyperVGeneration(value: string);
    /**
     * @stability stable
     */
    resetHyperVGeneration(): void;
    /**
     * @stability stable
     */
    get hyperVGenerationInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _osType?;
    /**
     * @stability stable
     */
    get osType(): string;
    /**
     * @stability stable
     */
    set osType(value: string);
    /**
     * @stability stable
     */
    get osTypeInput(): string | undefined;
    private _privacyStatementUri?;
    /**
     * @stability stable
     */
    get privacyStatementUri(): string;
    /**
     * @stability stable
     */
    set privacyStatementUri(value: string);
    /**
     * @stability stable
     */
    resetPrivacyStatementUri(): void;
    /**
     * @stability stable
     */
    get privacyStatementUriInput(): string | undefined;
    private _releaseNoteUri?;
    /**
     * @stability stable
     */
    get releaseNoteUri(): string;
    /**
     * @stability stable
     */
    set releaseNoteUri(value: string);
    /**
     * @stability stable
     */
    resetReleaseNoteUri(): void;
    /**
     * @stability stable
     */
    get releaseNoteUriInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _specialized?;
    /**
     * @stability stable
     */
    get specialized(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set specialized(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSpecialized(): void;
    /**
     * @stability stable
     */
    get specializedInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _trustedLaunchEnabled?;
    /**
     * @stability stable
     */
    get trustedLaunchEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set trustedLaunchEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTrustedLaunchEnabled(): void;
    /**
     * @stability stable
     */
    get trustedLaunchEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _identifier;
    /**
     * @stability stable
     */
    get identifier(): SharedImageIdentifierOutputReference;
    /**
     * @stability stable
     */
    putIdentifier(value: SharedImageIdentifier): void;
    /**
     * @stability stable
     */
    get identifierInput(): SharedImageIdentifier | undefined;
    private _purchasePlan;
    /**
     * @stability stable
     */
    get purchasePlan(): SharedImagePurchasePlanOutputReference;
    /**
     * @stability stable
     */
    putPurchasePlan(value: SharedImagePurchasePlan): void;
    /**
     * @stability stable
     */
    resetPurchasePlan(): void;
    /**
     * @stability stable
     */
    get purchasePlanInput(): SharedImagePurchasePlan | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SharedImageTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SharedImageTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SharedImageTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
