import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StorageBlobInventoryPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#storage_account_id StorageBlobInventoryPolicy#storage_account_id}.
     *
     * @stability stable
     */
    readonly storageAccountId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#storage_container_name StorageBlobInventoryPolicy#storage_container_name}.
     *
     * @stability stable
     */
    readonly storageContainerName: string;
    /**
     * rules block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#rules StorageBlobInventoryPolicy#rules}
     *
     * @stability stable
     */
    readonly rules: StorageBlobInventoryPolicyRules[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#timeouts StorageBlobInventoryPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: StorageBlobInventoryPolicyTimeouts;
}
/**
 * @stability stable
 */
export interface StorageBlobInventoryPolicyRulesFilter {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#blob_types StorageBlobInventoryPolicy#blob_types}.
     *
     * @stability stable
     */
    readonly blobTypes: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#include_blob_versions StorageBlobInventoryPolicy#include_blob_versions}.
     *
     * @stability stable
     */
    readonly includeBlobVersions?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#include_snapshots StorageBlobInventoryPolicy#include_snapshots}.
     *
     * @stability stable
     */
    readonly includeSnapshots?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#prefix_match StorageBlobInventoryPolicy#prefix_match}.
     *
     * @stability stable
     */
    readonly prefixMatch?: string[];
}
export declare function storageBlobInventoryPolicyRulesFilterToTerraform(struct?: StorageBlobInventoryPolicyRulesFilterOutputReference | StorageBlobInventoryPolicyRulesFilter): any;
/**
 * @stability stable
 */
export declare class StorageBlobInventoryPolicyRulesFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageBlobInventoryPolicyRulesFilter | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageBlobInventoryPolicyRulesFilter | undefined);
    private _blobTypes?;
    /**
     * @stability stable
     */
    get blobTypes(): string[];
    /**
     * @stability stable
     */
    set blobTypes(value: string[]);
    /**
     * @stability stable
     */
    get blobTypesInput(): string[] | undefined;
    private _includeBlobVersions?;
    /**
     * @stability stable
     */
    get includeBlobVersions(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set includeBlobVersions(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIncludeBlobVersions(): void;
    /**
     * @stability stable
     */
    get includeBlobVersionsInput(): boolean | cdktf.IResolvable | undefined;
    private _includeSnapshots?;
    /**
     * @stability stable
     */
    get includeSnapshots(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set includeSnapshots(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIncludeSnapshots(): void;
    /**
     * @stability stable
     */
    get includeSnapshotsInput(): boolean | cdktf.IResolvable | undefined;
    private _prefixMatch?;
    /**
     * @stability stable
     */
    get prefixMatch(): string[];
    /**
     * @stability stable
     */
    set prefixMatch(value: string[]);
    /**
     * @stability stable
     */
    resetPrefixMatch(): void;
    /**
     * @stability stable
     */
    get prefixMatchInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface StorageBlobInventoryPolicyRules {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#name StorageBlobInventoryPolicy#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#filter StorageBlobInventoryPolicy#filter}
     *
     * @stability stable
     */
    readonly filter: StorageBlobInventoryPolicyRulesFilter;
}
export declare function storageBlobInventoryPolicyRulesToTerraform(struct?: StorageBlobInventoryPolicyRules | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface StorageBlobInventoryPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#create StorageBlobInventoryPolicy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#delete StorageBlobInventoryPolicy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#read StorageBlobInventoryPolicy#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy#update StorageBlobInventoryPolicy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function storageBlobInventoryPolicyTimeoutsToTerraform(struct?: StorageBlobInventoryPolicyTimeoutsOutputReference | StorageBlobInventoryPolicyTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class StorageBlobInventoryPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageBlobInventoryPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageBlobInventoryPolicyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy azurerm_storage_blob_inventory_policy}.
 *
 * @stability stable
 */
export declare class StorageBlobInventoryPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob_inventory_policy azurerm_storage_blob_inventory_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StorageBlobInventoryPolicyConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _storageAccountId?;
    /**
     * @stability stable
     */
    get storageAccountId(): string;
    /**
     * @stability stable
     */
    set storageAccountId(value: string);
    /**
     * @stability stable
     */
    get storageAccountIdInput(): string | undefined;
    private _storageContainerName?;
    /**
     * @stability stable
     */
    get storageContainerName(): string;
    /**
     * @stability stable
     */
    set storageContainerName(value: string);
    /**
     * @stability stable
     */
    get storageContainerNameInput(): string | undefined;
    private _rules?;
    /**
     * @stability stable
     */
    get rules(): StorageBlobInventoryPolicyRules[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set rules(value: StorageBlobInventoryPolicyRules[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get rulesInput(): cdktf.IResolvable | StorageBlobInventoryPolicyRules[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): StorageBlobInventoryPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: StorageBlobInventoryPolicyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): StorageBlobInventoryPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
