import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StorageEncryptionScopeConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_encryption_scope#infrastructure_encryption_required StorageEncryptionScope#infrastructure_encryption_required}.
     *
     * @stability stable
     */
    readonly infrastructureEncryptionRequired?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_encryption_scope#key_vault_key_id StorageEncryptionScope#key_vault_key_id}.
     *
     * @stability stable
     */
    readonly keyVaultKeyId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_encryption_scope#name StorageEncryptionScope#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_encryption_scope#source StorageEncryptionScope#source}.
     *
     * @stability stable
     */
    readonly source: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_encryption_scope#storage_account_id StorageEncryptionScope#storage_account_id}.
     *
     * @stability stable
     */
    readonly storageAccountId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_encryption_scope#timeouts StorageEncryptionScope#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: StorageEncryptionScopeTimeouts;
}
/**
 * @stability stable
 */
export interface StorageEncryptionScopeTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_encryption_scope#create StorageEncryptionScope#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_encryption_scope#delete StorageEncryptionScope#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_encryption_scope#read StorageEncryptionScope#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_encryption_scope#update StorageEncryptionScope#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function storageEncryptionScopeTimeoutsToTerraform(struct?: StorageEncryptionScopeTimeoutsOutputReference | StorageEncryptionScopeTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class StorageEncryptionScopeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageEncryptionScopeTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageEncryptionScopeTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/storage_encryption_scope azurerm_storage_encryption_scope}.
 *
 * @stability stable
 */
export declare class StorageEncryptionScope extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/storage_encryption_scope azurerm_storage_encryption_scope} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StorageEncryptionScopeConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _infrastructureEncryptionRequired?;
    /**
     * @stability stable
     */
    get infrastructureEncryptionRequired(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set infrastructureEncryptionRequired(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetInfrastructureEncryptionRequired(): void;
    /**
     * @stability stable
     */
    get infrastructureEncryptionRequiredInput(): boolean | cdktf.IResolvable | undefined;
    private _keyVaultKeyId?;
    /**
     * @stability stable
     */
    get keyVaultKeyId(): string;
    /**
     * @stability stable
     */
    set keyVaultKeyId(value: string);
    /**
     * @stability stable
     */
    resetKeyVaultKeyId(): void;
    /**
     * @stability stable
     */
    get keyVaultKeyIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _source?;
    /**
     * @stability stable
     */
    get source(): string;
    /**
     * @stability stable
     */
    set source(value: string);
    /**
     * @stability stable
     */
    get sourceInput(): string | undefined;
    private _storageAccountId?;
    /**
     * @stability stable
     */
    get storageAccountId(): string;
    /**
     * @stability stable
     */
    set storageAccountId(value: string);
    /**
     * @stability stable
     */
    get storageAccountIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): StorageEncryptionScopeTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: StorageEncryptionScopeTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): StorageEncryptionScopeTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
