import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
     * The Alias Name of the subscription. If omitted a new UUID will be generated for this property.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription#alias Subscription#alias}
     *
     * @stability stable
     */
    readonly alias?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription#billing_scope_id Subscription#billing_scope_id}.
     *
     * @stability stable
     */
    readonly billingScopeId?: string;
    /**
     * The GUID of the Subscription.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription#subscription_id Subscription#subscription_id}
     *
     * @stability stable
     */
    readonly subscriptionId?: string;
    /**
     * The Display Name for the Subscription.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription#subscription_name Subscription#subscription_name}
     *
     * @stability stable
     */
    readonly subscriptionName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription#tags Subscription#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * The workload type for the Subscription. Possible values are `Production` (default) and `DevTest`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription#workload Subscription#workload}
     *
     * @stability stable
     */
    readonly workload?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription#timeouts Subscription#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SubscriptionTimeouts;
}
/**
 * @stability stable
 */
export interface SubscriptionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription#create Subscription#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription#delete Subscription#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription#read Subscription#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription#update Subscription#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function subscriptionTimeoutsToTerraform(struct?: SubscriptionTimeoutsOutputReference | SubscriptionTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class SubscriptionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SubscriptionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SubscriptionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/subscription azurerm_subscription}.
 *
 * @stability stable
 */
export declare class Subscription extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/subscription azurerm_subscription} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SubscriptionConfig);
    private _alias?;
    /**
     * @stability stable
     */
    get alias(): string;
    /**
     * @stability stable
     */
    set alias(value: string);
    /**
     * @stability stable
     */
    resetAlias(): void;
    /**
     * @stability stable
     */
    get aliasInput(): string | undefined;
    private _billingScopeId?;
    /**
     * @stability stable
     */
    get billingScopeId(): string;
    /**
     * @stability stable
     */
    set billingScopeId(value: string);
    /**
     * @stability stable
     */
    resetBillingScopeId(): void;
    /**
     * @stability stable
     */
    get billingScopeIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _subscriptionId?;
    /**
     * @stability stable
     */
    get subscriptionId(): string;
    /**
     * @stability stable
     */
    set subscriptionId(value: string);
    /**
     * @stability stable
     */
    resetSubscriptionId(): void;
    /**
     * @stability stable
     */
    get subscriptionIdInput(): string | undefined;
    private _subscriptionName?;
    /**
     * @stability stable
     */
    get subscriptionName(): string;
    /**
     * @stability stable
     */
    set subscriptionName(value: string);
    /**
     * @stability stable
     */
    get subscriptionNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get tenantId(): string;
    private _workload?;
    /**
     * @stability stable
     */
    get workload(): string;
    /**
     * @stability stable
     */
    set workload(value: string);
    /**
     * @stability stable
     */
    resetWorkload(): void;
    /**
     * @stability stable
     */
    get workloadInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SubscriptionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SubscriptionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SubscriptionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
