import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface TrafficManagerAzureEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#enabled TrafficManagerAzureEndpoint#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#geo_mappings TrafficManagerAzureEndpoint#geo_mappings}.
     *
     * @stability stable
     */
    readonly geoMappings?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#name TrafficManagerAzureEndpoint#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#priority TrafficManagerAzureEndpoint#priority}.
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#profile_id TrafficManagerAzureEndpoint#profile_id}.
     *
     * @stability stable
     */
    readonly profileId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#target_resource_id TrafficManagerAzureEndpoint#target_resource_id}.
     *
     * @stability stable
     */
    readonly targetResourceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#weight TrafficManagerAzureEndpoint#weight}.
     *
     * @stability stable
     */
    readonly weight: number;
    /**
     * custom_header block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#custom_header TrafficManagerAzureEndpoint#custom_header}
     *
     * @stability stable
     */
    readonly customHeader?: TrafficManagerAzureEndpointCustomHeader[] | cdktf.IResolvable;
    /**
     * subnet block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#subnet TrafficManagerAzureEndpoint#subnet}
     *
     * @stability stable
     */
    readonly subnet?: TrafficManagerAzureEndpointSubnet[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#timeouts TrafficManagerAzureEndpoint#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: TrafficManagerAzureEndpointTimeouts;
}
/**
 * @stability stable
 */
export interface TrafficManagerAzureEndpointCustomHeader {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#name TrafficManagerAzureEndpoint#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#value TrafficManagerAzureEndpoint#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function trafficManagerAzureEndpointCustomHeaderToTerraform(struct?: TrafficManagerAzureEndpointCustomHeader | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface TrafficManagerAzureEndpointSubnet {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#first TrafficManagerAzureEndpoint#first}.
     *
     * @stability stable
     */
    readonly first: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#last TrafficManagerAzureEndpoint#last}.
     *
     * @stability stable
     */
    readonly last?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#scope TrafficManagerAzureEndpoint#scope}.
     *
     * @stability stable
     */
    readonly scope?: number;
}
export declare function trafficManagerAzureEndpointSubnetToTerraform(struct?: TrafficManagerAzureEndpointSubnet | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface TrafficManagerAzureEndpointTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#create TrafficManagerAzureEndpoint#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#delete TrafficManagerAzureEndpoint#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#read TrafficManagerAzureEndpoint#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#update TrafficManagerAzureEndpoint#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function trafficManagerAzureEndpointTimeoutsToTerraform(struct?: TrafficManagerAzureEndpointTimeoutsOutputReference | TrafficManagerAzureEndpointTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class TrafficManagerAzureEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): TrafficManagerAzureEndpointTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: TrafficManagerAzureEndpointTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint azurerm_traffic_manager_azure_endpoint}.
 *
 * @stability stable
 */
export declare class TrafficManagerAzureEndpoint extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint azurerm_traffic_manager_azure_endpoint} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: TrafficManagerAzureEndpointConfig);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _geoMappings?;
    /**
     * @stability stable
     */
    get geoMappings(): string[];
    /**
     * @stability stable
     */
    set geoMappings(value: string[]);
    /**
     * @stability stable
     */
    resetGeoMappings(): void;
    /**
     * @stability stable
     */
    get geoMappingsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): number;
    /**
     * @stability stable
     */
    set priority(value: number);
    /**
     * @stability stable
     */
    resetPriority(): void;
    /**
     * @stability stable
     */
    get priorityInput(): number | undefined;
    private _profileId?;
    /**
     * @stability stable
     */
    get profileId(): string;
    /**
     * @stability stable
     */
    set profileId(value: string);
    /**
     * @stability stable
     */
    get profileIdInput(): string | undefined;
    private _targetResourceId?;
    /**
     * @stability stable
     */
    get targetResourceId(): string;
    /**
     * @stability stable
     */
    set targetResourceId(value: string);
    /**
     * @stability stable
     */
    get targetResourceIdInput(): string | undefined;
    private _weight?;
    /**
     * @stability stable
     */
    get weight(): number;
    /**
     * @stability stable
     */
    set weight(value: number);
    /**
     * @stability stable
     */
    get weightInput(): number | undefined;
    private _customHeader?;
    /**
     * @stability stable
     */
    get customHeader(): TrafficManagerAzureEndpointCustomHeader[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set customHeader(value: TrafficManagerAzureEndpointCustomHeader[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCustomHeader(): void;
    /**
     * @stability stable
     */
    get customHeaderInput(): cdktf.IResolvable | TrafficManagerAzureEndpointCustomHeader[] | undefined;
    private _subnet?;
    /**
     * @stability stable
     */
    get subnet(): TrafficManagerAzureEndpointSubnet[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set subnet(value: TrafficManagerAzureEndpointSubnet[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSubnet(): void;
    /**
     * @stability stable
     */
    get subnetInput(): cdktf.IResolvable | TrafficManagerAzureEndpointSubnet[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): TrafficManagerAzureEndpointTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: TrafficManagerAzureEndpointTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): TrafficManagerAzureEndpointTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
