import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface TrafficManagerProfileConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_profile#max_return TrafficManagerProfile#max_return}.
     *
     * @stability stable
     */
    readonly maxReturn?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_profile#name TrafficManagerProfile#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_profile#profile_status TrafficManagerProfile#profile_status}.
     *
     * @stability stable
     */
    readonly profileStatus?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_profile#resource_group_name TrafficManagerProfile#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_profile#tags TrafficManagerProfile#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_profile#traffic_routing_method TrafficManagerProfile#traffic_routing_method}.
     *
     * @stability stable
     */
    readonly trafficRoutingMethod: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_profile#traffic_view_enabled TrafficManagerProfile#traffic_view_enabled}.
     *
     * @stability stable
     */
    readonly trafficViewEnabled?: boolean | cdktf.IResolvable;
    /**
     * dns_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_profile#dns_config TrafficManagerProfile#dns_config}
     *
     * @stability stable
     */
    readonly dnsConfig: TrafficManagerProfileDnsConfig;
    /**
     * monitor_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_profile#monitor_config TrafficManagerProfile#monitor_config}
     *
     * @stability stable
     */
    readonly monitorConfig: TrafficManagerProfileMonitorConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_profile#timeouts TrafficManagerProfile#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: TrafficManagerProfileTimeouts;
}
/**
 * @stability stable
 */
export interface TrafficManagerProfileDnsConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_profile#relative_name TrafficManagerProfile#relative_name}.
     *
     * @stability stable
     */
    readonly relativeName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_profile#ttl TrafficManagerProfile#ttl}.
     *
     * @stability stable
     */
    readonly ttl: number;
}
export declare function trafficManagerProfileDnsConfigToTerraform(struct?: TrafficManagerProfileDnsConfigOutputReference | TrafficManagerProfileDnsConfig): any;
/**
 * @stability stable
 */
export declare class TrafficManagerProfileDnsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): TrafficManagerProfileDnsConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: TrafficManagerProfileDnsConfig | undefined);
    private _relativeName?;
    /**
     * @stability stable
     */
    get relativeName(): string;
    /**
     * @stability stable
     */
    set relativeName(value: string);
    /**
     * @stability stable
     */
    get relativeNameInput(): string | undefined;
    private _ttl?;
    /**
     * @stability stable
     */
    get ttl(): number;
    /**
     * @stability stable
     */
    set ttl(value: number);
    /**
     * @stability stable
     */
    get ttlInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface TrafficManagerProfileMonitorConfigCustomHeader {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_profile#name TrafficManagerProfile#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_profile#value TrafficManagerProfile#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function trafficManagerProfileMonitorConfigCustomHeaderToTerraform(struct?: TrafficManagerProfileMonitorConfigCustomHeader | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface TrafficManagerProfileMonitorConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_profile#expected_status_code_ranges TrafficManagerProfile#expected_status_code_ranges}.
     *
     * @stability stable
     */
    readonly expectedStatusCodeRanges?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_profile#interval_in_seconds TrafficManagerProfile#interval_in_seconds}.
     *
     * @stability stable
     */
    readonly intervalInSeconds?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_profile#path TrafficManagerProfile#path}.
     *
     * @stability stable
     */
    readonly path?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_profile#port TrafficManagerProfile#port}.
     *
     * @stability stable
     */
    readonly port: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_profile#protocol TrafficManagerProfile#protocol}.
     *
     * @stability stable
     */
    readonly protocol: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_profile#timeout_in_seconds TrafficManagerProfile#timeout_in_seconds}.
     *
     * @stability stable
     */
    readonly timeoutInSeconds?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_profile#tolerated_number_of_failures TrafficManagerProfile#tolerated_number_of_failures}.
     *
     * @stability stable
     */
    readonly toleratedNumberOfFailures?: number;
    /**
     * custom_header block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_profile#custom_header TrafficManagerProfile#custom_header}
     *
     * @stability stable
     */
    readonly customHeader?: TrafficManagerProfileMonitorConfigCustomHeader[] | cdktf.IResolvable;
}
export declare function trafficManagerProfileMonitorConfigToTerraform(struct?: TrafficManagerProfileMonitorConfigOutputReference | TrafficManagerProfileMonitorConfig): any;
/**
 * @stability stable
 */
export declare class TrafficManagerProfileMonitorConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): TrafficManagerProfileMonitorConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: TrafficManagerProfileMonitorConfig | undefined);
    private _expectedStatusCodeRanges?;
    /**
     * @stability stable
     */
    get expectedStatusCodeRanges(): string[];
    /**
     * @stability stable
     */
    set expectedStatusCodeRanges(value: string[]);
    /**
     * @stability stable
     */
    resetExpectedStatusCodeRanges(): void;
    /**
     * @stability stable
     */
    get expectedStatusCodeRangesInput(): string[] | undefined;
    private _intervalInSeconds?;
    /**
     * @stability stable
     */
    get intervalInSeconds(): number;
    /**
     * @stability stable
     */
    set intervalInSeconds(value: number);
    /**
     * @stability stable
     */
    resetIntervalInSeconds(): void;
    /**
     * @stability stable
     */
    get intervalInSecondsInput(): number | undefined;
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    resetPath(): void;
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
    private _port?;
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    set port(value: number);
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    private _protocol?;
    /**
     * @stability stable
     */
    get protocol(): string;
    /**
     * @stability stable
     */
    set protocol(value: string);
    /**
     * @stability stable
     */
    get protocolInput(): string | undefined;
    private _timeoutInSeconds?;
    /**
     * @stability stable
     */
    get timeoutInSeconds(): number;
    /**
     * @stability stable
     */
    set timeoutInSeconds(value: number);
    /**
     * @stability stable
     */
    resetTimeoutInSeconds(): void;
    /**
     * @stability stable
     */
    get timeoutInSecondsInput(): number | undefined;
    private _toleratedNumberOfFailures?;
    /**
     * @stability stable
     */
    get toleratedNumberOfFailures(): number;
    /**
     * @stability stable
     */
    set toleratedNumberOfFailures(value: number);
    /**
     * @stability stable
     */
    resetToleratedNumberOfFailures(): void;
    /**
     * @stability stable
     */
    get toleratedNumberOfFailuresInput(): number | undefined;
    private _customHeader?;
    /**
     * @stability stable
     */
    get customHeader(): TrafficManagerProfileMonitorConfigCustomHeader[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set customHeader(value: TrafficManagerProfileMonitorConfigCustomHeader[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCustomHeader(): void;
    /**
     * @stability stable
     */
    get customHeaderInput(): cdktf.IResolvable | TrafficManagerProfileMonitorConfigCustomHeader[] | undefined;
}
/**
 * @stability stable
 */
export interface TrafficManagerProfileTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_profile#create TrafficManagerProfile#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_profile#delete TrafficManagerProfile#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_profile#read TrafficManagerProfile#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_profile#update TrafficManagerProfile#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function trafficManagerProfileTimeoutsToTerraform(struct?: TrafficManagerProfileTimeoutsOutputReference | TrafficManagerProfileTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class TrafficManagerProfileTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): TrafficManagerProfileTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: TrafficManagerProfileTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_profile azurerm_traffic_manager_profile}.
 *
 * @stability stable
 */
export declare class TrafficManagerProfile extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_profile azurerm_traffic_manager_profile} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: TrafficManagerProfileConfig);
    /**
     * @stability stable
     */
    get fqdn(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _maxReturn?;
    /**
     * @stability stable
     */
    get maxReturn(): number;
    /**
     * @stability stable
     */
    set maxReturn(value: number);
    /**
     * @stability stable
     */
    resetMaxReturn(): void;
    /**
     * @stability stable
     */
    get maxReturnInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _profileStatus?;
    /**
     * @stability stable
     */
    get profileStatus(): string;
    /**
     * @stability stable
     */
    set profileStatus(value: string);
    /**
     * @stability stable
     */
    resetProfileStatus(): void;
    /**
     * @stability stable
     */
    get profileStatusInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _trafficRoutingMethod?;
    /**
     * @stability stable
     */
    get trafficRoutingMethod(): string;
    /**
     * @stability stable
     */
    set trafficRoutingMethod(value: string);
    /**
     * @stability stable
     */
    get trafficRoutingMethodInput(): string | undefined;
    private _trafficViewEnabled?;
    /**
     * @stability stable
     */
    get trafficViewEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set trafficViewEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTrafficViewEnabled(): void;
    /**
     * @stability stable
     */
    get trafficViewEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dnsConfig;
    /**
     * @stability stable
     */
    get dnsConfig(): TrafficManagerProfileDnsConfigOutputReference;
    /**
     * @stability stable
     */
    putDnsConfig(value: TrafficManagerProfileDnsConfig): void;
    /**
     * @stability stable
     */
    get dnsConfigInput(): TrafficManagerProfileDnsConfig | undefined;
    private _monitorConfig;
    /**
     * @stability stable
     */
    get monitorConfig(): TrafficManagerProfileMonitorConfigOutputReference;
    /**
     * @stability stable
     */
    putMonitorConfig(value: TrafficManagerProfileMonitorConfig): void;
    /**
     * @stability stable
     */
    get monitorConfigInput(): TrafficManagerProfileMonitorConfig | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): TrafficManagerProfileTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: TrafficManagerProfileTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): TrafficManagerProfileTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
