import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface WebPubsubHubConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_hub#anonymous_connections_enabled WebPubsubHub#anonymous_connections_enabled}.
     *
     * @stability stable
     */
    readonly anonymousConnectionsEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_hub#name WebPubsubHub#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_hub#web_pubsub_id WebPubsubHub#web_pubsub_id}.
     *
     * @stability stable
     */
    readonly webPubsubId: string;
    /**
     * event_handler block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_hub#event_handler WebPubsubHub#event_handler}
     *
     * @stability stable
     */
    readonly eventHandler: WebPubsubHubEventHandler[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_hub#timeouts WebPubsubHub#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: WebPubsubHubTimeouts;
}
/**
 * @stability stable
 */
export interface WebPubsubHubEventHandlerAuth {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_hub#managed_identity_id WebPubsubHub#managed_identity_id}.
     *
     * @stability stable
     */
    readonly managedIdentityId: string;
}
export declare function webPubsubHubEventHandlerAuthToTerraform(struct?: WebPubsubHubEventHandlerAuthOutputReference | WebPubsubHubEventHandlerAuth): any;
/**
 * @stability stable
 */
export declare class WebPubsubHubEventHandlerAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): WebPubsubHubEventHandlerAuth | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: WebPubsubHubEventHandlerAuth | undefined);
    private _managedIdentityId?;
    /**
     * @stability stable
     */
    get managedIdentityId(): string;
    /**
     * @stability stable
     */
    set managedIdentityId(value: string);
    /**
     * @stability stable
     */
    get managedIdentityIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface WebPubsubHubEventHandler {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_hub#system_events WebPubsubHub#system_events}.
     *
     * @stability stable
     */
    readonly systemEvents?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_hub#url_template WebPubsubHub#url_template}.
     *
     * @stability stable
     */
    readonly urlTemplate: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_hub#user_event_pattern WebPubsubHub#user_event_pattern}.
     *
     * @stability stable
     */
    readonly userEventPattern?: string;
    /**
     * auth block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_hub#auth WebPubsubHub#auth}
     *
     * @stability stable
     */
    readonly auth?: WebPubsubHubEventHandlerAuth;
}
export declare function webPubsubHubEventHandlerToTerraform(struct?: WebPubsubHubEventHandler | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface WebPubsubHubTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_hub#create WebPubsubHub#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_hub#delete WebPubsubHub#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_hub#read WebPubsubHub#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_hub#update WebPubsubHub#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function webPubsubHubTimeoutsToTerraform(struct?: WebPubsubHubTimeoutsOutputReference | WebPubsubHubTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class WebPubsubHubTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): WebPubsubHubTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: WebPubsubHubTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_hub azurerm_web_pubsub_hub}.
 *
 * @stability stable
 */
export declare class WebPubsubHub extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_hub azurerm_web_pubsub_hub} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: WebPubsubHubConfig);
    private _anonymousConnectionsEnabled?;
    /**
     * @stability stable
     */
    get anonymousConnectionsEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set anonymousConnectionsEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAnonymousConnectionsEnabled(): void;
    /**
     * @stability stable
     */
    get anonymousConnectionsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _webPubsubId?;
    /**
     * @stability stable
     */
    get webPubsubId(): string;
    /**
     * @stability stable
     */
    set webPubsubId(value: string);
    /**
     * @stability stable
     */
    get webPubsubIdInput(): string | undefined;
    private _eventHandler?;
    /**
     * @stability stable
     */
    get eventHandler(): WebPubsubHubEventHandler[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set eventHandler(value: WebPubsubHubEventHandler[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get eventHandlerInput(): cdktf.IResolvable | WebPubsubHubEventHandler[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): WebPubsubHubTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: WebPubsubHubTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): WebPubsubHubTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
