# Thank you for opening a PR!


 A few important guidelines and requirements before we can merge your PR:

 - [ ] *If I add a new sampler*, there is an issue discussing it already;
 - [ ] We should be able to understand what the PR does from its title only;
 - [ ] There is a high-level description of the changes;
 - [ ] There are links to *all* the relevant issues, discussions and PRs;
 - [ ] The branch is rebased on the latest `main` commit;
 - [ ] Commit messages follow these [guidelines](https://tbaggery.com/2008/04/19/a-note-about-git-commit-messages.html);
 - [ ] The code respects the current naming conventions;
 - [ ] Docstrings follow the [numpy style guide](https://numpydoc.readthedocs.io/en/latest/format.html)
 - [ ] `pre-commit` is installed and configured on your machine, and you ran it before opening the PR;
 - [ ] There are tests covering the changes;
 - [ ] The doc is up-to-date;
 - [ ] *If I add a new sampler** I added/updated related [examples](https://github.com/blackjax-devs/blackjax/tree/main/examples)

Consider opening a **Draft PR** if your work is still in progress but you would like some feedback from other contributors.
