# Blackjax Governance Document

## The Project
BlackJAX (or Blackjax, we use it interchangeably) is an open-source Bayesian inference library in the JAX scientific computation ecosystem.
Blackjax is designed to prioritize new Bayesian Inference algorithm development, with focus on modularity and ease of use to low level function,
while also being fast and compatible with multi hardwares thanks to JAX.

The Blackjax project was created by [Rémi Louf](https://github.com/rlouf) as a
[Single-Maintainer Houseplant project](https://github.com/OpenTechStrategies/open-source-archetypes/blob/main/arch-houseplant.ltx)
following the BDFL model of governance. We have since moved to the governance model of
[Specialty Library](https://github.com/OpenTechStrategies/open-source-archetypes/blob/main/arch-specialty-library.ltx) and benefited from a community
of contributors. This document outlines the governance structure for the current status.

## Roles
* Contributors: Anyone who contributes to the BlackJAX project is considered a contributor. This includes submitting code, filing issues, reviewing pull requests, and participating in discussions. They are listed under:
   * https://github.com/blackjax-devs/blackjax/graphs/contributors
   * https://github.com/blackjax-devs/sampling-book/graphs/contributors
* Core contributors: Core contributors are contributors who have made significant contributions to the BlackJAX project, for example large modules or functionality.
* Blackjax gardeners: Gardeners are core contributors who are responsible for maintaining the project and making decisions about its future direction. Blackjax gardeners have the ability to merge pull requests into the BlackJAX repository.
   * Currently [junpenglao@](https://github.com/junpenglao) and [albcab@](https://github.com/albcab) are gardeners of Blackjax.


## Responsibility
We cannot hold anyone responsible really since we are all doing free work here, but some general expectations are:
* Contributors are responsible for following the project's code of conduct and contributing to the project in a positive and constructive manner. Contributors are also responsible for testing their code and ensuring that it meets the project's standards.
* Core contributors are expected to review pull requests and provide feedback to contributors. They also make decisions about the architecture and implementation of the module/functionality they contributed to. Also the “if you broke something please fix it” applies.
* Maintainers are responsible for monitoring the benchmark, the documentation and the website are up to date and built passed, update dependency and apply best practice


In addition to these specific responsibilities, all contributors are encouraged to participate in discussions about the project and to help out in any way they can.


## Decision-making
Decisions about the BlackJAX project are made by consensus among the Blackjax gardeners. This means that all Blackjax gardeners must agree on a decision before it can be implemented. If a consensus cannot be reached, we will flip a (virtual) coin.


## Communication
Communication about the BlackJAX project takes place in the following channels:


GitHub issues: Issues are used to track bugs, feature requests, and other tasks.
GitHub discussion: Discussions are used to answer user questions, scope for features, and discuss solutions to bugs.
GitHub pull requests: Pull requests propose changes to the BlackJAX codebase.
Discord: The BlackJAX Discord workspace is used for internal communication about the project for core contributors.


## Contributing
Anyone is welcome to contribute to the BlackJAX project. Contributions can be made in the form of code, documentation, or other forms of support. To learn more about how to contribute, please see the contributing guide.


## Code of conduct
All contributors to the BlackJAX project are expected to follow the project's code of conduct. The code of conduct outlines the expected behavior of contributors and helps to ensure a welcoming and productive environment for all.


## Governance changes
This governance document is subject to change. Changes to the governance document must be approved by consensus among the core contributors.


## Contact
If you have any questions about the BlackJAX project, please feel free to contact the maintainers.
