# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetMaintenanceRunResult',
    'AwaitableGetMaintenanceRunResult',
    'get_maintenance_run',
    'get_maintenance_run_output',
]

@pulumi.output_type
class GetMaintenanceRunResult:
    """
    A collection of values returned by getMaintenanceRun.
    """
    def __init__(__self__, compartment_id=None, current_custom_action_timeout_in_mins=None, current_patching_component=None, custom_action_timeout_in_mins=None, database_software_image_id=None, description=None, display_name=None, estimated_component_patching_start_time=None, estimated_patching_times=None, id=None, is_custom_action_timeout_enabled=None, is_dst_file_update_enabled=None, is_maintenance_run_granular=None, lifecycle_details=None, maintenance_run_id=None, maintenance_subtype=None, maintenance_type=None, patch_failure_count=None, patch_id=None, patch_type=None, patching_end_time=None, patching_mode=None, patching_start_time=None, patching_status=None, peer_maintenance_run_id=None, state=None, target_db_server_version=None, target_resource_id=None, target_resource_type=None, target_storage_server_version=None, time_ended=None, time_scheduled=None, time_started=None, total_time_taken_in_mins=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if current_custom_action_timeout_in_mins and not isinstance(current_custom_action_timeout_in_mins, int):
            raise TypeError("Expected argument 'current_custom_action_timeout_in_mins' to be a int")
        pulumi.set(__self__, "current_custom_action_timeout_in_mins", current_custom_action_timeout_in_mins)
        if current_patching_component and not isinstance(current_patching_component, str):
            raise TypeError("Expected argument 'current_patching_component' to be a str")
        pulumi.set(__self__, "current_patching_component", current_patching_component)
        if custom_action_timeout_in_mins and not isinstance(custom_action_timeout_in_mins, int):
            raise TypeError("Expected argument 'custom_action_timeout_in_mins' to be a int")
        pulumi.set(__self__, "custom_action_timeout_in_mins", custom_action_timeout_in_mins)
        if database_software_image_id and not isinstance(database_software_image_id, str):
            raise TypeError("Expected argument 'database_software_image_id' to be a str")
        pulumi.set(__self__, "database_software_image_id", database_software_image_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if estimated_component_patching_start_time and not isinstance(estimated_component_patching_start_time, str):
            raise TypeError("Expected argument 'estimated_component_patching_start_time' to be a str")
        pulumi.set(__self__, "estimated_component_patching_start_time", estimated_component_patching_start_time)
        if estimated_patching_times and not isinstance(estimated_patching_times, list):
            raise TypeError("Expected argument 'estimated_patching_times' to be a list")
        pulumi.set(__self__, "estimated_patching_times", estimated_patching_times)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_custom_action_timeout_enabled and not isinstance(is_custom_action_timeout_enabled, bool):
            raise TypeError("Expected argument 'is_custom_action_timeout_enabled' to be a bool")
        pulumi.set(__self__, "is_custom_action_timeout_enabled", is_custom_action_timeout_enabled)
        if is_dst_file_update_enabled and not isinstance(is_dst_file_update_enabled, bool):
            raise TypeError("Expected argument 'is_dst_file_update_enabled' to be a bool")
        pulumi.set(__self__, "is_dst_file_update_enabled", is_dst_file_update_enabled)
        if is_maintenance_run_granular and not isinstance(is_maintenance_run_granular, bool):
            raise TypeError("Expected argument 'is_maintenance_run_granular' to be a bool")
        pulumi.set(__self__, "is_maintenance_run_granular", is_maintenance_run_granular)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if maintenance_run_id and not isinstance(maintenance_run_id, str):
            raise TypeError("Expected argument 'maintenance_run_id' to be a str")
        pulumi.set(__self__, "maintenance_run_id", maintenance_run_id)
        if maintenance_subtype and not isinstance(maintenance_subtype, str):
            raise TypeError("Expected argument 'maintenance_subtype' to be a str")
        pulumi.set(__self__, "maintenance_subtype", maintenance_subtype)
        if maintenance_type and not isinstance(maintenance_type, str):
            raise TypeError("Expected argument 'maintenance_type' to be a str")
        pulumi.set(__self__, "maintenance_type", maintenance_type)
        if patch_failure_count and not isinstance(patch_failure_count, int):
            raise TypeError("Expected argument 'patch_failure_count' to be a int")
        pulumi.set(__self__, "patch_failure_count", patch_failure_count)
        if patch_id and not isinstance(patch_id, str):
            raise TypeError("Expected argument 'patch_id' to be a str")
        pulumi.set(__self__, "patch_id", patch_id)
        if patch_type and not isinstance(patch_type, str):
            raise TypeError("Expected argument 'patch_type' to be a str")
        pulumi.set(__self__, "patch_type", patch_type)
        if patching_end_time and not isinstance(patching_end_time, str):
            raise TypeError("Expected argument 'patching_end_time' to be a str")
        pulumi.set(__self__, "patching_end_time", patching_end_time)
        if patching_mode and not isinstance(patching_mode, str):
            raise TypeError("Expected argument 'patching_mode' to be a str")
        pulumi.set(__self__, "patching_mode", patching_mode)
        if patching_start_time and not isinstance(patching_start_time, str):
            raise TypeError("Expected argument 'patching_start_time' to be a str")
        pulumi.set(__self__, "patching_start_time", patching_start_time)
        if patching_status and not isinstance(patching_status, str):
            raise TypeError("Expected argument 'patching_status' to be a str")
        pulumi.set(__self__, "patching_status", patching_status)
        if peer_maintenance_run_id and not isinstance(peer_maintenance_run_id, str):
            raise TypeError("Expected argument 'peer_maintenance_run_id' to be a str")
        pulumi.set(__self__, "peer_maintenance_run_id", peer_maintenance_run_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if target_db_server_version and not isinstance(target_db_server_version, str):
            raise TypeError("Expected argument 'target_db_server_version' to be a str")
        pulumi.set(__self__, "target_db_server_version", target_db_server_version)
        if target_resource_id and not isinstance(target_resource_id, str):
            raise TypeError("Expected argument 'target_resource_id' to be a str")
        pulumi.set(__self__, "target_resource_id", target_resource_id)
        if target_resource_type and not isinstance(target_resource_type, str):
            raise TypeError("Expected argument 'target_resource_type' to be a str")
        pulumi.set(__self__, "target_resource_type", target_resource_type)
        if target_storage_server_version and not isinstance(target_storage_server_version, str):
            raise TypeError("Expected argument 'target_storage_server_version' to be a str")
        pulumi.set(__self__, "target_storage_server_version", target_storage_server_version)
        if time_ended and not isinstance(time_ended, str):
            raise TypeError("Expected argument 'time_ended' to be a str")
        pulumi.set(__self__, "time_ended", time_ended)
        if time_scheduled and not isinstance(time_scheduled, str):
            raise TypeError("Expected argument 'time_scheduled' to be a str")
        pulumi.set(__self__, "time_scheduled", time_scheduled)
        if time_started and not isinstance(time_started, str):
            raise TypeError("Expected argument 'time_started' to be a str")
        pulumi.set(__self__, "time_started", time_started)
        if total_time_taken_in_mins and not isinstance(total_time_taken_in_mins, int):
            raise TypeError("Expected argument 'total_time_taken_in_mins' to be a int")
        pulumi.set(__self__, "total_time_taken_in_mins", total_time_taken_in_mins)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="currentCustomActionTimeoutInMins")
    def current_custom_action_timeout_in_mins(self) -> int:
        """
        Extend current custom action timeout between the current database servers during waiting state, from 0 (zero) to 30 minutes.
        """
        return pulumi.get(self, "current_custom_action_timeout_in_mins")

    @property
    @pulumi.getter(name="currentPatchingComponent")
    def current_patching_component(self) -> str:
        """
        The name of the current infrastruture component that is getting patched.
        """
        return pulumi.get(self, "current_patching_component")

    @property
    @pulumi.getter(name="customActionTimeoutInMins")
    def custom_action_timeout_in_mins(self) -> int:
        """
        Determines the amount of time the system will wait before the start of each database server patching operation. Specify a number of minutes, from 15 to 120.
        """
        return pulumi.get(self, "custom_action_timeout_in_mins")

    @property
    @pulumi.getter(name="databaseSoftwareImageId")
    def database_software_image_id(self) -> str:
        """
        The Autonomous Database Software Image [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        """
        return pulumi.get(self, "database_software_image_id")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the maintenance run.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The user-friendly name for the maintenance run.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="estimatedComponentPatchingStartTime")
    def estimated_component_patching_start_time(self) -> str:
        """
        The estimated start time of the next infrastruture component patching operation.
        """
        return pulumi.get(self, "estimated_component_patching_start_time")

    @property
    @pulumi.getter(name="estimatedPatchingTimes")
    def estimated_patching_times(self) -> Sequence['outputs.GetMaintenanceRunEstimatedPatchingTimeResult']:
        """
        The estimated total time required in minutes for all patching operations (database server, storage server, and network switch patching).
        """
        return pulumi.get(self, "estimated_patching_times")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the maintenance run.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isCustomActionTimeoutEnabled")
    def is_custom_action_timeout_enabled(self) -> bool:
        """
        If true, enables the configuration of a custom action timeout (waiting period) between database servers patching operations.
        """
        return pulumi.get(self, "is_custom_action_timeout_enabled")

    @property
    @pulumi.getter(name="isDstFileUpdateEnabled")
    def is_dst_file_update_enabled(self) -> bool:
        """
        Indicates if an automatic DST Time Zone file update is enabled for the Autonomous Container Database. If enabled along with Release Update, patching will be done in a Non-Rolling manner.
        """
        return pulumi.get(self, "is_dst_file_update_enabled")

    @property
    @pulumi.getter(name="isMaintenanceRunGranular")
    def is_maintenance_run_granular(self) -> bool:
        """
        If `FALSE`, the maintenance run doesn't support granular maintenance.
        """
        return pulumi.get(self, "is_maintenance_run_granular")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maintenanceRunId")
    def maintenance_run_id(self) -> str:
        return pulumi.get(self, "maintenance_run_id")

    @property
    @pulumi.getter(name="maintenanceSubtype")
    def maintenance_subtype(self) -> str:
        """
        Maintenance sub-type.
        """
        return pulumi.get(self, "maintenance_subtype")

    @property
    @pulumi.getter(name="maintenanceType")
    def maintenance_type(self) -> str:
        """
        Maintenance type.
        """
        return pulumi.get(self, "maintenance_type")

    @property
    @pulumi.getter(name="patchFailureCount")
    def patch_failure_count(self) -> int:
        """
        Contain the patch failure count.
        """
        return pulumi.get(self, "patch_failure_count")

    @property
    @pulumi.getter(name="patchId")
    def patch_id(self) -> str:
        """
        The unique identifier of the patch. The identifier string includes the patch type, the Oracle Database version, and the patch creation date (using the format YYMMDD). For example, the identifier `ru_patch_19.9.0.0_201030` is used for an RU patch for Oracle Database 19.9.0.0 that was released October 30, 2020.
        """
        return pulumi.get(self, "patch_id")

    @property
    @pulumi.getter(name="patchType")
    def patch_type(self) -> str:
        return pulumi.get(self, "patch_type")

    @property
    @pulumi.getter(name="patchingEndTime")
    def patching_end_time(self) -> str:
        """
        The time when the patching operation ended.
        """
        return pulumi.get(self, "patching_end_time")

    @property
    @pulumi.getter(name="patchingMode")
    def patching_mode(self) -> str:
        """
        Cloud Exadata infrastructure node patching method, either "ROLLING" or "NONROLLING". Default value is ROLLING.
        """
        return pulumi.get(self, "patching_mode")

    @property
    @pulumi.getter(name="patchingStartTime")
    def patching_start_time(self) -> str:
        """
        The time when the patching operation started.
        """
        return pulumi.get(self, "patching_start_time")

    @property
    @pulumi.getter(name="patchingStatus")
    def patching_status(self) -> str:
        """
        The status of the patching operation.
        """
        return pulumi.get(self, "patching_status")

    @property
    @pulumi.getter(name="peerMaintenanceRunId")
    def peer_maintenance_run_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the maintenance run for the Autonomous Data Guard association's peer container database.
        """
        return pulumi.get(self, "peer_maintenance_run_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the maintenance run. For Autonomous Database Serverless instances, valid states are IN_PROGRESS, SUCCEEDED, and FAILED.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetDbServerVersion")
    def target_db_server_version(self) -> str:
        """
        The target software version for the database server patching operation.
        """
        return pulumi.get(self, "target_db_server_version")

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> str:
        """
        The ID of the target resource on which the maintenance run occurs.
        """
        return pulumi.get(self, "target_resource_id")

    @property
    @pulumi.getter(name="targetResourceType")
    def target_resource_type(self) -> str:
        """
        The type of the target resource on which the maintenance run occurs.
        """
        return pulumi.get(self, "target_resource_type")

    @property
    @pulumi.getter(name="targetStorageServerVersion")
    def target_storage_server_version(self) -> str:
        """
        The target Cell version that is to be patched to.
        """
        return pulumi.get(self, "target_storage_server_version")

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> str:
        """
        The date and time the maintenance run was completed.
        """
        return pulumi.get(self, "time_ended")

    @property
    @pulumi.getter(name="timeScheduled")
    def time_scheduled(self) -> str:
        """
        The date and time the maintenance run is scheduled to occur.
        """
        return pulumi.get(self, "time_scheduled")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> str:
        """
        The date and time the maintenance run starts.
        """
        return pulumi.get(self, "time_started")

    @property
    @pulumi.getter(name="totalTimeTakenInMins")
    def total_time_taken_in_mins(self) -> int:
        """
        The total time taken by corresponding resource activity in minutes.
        """
        return pulumi.get(self, "total_time_taken_in_mins")


class AwaitableGetMaintenanceRunResult(GetMaintenanceRunResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMaintenanceRunResult(
            compartment_id=self.compartment_id,
            current_custom_action_timeout_in_mins=self.current_custom_action_timeout_in_mins,
            current_patching_component=self.current_patching_component,
            custom_action_timeout_in_mins=self.custom_action_timeout_in_mins,
            database_software_image_id=self.database_software_image_id,
            description=self.description,
            display_name=self.display_name,
            estimated_component_patching_start_time=self.estimated_component_patching_start_time,
            estimated_patching_times=self.estimated_patching_times,
            id=self.id,
            is_custom_action_timeout_enabled=self.is_custom_action_timeout_enabled,
            is_dst_file_update_enabled=self.is_dst_file_update_enabled,
            is_maintenance_run_granular=self.is_maintenance_run_granular,
            lifecycle_details=self.lifecycle_details,
            maintenance_run_id=self.maintenance_run_id,
            maintenance_subtype=self.maintenance_subtype,
            maintenance_type=self.maintenance_type,
            patch_failure_count=self.patch_failure_count,
            patch_id=self.patch_id,
            patch_type=self.patch_type,
            patching_end_time=self.patching_end_time,
            patching_mode=self.patching_mode,
            patching_start_time=self.patching_start_time,
            patching_status=self.patching_status,
            peer_maintenance_run_id=self.peer_maintenance_run_id,
            state=self.state,
            target_db_server_version=self.target_db_server_version,
            target_resource_id=self.target_resource_id,
            target_resource_type=self.target_resource_type,
            target_storage_server_version=self.target_storage_server_version,
            time_ended=self.time_ended,
            time_scheduled=self.time_scheduled,
            time_started=self.time_started,
            total_time_taken_in_mins=self.total_time_taken_in_mins)


def get_maintenance_run(maintenance_run_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMaintenanceRunResult:
    """
    This data source provides details about a specific Maintenance Run resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified maintenance run.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_maintenance_run = oci.Database.get_maintenance_run(maintenance_run_id=test_maintenance_run_oci_database_maintenance_run["id"])
    ```


    :param str maintenance_run_id: The maintenance run OCID.
    """
    __args__ = dict()
    __args__['maintenanceRunId'] = maintenance_run_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getMaintenanceRun:getMaintenanceRun', __args__, opts=opts, typ=GetMaintenanceRunResult).value

    return AwaitableGetMaintenanceRunResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        current_custom_action_timeout_in_mins=pulumi.get(__ret__, 'current_custom_action_timeout_in_mins'),
        current_patching_component=pulumi.get(__ret__, 'current_patching_component'),
        custom_action_timeout_in_mins=pulumi.get(__ret__, 'custom_action_timeout_in_mins'),
        database_software_image_id=pulumi.get(__ret__, 'database_software_image_id'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        estimated_component_patching_start_time=pulumi.get(__ret__, 'estimated_component_patching_start_time'),
        estimated_patching_times=pulumi.get(__ret__, 'estimated_patching_times'),
        id=pulumi.get(__ret__, 'id'),
        is_custom_action_timeout_enabled=pulumi.get(__ret__, 'is_custom_action_timeout_enabled'),
        is_dst_file_update_enabled=pulumi.get(__ret__, 'is_dst_file_update_enabled'),
        is_maintenance_run_granular=pulumi.get(__ret__, 'is_maintenance_run_granular'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        maintenance_run_id=pulumi.get(__ret__, 'maintenance_run_id'),
        maintenance_subtype=pulumi.get(__ret__, 'maintenance_subtype'),
        maintenance_type=pulumi.get(__ret__, 'maintenance_type'),
        patch_failure_count=pulumi.get(__ret__, 'patch_failure_count'),
        patch_id=pulumi.get(__ret__, 'patch_id'),
        patch_type=pulumi.get(__ret__, 'patch_type'),
        patching_end_time=pulumi.get(__ret__, 'patching_end_time'),
        patching_mode=pulumi.get(__ret__, 'patching_mode'),
        patching_start_time=pulumi.get(__ret__, 'patching_start_time'),
        patching_status=pulumi.get(__ret__, 'patching_status'),
        peer_maintenance_run_id=pulumi.get(__ret__, 'peer_maintenance_run_id'),
        state=pulumi.get(__ret__, 'state'),
        target_db_server_version=pulumi.get(__ret__, 'target_db_server_version'),
        target_resource_id=pulumi.get(__ret__, 'target_resource_id'),
        target_resource_type=pulumi.get(__ret__, 'target_resource_type'),
        target_storage_server_version=pulumi.get(__ret__, 'target_storage_server_version'),
        time_ended=pulumi.get(__ret__, 'time_ended'),
        time_scheduled=pulumi.get(__ret__, 'time_scheduled'),
        time_started=pulumi.get(__ret__, 'time_started'),
        total_time_taken_in_mins=pulumi.get(__ret__, 'total_time_taken_in_mins'))
def get_maintenance_run_output(maintenance_run_id: Optional[pulumi.Input[str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMaintenanceRunResult]:
    """
    This data source provides details about a specific Maintenance Run resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified maintenance run.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_maintenance_run = oci.Database.get_maintenance_run(maintenance_run_id=test_maintenance_run_oci_database_maintenance_run["id"])
    ```


    :param str maintenance_run_id: The maintenance run OCID.
    """
    __args__ = dict()
    __args__['maintenanceRunId'] = maintenance_run_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getMaintenanceRun:getMaintenanceRun', __args__, opts=opts, typ=GetMaintenanceRunResult)
    return __ret__.apply(lambda __response__: GetMaintenanceRunResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        current_custom_action_timeout_in_mins=pulumi.get(__response__, 'current_custom_action_timeout_in_mins'),
        current_patching_component=pulumi.get(__response__, 'current_patching_component'),
        custom_action_timeout_in_mins=pulumi.get(__response__, 'custom_action_timeout_in_mins'),
        database_software_image_id=pulumi.get(__response__, 'database_software_image_id'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        estimated_component_patching_start_time=pulumi.get(__response__, 'estimated_component_patching_start_time'),
        estimated_patching_times=pulumi.get(__response__, 'estimated_patching_times'),
        id=pulumi.get(__response__, 'id'),
        is_custom_action_timeout_enabled=pulumi.get(__response__, 'is_custom_action_timeout_enabled'),
        is_dst_file_update_enabled=pulumi.get(__response__, 'is_dst_file_update_enabled'),
        is_maintenance_run_granular=pulumi.get(__response__, 'is_maintenance_run_granular'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        maintenance_run_id=pulumi.get(__response__, 'maintenance_run_id'),
        maintenance_subtype=pulumi.get(__response__, 'maintenance_subtype'),
        maintenance_type=pulumi.get(__response__, 'maintenance_type'),
        patch_failure_count=pulumi.get(__response__, 'patch_failure_count'),
        patch_id=pulumi.get(__response__, 'patch_id'),
        patch_type=pulumi.get(__response__, 'patch_type'),
        patching_end_time=pulumi.get(__response__, 'patching_end_time'),
        patching_mode=pulumi.get(__response__, 'patching_mode'),
        patching_start_time=pulumi.get(__response__, 'patching_start_time'),
        patching_status=pulumi.get(__response__, 'patching_status'),
        peer_maintenance_run_id=pulumi.get(__response__, 'peer_maintenance_run_id'),
        state=pulumi.get(__response__, 'state'),
        target_db_server_version=pulumi.get(__response__, 'target_db_server_version'),
        target_resource_id=pulumi.get(__response__, 'target_resource_id'),
        target_resource_type=pulumi.get(__response__, 'target_resource_type'),
        target_storage_server_version=pulumi.get(__response__, 'target_storage_server_version'),
        time_ended=pulumi.get(__response__, 'time_ended'),
        time_scheduled=pulumi.get(__response__, 'time_scheduled'),
        time_started=pulumi.get(__response__, 'time_started'),
        total_time_taken_in_mins=pulumi.get(__response__, 'total_time_taken_in_mins')))
