# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetOccDemandSignalResult',
    'AwaitableGetOccDemandSignalResult',
    'get_occ_demand_signal',
    'get_occ_demand_signal_output',
]

@pulumi.output_type
class GetOccDemandSignalResult:
    """
    A collection of values returned by getOccDemandSignal.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, is_active=None, lifecycle_details=None, occ_demand_signal_id=None, occ_demand_signals=None, patch_operations=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_active and not isinstance(is_active, bool):
            raise TypeError("Expected argument 'is_active' to be a bool")
        pulumi.set(__self__, "is_active", is_active)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if occ_demand_signal_id and not isinstance(occ_demand_signal_id, str):
            raise TypeError("Expected argument 'occ_demand_signal_id' to be a str")
        pulumi.set(__self__, "occ_demand_signal_id", occ_demand_signal_id)
        if occ_demand_signals and not isinstance(occ_demand_signals, list):
            raise TypeError("Expected argument 'occ_demand_signals' to be a list")
        pulumi.set(__self__, "occ_demand_signals", occ_demand_signals)
        if patch_operations and not isinstance(patch_operations, list):
            raise TypeError("Expected argument 'patch_operations' to be a list")
        pulumi.set(__self__, "patch_operations", patch_operations)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the OccDemandSignal.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> bool:
        """
        Indicator of whether to share the data with Oracle.
        """
        return pulumi.get(self, "is_active")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message that describes the current state of the OccDemandSignal in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="occDemandSignalId")
    def occ_demand_signal_id(self) -> str:
        return pulumi.get(self, "occ_demand_signal_id")

    @property
    @pulumi.getter(name="occDemandSignals")
    def occ_demand_signals(self) -> Sequence['outputs.GetOccDemandSignalOccDemandSignalResult']:
        """
        The OccDemandSignal data.
        """
        return pulumi.get(self, "occ_demand_signals")

    @property
    @pulumi.getter(name="patchOperations")
    def patch_operations(self) -> Sequence['outputs.GetOccDemandSignalPatchOperationResult']:
        return pulumi.get(self, "patch_operations")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the OccDemandSignal.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the OccDemandSignal was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the OccDemandSignal was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetOccDemandSignalResult(GetOccDemandSignalResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOccDemandSignalResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_active=self.is_active,
            lifecycle_details=self.lifecycle_details,
            occ_demand_signal_id=self.occ_demand_signal_id,
            occ_demand_signals=self.occ_demand_signals,
            patch_operations=self.patch_operations,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_occ_demand_signal(occ_demand_signal_id: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOccDemandSignalResult:
    """
    This data source provides details about a specific Occ Demand Signal resource in Oracle Cloud Infrastructure Demand Signal service.

    Gets information about a OccDemandSignal.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_occ_demand_signal = oci.DemandSignal.get_occ_demand_signal(occ_demand_signal_id=test_occ_demand_signal_oci_demand_signal_occ_demand_signal["id"])
    ```


    :param str occ_demand_signal_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the OccDemandSignal.
    """
    __args__ = dict()
    __args__['occDemandSignalId'] = occ_demand_signal_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DemandSignal/getOccDemandSignal:getOccDemandSignal', __args__, opts=opts, typ=GetOccDemandSignalResult).value

    return AwaitableGetOccDemandSignalResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_active=pulumi.get(__ret__, 'is_active'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        occ_demand_signal_id=pulumi.get(__ret__, 'occ_demand_signal_id'),
        occ_demand_signals=pulumi.get(__ret__, 'occ_demand_signals'),
        patch_operations=pulumi.get(__ret__, 'patch_operations'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_occ_demand_signal_output(occ_demand_signal_id: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOccDemandSignalResult]:
    """
    This data source provides details about a specific Occ Demand Signal resource in Oracle Cloud Infrastructure Demand Signal service.

    Gets information about a OccDemandSignal.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_occ_demand_signal = oci.DemandSignal.get_occ_demand_signal(occ_demand_signal_id=test_occ_demand_signal_oci_demand_signal_occ_demand_signal["id"])
    ```


    :param str occ_demand_signal_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the OccDemandSignal.
    """
    __args__ = dict()
    __args__['occDemandSignalId'] = occ_demand_signal_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DemandSignal/getOccDemandSignal:getOccDemandSignal', __args__, opts=opts, typ=GetOccDemandSignalResult)
    return __ret__.apply(lambda __response__: GetOccDemandSignalResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_active=pulumi.get(__response__, 'is_active'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        occ_demand_signal_id=pulumi.get(__response__, 'occ_demand_signal_id'),
        occ_demand_signals=pulumi.get(__response__, 'occ_demand_signals'),
        patch_operations=pulumi.get(__response__, 'patch_operations'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
