import { Container } from './container';
import * as k8s from './imports/k8s';
import { ConnectionScheme } from './probe';
/**
 * Utility class to implement the conversion between our API and the k8s action
 * structure. Used both for probes and handlers.
 *
 * @internal
 */
export declare class Action {
    static fromTcpSocket(container: Container, options?: {
        port?: number;
        host?: string;
    }): k8s.TcpSocketAction;
    static fromCommand(command: string[]): k8s.ExecAction;
    static fromHttpGet(container: Container, path: string, options?: {
        port?: number;
        scheme?: ConnectionScheme;
    }): k8s.HttpGetAction;
}
