"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.address = exports.filterUndefined = exports.undefinedIfEmpty = void 0;
function undefinedIfEmpty(obj) {
    if (typeof (obj) === 'string' && obj === '') {
        return undefined;
    }
    if (Array.isArray(obj) && obj.length === 0) {
        return undefined;
    }
    if (typeof (obj) === 'object' && (Object.keys(obj).length === 0 || Object.values(obj).filter(x => x).length === 0)) {
        return undefined;
    }
    return obj;
}
exports.undefinedIfEmpty = undefinedIfEmpty;
function filterUndefined(obj) {
    const ret = {};
    for (const [k, v] of Object.entries(obj)) {
        if (v !== undefined) {
            ret[k] = v;
        }
    }
    return ret;
}
exports.filterUndefined = filterUndefined;
function address(...constructs) {
    const addresses = constructs
        .map(c => c.node.addr)
        .sort((a, b) => a.localeCompare(b));
    return addresses.join('');
}
exports.address = address;
//# sourceMappingURL=data:application/json;base64,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