import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_GetDeploymentCommand, se_GetDeploymentCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class GetDeploymentCommand extends $Command
    .classBuilder()
    .ep({
    ...commonParams,
})
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CodeDeploy_20141006", "GetDeployment", {})
    .n("CodeDeployClient", "GetDeploymentCommand")
    .f(void 0, void 0)
    .ser(se_GetDeploymentCommand)
    .de(de_GetDeploymentCommand)
    .build() {
}
