"""
Module containing implementation of SynthonSpace search of Synthon-based chemical libraries such as Enamine REAL.  NOTE: This functionality is experimental and the API and/or results may change in future releases.
"""
from __future__ import annotations
import typing
__all__ = ['ConvertTextToDBFile', 'FormattedIntegerString', 'SubstructureResult', 'SynthonSpace', 'SynthonSpaceSearchParams']
class SubstructureResult(Boost.Python.instance):
    """
    Used to return results of SynthonSpace searches.
    """
    @staticmethod
    def GetCancelled(arg1: SubstructureResult) -> bool:
        """
            Returns whether the search was cancelled or not.
        
            C++ signature :
                bool GetCancelled(class RDKit::SynthonSpaceSearch::SearchResults {lvalue})
        """
    @staticmethod
    def GetMaxNumResults(arg1: SubstructureResult) -> int:
        """
            The upper bound on number of results possible.  There may be fewer than this in practice for several reasons such as duplicate reagent sets being removed or the final product not matching the query even though the synthons suggested they would.
        
            C++ signature :
                unsigned __int64 GetMaxNumResults(class RDKit::SynthonSpaceSearch::SearchResults {lvalue})
        """
    @staticmethod
    def GetTimedOut(arg1: SubstructureResult) -> bool:
        """
            Returns whether the search timed out or not.
        
            C++ signature :
                bool GetTimedOut(class RDKit::SynthonSpaceSearch::SearchResults {lvalue})
        """
    @staticmethod
    def __init__(*args, **kwargs):
        """
        Raises an exception
        This class cannot be instantiated from Python
        """
    @staticmethod
    def __reduce__(*args, **kwargs):
        ...
    def GetHitMolecules(self) -> list:
        """
            A function returning hits from the search
        
            C++ signature :
                class boost::python::list GetHitMolecules(class RDKit::SynthonSpaceSearch::SearchResults)
        """
class SynthonSpace(Boost.Python.instance):
    """
    SynthonSpaceSearch object.
    """
    __instance_size__: typing.ClassVar[int] = 160
    @staticmethod
    def __reduce__(*args, **kwargs):
        ...
    def BuildSynthonFingerprints(self, fingerprintGenerator: typing.Any) -> None:
        """
            Build the synthon fingerprints ready for similarity searching.  This is done automatically when the first similarity search is done, but if converting a text file to binary format it might need to be done explicitly.
        
            C++ signature :
                void BuildSynthonFingerprints(class RDKit::SynthonSpaceSearch::SynthonSpace {lvalue},class RDKit::FingerprintGenerator<unsigned __int64>)
        """
    def FingerprintSearch(self, query: Mol, fingerprintGenerator: typing.Any, params: typing.Any = None) -> SubstructureResult:
        """
            Does a fingerprint search in the SynthonSpace using the FingerprintGenerator passed in.
        
            C++ signature :
                class RDKit::SynthonSpaceSearch::SearchResults FingerprintSearch(class RDKit::SynthonSpaceSearch::SynthonSpace {lvalue},class RDKit::ROMol,class boost::python::api::object [,class boost::python::api::object=None])
        """
    def GetNumProducts(self) -> int:
        """
            Returns number of products in the SynthonSpace, with multiple counting of any duplicates.
        
            C++ signature :
                unsigned __int64 GetNumProducts(class RDKit::SynthonSpaceSearch::SynthonSpace {lvalue})
        """
    def GetNumReactions(self) -> int:
        """
            Returns number of reactions in the SynthonSpace.
        
            C++ signature :
                unsigned __int64 GetNumReactions(class RDKit::SynthonSpaceSearch::SynthonSpace {lvalue})
        """
    def GetSynthonFingerprintType(self) -> str:
        """
            Returns the information string for the fingerprint generator used to create this space.
        
            C++ signature :
                class std::basic_string<char,struct std::char_traits<char>,class std::allocator<char> > GetSynthonFingerprintType(class RDKit::SynthonSpaceSearch::SynthonSpace {lvalue})
        """
    def RascalSearch(self, query: Mol, rascalOptions: typing.Any, params: typing.Any = None) -> SubstructureResult:
        """
            Does a search using the Rascal similarity score.  The similarity threshold used is provided by rascalOptions, and the one in params is ignored.
        
            C++ signature :
                class RDKit::SynthonSpaceSearch::SearchResults RascalSearch(class RDKit::SynthonSpaceSearch::SynthonSpace {lvalue},class RDKit::ROMol,class boost::python::api::object [,class boost::python::api::object=None])
        """
    def ReadDBFile(self, inFile: str, numThreads: int = 1) -> None:
        """
            Reads binary database file.  Takes optional number of threads,default=1.
        
            C++ signature :
                void ReadDBFile(class RDKit::SynthonSpaceSearch::SynthonSpace {lvalue},class std::basic_string<char,struct std::char_traits<char>,class std::allocator<char> > [,int=1])
        """
    def ReadTextFile(self, inFile: str) -> None:
        """
            Reads text file of the sort used by ChemSpace/Enamine.
        
            C++ signature :
                void ReadTextFile(class RDKit::SynthonSpaceSearch::SynthonSpace {lvalue},class std::basic_string<char,struct std::char_traits<char>,class std::allocator<char> >)
        """
    @typing.overload
    def SubstructureSearch(self, query: Mol, substructMatchParams: typing.Any = None, params: typing.Any = None) -> SubstructureResult:
        """
            Does a substructure search in the SynthonSpace.
        
            C++ signature :
                class RDKit::SynthonSpaceSearch::SearchResults SubstructureSearch(class RDKit::SynthonSpaceSearch::SynthonSpace {lvalue},class RDKit::ROMol [,class boost::python::api::object=None [,class boost::python::api::object=None]])
        """
    @typing.overload
    def SubstructureSearch(self, query: typing.Any, substructMatchParams: typing.Any = None, params: typing.Any = None) -> SubstructureResult:
        """
            Does a substructure search in the SynthonSpace using an extended query.
        
            C++ signature :
                class RDKit::SynthonSpaceSearch::SearchResults SubstructureSearch(class RDKit::SynthonSpaceSearch::SynthonSpace {lvalue},struct RDKit::GeneralizedSubstruct::ExtendedQueryMol [,class boost::python::api::object=None [,class boost::python::api::object=None]])
        """
    def Summarise(self) -> None:
        """
            Writes a summary of the SynthonSpace to stdout.
        
            C++ signature :
                void Summarise(class RDKit::SynthonSpaceSearch::SynthonSpace {lvalue})
        """
    def WriteDBFile(self, outFile: str) -> None:
        """
            Writes binary database file.
        
            C++ signature :
                void WriteDBFile(class RDKit::SynthonSpaceSearch::SynthonSpace {lvalue},class std::basic_string<char,struct std::char_traits<char>,class std::allocator<char> >)
        """
    def WriteEnumeratedFile(self, outFile: str) -> None:
        """
            Writes enumerated library to file.
        
            C++ signature :
                void WriteEnumeratedFile(class RDKit::SynthonSpaceSearch::SynthonSpace {lvalue},class std::basic_string<char,struct std::char_traits<char>,class std::allocator<char> >)
        """
    def __init__(self) -> None:
        """
            C++ signature :
                void __init__(struct _object * __ptr64)
        """
class SynthonSpaceSearchParams(Boost.Python.instance):
    """
    SynthonSpaceSearch parameters.
    """
    __instance_size__: typing.ClassVar[int] = 112
    @staticmethod
    def __reduce__(*args, **kwargs):
        ...
    def __init__(self) -> None:
        """
            C++ signature :
                void __init__(struct _object * __ptr64)
        """
    @property
    def approxSimilarityAdjuster(*args, **kwargs):
        """
        The fingerprint search uses an approximate similarity method before building a product and doing a final check.  The similarityCutoff is reduced by this value for the approximate check.  A lower value will give faster run times at the risk of missing some hits.  The value you use should have a positive correlation with your FOMO.  The default of 0.1 is appropriate for Morgan fingerprints.  With RDKit fingerprints, 0.05 is adequate, and higher than that has been seen to produce long run times.
        """
    @approxSimilarityAdjuster.setter
    def approxSimilarityAdjuster(*args, **kwargs):
        ...
    @property
    def buildHits(*args, **kwargs):
        """
        If false, reports the maximum number of hits that the search could produce, but doesn't return them.
        """
    @buildHits.setter
    def buildHits(*args, **kwargs):
        ...
    @property
    def fragSimilarityAdjuster(*args, **kwargs):
        """
        Similarities of fragments are generally low due to low bit densities.  For the fragment matching, reduce the similarity cutoff off by this amount.  Default=0.1.
        """
    @fragSimilarityAdjuster.setter
    def fragSimilarityAdjuster(*args, **kwargs):
        ...
    @property
    def hitStart(*args, **kwargs):
        """
        The sequence number of the hit to start from.  So that you can return the next N hits of a search having already obtained N-1.  Default=0
        """
    @hitStart.setter
    def hitStart(*args, **kwargs):
        ...
    @property
    def maxHits(*args, **kwargs):
        """
        The maximum number of hits to return.  Default=1000.Use -1 for no maximum.
        """
    @maxHits.setter
    def maxHits(*args, **kwargs):
        ...
    @property
    def maxNumFrags(*args, **kwargs):
        """
        The maximum number of fragments the query can be broken into.  Big molecules will create huge numbers of fragments that may cause excessive memory use.  If the number of fragments hits this number, fragmentation stops and the search results will likely be incomplete.  Default=100000.
        """
    @maxNumFrags.setter
    def maxNumFrags(*args, **kwargs):
        ...
    @property
    def numRandomSweeps(*args, **kwargs):
        """
        The random sampling doesn't always produce the required number of hits in 1 go.  This parameter controls how many loops it makes to try and get the hits before giving up.  Default=10.
        """
    @numRandomSweeps.setter
    def numRandomSweeps(*args, **kwargs):
        ...
    @property
    def numThreads(*args, **kwargs):
        """
        The number of threads to use for search.  If > 0, will use that number.  If <= 0, will use the number of hardware threads plus this number.  So if the number of hardware threads is 8, and numThreads is -1, it will use 7 threads.  Default=1.
        """
    @numThreads.setter
    def numThreads(*args, **kwargs):
        ...
    @property
    def randomSample(*args, **kwargs):
        """
        If True, returns a random sample of the hits, up to maxHits in number.  Default=False.
        """
    @randomSample.setter
    def randomSample(*args, **kwargs):
        ...
    @property
    def randomSeed(*args, **kwargs):
        """
        If using randomSample, this seeds the random number generator so as to give reproducible results.  Default=-1 means use a random seed.
        """
    @randomSeed.setter
    def randomSeed(*args, **kwargs):
        ...
    @property
    def similarityCutoff(*args, **kwargs):
        """
        Similarity cutoff for returning hits by fingerprint similarity.  At present the fp is hard-coded to be Morgan, bits, radius=2.  Default=0.5.
        """
    @similarityCutoff.setter
    def similarityCutoff(*args, **kwargs):
        ...
    @property
    def timeOut(*args, **kwargs):
        """
        Time limit for search, in seconds.  Default is 600s, 0 means no timeout.  Requires an integer
        """
    @timeOut.setter
    def timeOut(*args, **kwargs):
        ...
def ConvertTextToDBFile(inFilename: str, outFilename: str, fpGen: typing.Any = None) -> None:
    """
        Convert the text file into the binary DB file in our format.  Assumes that all synthons from a reaction are contiguous in the input file.  This uses a lot less memory than using ReadTextFile() followed by  WriteDBFile().- inFilename the name of the text file- outFilename the name of the binary file- optional fingerprint generator
    
        C++ signature :
            void ConvertTextToDBFile(class std::basic_string<char,struct std::char_traits<char>,class std::allocator<char> >,class std::basic_string<char,struct std::char_traits<char>,class std::allocator<char> > [,class boost::python::api::object=None])
    """
def FormattedIntegerString(value: int) -> str:
    """
        Format an integer with spaces every 3 digits for ease of reading
    
        C++ signature :
            class std::basic_string<char,struct std::char_traits<char>,class std::allocator<char> > FormattedIntegerString(__int64)
    """
